/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.util.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.compass.core.util.concurrent.ForceQueuePolicy;
import org.compass.core.util.concurrent.ScalingQueue;
import org.compass.core.util.concurrent.ScalingThreadPoolExecutor;
import org.compass.core.util.concurrent.TimedBlockingPolicy;

public class ScalingExecutros {
    public static ExecutorService newScalingThreadPool(int min, int max, long keepAliveTime) {
        ScalingQueue<Runnable> queue = new ScalingQueue<Runnable>();
        ScalingThreadPoolExecutor executor = new ScalingThreadPoolExecutor(min, max, keepAliveTime, TimeUnit.MILLISECONDS, queue);
        executor.setRejectedExecutionHandler(new ForceQueuePolicy());
        queue.setThreadPoolExecutor(executor);
        return executor;
    }

    public static ExecutorService newScalingThreadPool(int min, int max, long keepAliveTime, ThreadFactory threadFactory) {
        ExecutorService executorService = ScalingExecutros.newScalingThreadPool(min, max, keepAliveTime);
        ((ThreadPoolExecutor)executorService).setThreadFactory(threadFactory);
        return executorService;
    }

    public static ExecutorService newBlockingThreadPool(int min, int max, long keepAliveTime, int capacity, long waitTime) {
        ScalingQueue<Runnable> queue = new ScalingQueue<Runnable>(capacity);
        ScalingThreadPoolExecutor executor = new ScalingThreadPoolExecutor(min, max, keepAliveTime, TimeUnit.MILLISECONDS, queue);
        executor.setRejectedExecutionHandler(new TimedBlockingPolicy(waitTime));
        queue.setThreadPoolExecutor(executor);
        return executor;
    }

    public static ExecutorService newBlockingThreadPool(int min, int max, long keepAliveTime, int capacity, long waitTime, ThreadFactory threadFactory) {
        ExecutorService executorService = ScalingExecutros.newBlockingThreadPool(min, max, keepAliveTime, capacity, waitTime);
        ((ThreadPoolExecutor)executorService).setThreadFactory(threadFactory);
        return executorService;
    }

    public static ThreadFactory daemonThreadFactory(String namePrefix) {
        final ThreadFactory f = Executors.defaultThreadFactory();
        final String o = namePrefix + "-";
        return new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = f.newThread(r);
                t.setName(o + t.getName());
                t.setDaemon(true);
                return t;
            }
        };
    }

    public static ThreadFactory priorityThreadFactory(int priority, String namePrefix) {
        final ThreadFactory f = ScalingExecutros.daemonThreadFactory(namePrefix);
        final int p = priority;
        return new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = f.newThread(r);
                if (p != 5) {
                    t.setPriority(p);
                }
                return t;
            }
        };
    }

    private ScalingExecutros() {
    }
}

