/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.gps.CompassGps;
import org.compass.gps.CompassGpsDevice;
import org.compass.gps.CompassGpsException;
import org.compass.gps.IndexPlan;

public class AbstractGpsDeviceWrapper
implements CompassGpsDevice {
    protected Log log = LogFactory.getLog(this.getClass());
    protected CompassGpsDevice gpsDevice;

    public void setGpsDevice(CompassGpsDevice gpsDevice) {
        this.gpsDevice = gpsDevice;
    }

    public CompassGps getGps() {
        this.checkDeviceSet();
        return this.gpsDevice.getGps();
    }

    public void injectGps(CompassGps compassGps) {
        this.checkDeviceSet();
        this.gpsDevice.injectGps(compassGps);
    }

    public String getName() {
        this.checkDeviceSet();
        return this.gpsDevice.getName();
    }

    public void setName(String name) {
        this.checkDeviceSet();
        this.gpsDevice.setName(name);
    }

    public void start() throws CompassGpsException {
        this.checkDeviceSet();
        this.gpsDevice.start();
    }

    public void stop() throws CompassGpsException {
        this.checkDeviceSet();
        this.gpsDevice.stop();
    }

    public void refresh() throws CompassGpsException {
        this.checkDeviceSet();
        this.gpsDevice.refresh();
    }

    public void index(IndexPlan indexPlan) throws CompassGpsException, IllegalStateException {
        this.checkDeviceSet();
        this.gpsDevice.index(indexPlan);
    }

    public boolean isRunning() {
        this.checkDeviceSet();
        return this.gpsDevice.isRunning();
    }

    public boolean isPerformingIndexOperation() {
        this.checkDeviceSet();
        return this.gpsDevice.isPerformingIndexOperation();
    }

    public boolean shouldMirrorDataChanges() {
        this.checkDeviceSet();
        return this.gpsDevice.shouldMirrorDataChanges();
    }

    protected void checkDeviceSet() {
        if (this.gpsDevice == null) {
            throw new IllegalStateException("Must set the wrapped device first");
        }
    }
}

