/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.terracotta;

import java.io.IOException;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockObtainFailedException;

public class ManagedTerracottaLockAdapter
extends Lock {
    private final ReadWriteLock rwl;
    private final Lock lock;

    public ManagedTerracottaLockAdapter(ReadWriteLock rwl, Lock lock) {
        this.rwl = rwl;
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean obtain(long lockWaitTimeout) throws LockObtainFailedException, IOException {
        boolean unlocked;
        try {
            this.rwl.readLock().unlock();
            unlocked = true;
        }
        catch (IllegalMonitorStateException e) {
            unlocked = false;
        }
        try {
            boolean bl = this.lock.obtain(lockWaitTimeout);
            return bl;
        }
        finally {
            if (unlocked) {
                this.rwl.readLock().lock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean obtain() throws IOException {
        boolean unlocked;
        try {
            this.rwl.readLock().unlock();
            unlocked = true;
        }
        catch (IllegalMonitorStateException e) {
            unlocked = false;
        }
        try {
            boolean bl = this.lock.obtain();
            return bl;
        }
        finally {
            if (unlocked) {
                this.rwl.readLock().lock();
            }
        }
    }

    public void release() throws IOException {
        this.lock.release();
    }

    public boolean isLocked() {
        return this.lock.isLocked();
    }
}

