/*
 * Decompiled with CFR 0.152.
 */
package org.compass.spring.aop;

import org.compass.core.Compass;
import org.compass.core.CompassTemplate;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractCompassInterceptor
implements InitializingBean {
    private Compass compass;
    protected CompassTemplate compassTemplate;
    private int parameterIndex = 0;
    private boolean useReturnValue = false;

    public void afterPropertiesSet() throws Exception {
        if (this.compass == null) {
            throw new IllegalArgumentException("compass property is required");
        }
        this.compassTemplate = new CompassTemplate(this.compass);
    }

    protected Object findObject(Object returnValue, Object[] args) {
        if (this.useReturnValue) {
            return returnValue;
        }
        if (this.parameterIndex >= args.length) {
            throw new IllegalArgumentException("Set parameter index [" + this.parameterIndex + "] for a method with [" + args.length + "] arguments");
        }
        return args[this.parameterIndex];
    }

    public Compass getCompass() {
        return this.compass;
    }

    public void setCompass(Compass compass) {
        this.compass = compass;
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    public void setParameterIndex(int parameterIndex) {
        this.parameterIndex = parameterIndex;
    }

    public boolean isUseReturnValue() {
        return this.useReturnValue;
    }

    public void setUseReturnValue(boolean useReturnValue) {
        this.useReturnValue = useReturnValue;
    }
}

