/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access;

import java.util.ArrayList;
import java.util.List;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityConfig
implements ConfigAttribute {
    private String attrib;

    public SecurityConfig(String config) {
        Assert.hasText((String)config, (String)"You must provide a configuration attribute");
        this.attrib = config;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConfigAttribute) {
            ConfigAttribute attr = (ConfigAttribute)obj;
            return this.attrib.equals(attr.getAttribute());
        }
        return false;
    }

    @Override
    public String getAttribute() {
        return this.attrib;
    }

    public int hashCode() {
        return this.attrib.hashCode();
    }

    public String toString() {
        return this.attrib;
    }

    public static final List<ConfigAttribute> createListFromCommaDelimitedString(String access) {
        return SecurityConfig.createList(StringUtils.commaDelimitedListToStringArray((String)access));
    }

    public static final List<ConfigAttribute> createList(String ... attributeNames) {
        Assert.notNull((Object)attributeNames, (String)"You must supply a list of argument names");
        ArrayList<ConfigAttribute> attributes = new ArrayList<ConfigAttribute>(attributeNames.length);
        for (String attribute : attributeNames) {
            attributes.add(new SecurityConfig(attribute));
        }
        return attributes;
    }
}

