/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.noticeRule.service;

import com.sinba.common.dto.PageDTO;
import com.sinba.common.noticeRule.dao.INoticeRuleDAO;
import com.sinba.common.noticeRule.dto.EmailTemplatesDTO;
import com.sinba.common.noticeRule.dto.NoticeInfoDTO;
import com.sinba.common.noticeRule.dto.NoticeRuleDTO;
import com.sinba.common.noticeRule.dto.UserContactInfoDTO;
import com.sinba.common.noticeRule.entity.NoticeRule;
import com.sinba.common.noticeRule.service.EmailTemplateService;
import com.sinba.common.noticeRule.service.INoticeRuleService;
import com.sinba.common.security.dao.IUserDAO;
import com.sinba.common.security.dto.UserQueryDTO;
import com.sinba.common.security.entity.User;
import com.sinba.common.tools.dto.EmailDTO;
import com.sinba.common.tools.dto.HistoryRecordDTO;
import com.sinba.common.tools.service.IEmailService;
import com.sinba.common.tools.service.IHistoryRecordService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoticeRuleService
implements INoticeRuleService {
    private static final Logger LOGGER = Logger.getLogger(NoticeRuleService.class);
    @Autowired
    private INoticeRuleDAO noticeRuleDAO;
    @Autowired
    private IUserDAO userDAO;
    @Autowired
    private IEmailService emailService;
    @Autowired
    private IHistoryRecordService historyRecordService;
    private EmailTemplateService emailTemplateService = new EmailTemplateService();

    @Override
    @Transactional
    public PageDTO findPagerNoticeRule(NoticeRuleDTO noticeRuleDTO, int start, int limit, String sord, String sidx) {
        PageDTO page = this.noticeRuleDAO.findPager(noticeRuleDTO, start, limit, sord, sidx);
        List entities = page.getData();
        ArrayList<NoticeRuleDTO> dtos = new ArrayList<NoticeRuleDTO>(entities.size());
        for (NoticeRule entity : entities) {
            NoticeRuleDTO dto = new NoticeRuleDTO();
            NoticeRuleDTO.entity2dto((Object)((Object)entity), (Object)((Object)dto));
            if (entity.getUsers() != null) {
                String userString = null;
                for (User user : entity.getUsers()) {
                    if (userString == null) {
                        userString = user.getLoginName();
                        continue;
                    }
                    userString = userString + ";" + user.getLoginName();
                }
                dto.setTechnician(userString);
            }
            dtos.add(dto);
        }
        page.setData(dtos);
        return page;
    }

    @Override
    @Transactional
    public void updateNoticeRule(NoticeRuleDTO noticeRuleDTO) {
        NoticeRule noticeRule = (NoticeRule)((Object)this.noticeRuleDAO.findUniqueBy("noticeRuleNo", noticeRuleDTO.getNoticeRuleNo()));
        if (noticeRule == null) {
            noticeRule = new NoticeRule();
        }
        noticeRule.setNoticeRuleName(noticeRuleDTO.getNoticeRuleName());
        noticeRule.setNoticeRuleNo(noticeRuleDTO.getNoticeRuleNo());
        noticeRule.setEmailTemp(noticeRuleDTO.getEmailTemp());
        noticeRule.setUseStatus(noticeRuleDTO.isUseStatus());
        ArrayList<User> userList = new ArrayList<User>();
        if (noticeRuleDTO.getTechnician() != null) {
            String[] userName;
            for (String user : userName = noticeRuleDTO.getTechnician().split(";")) {
                User usrUser = (User)this.userDAO.findUniqueBy("loginName", (Object)user);
                if (usrUser == null) continue;
                userList.add(usrUser);
            }
        }
        noticeRule.setUsers(userList);
        this.noticeRuleDAO.merge((Object)noticeRule);
    }

    @Transactional
    public String generationEmailContent(EmailTemplatesDTO emailTemplatesDTO) {
        String emailContent = "";
        if (emailTemplatesDTO != null) {
            if (emailTemplatesDTO.getEno() != null && emailTemplatesDTO.getEntityType() != null) {
                HistoryRecordDTO historyRecordDTO = new HistoryRecordDTO();
                historyRecordDTO.setEno(emailTemplatesDTO.getEno());
                historyRecordDTO.setEventType(emailTemplatesDTO.getEntityType());
                List hrs = this.historyRecordService.findAllHistoryRecord(historyRecordDTO);
                if (hrs != null && hrs.size() > 0) {
                    emailTemplatesDTO.setHistoryRecordDTO(hrs);
                }
            }
            emailContent = this.emailTemplateService.template((Object)emailTemplatesDTO, emailTemplatesDTO.getTempDir());
        }
        return emailContent;
    }

    @Transactional
    public UserContactInfoDTO userContactInfoByLoginName(String loginName) {
        User user;
        UserContactInfoDTO userContactInfoDTO = new UserContactInfoDTO();
        String firstName = "";
        String lastName = "";
        if (loginName != null && (user = (User)this.userDAO.findUniqueBy("loginName", (Object)loginName)) != null) {
            userContactInfoDTO.setLoginName(user.getLoginName());
            userContactInfoDTO.setEmail(user.getEmail());
            userContactInfoDTO.setMobile(user.getMoblie());
            if (user.getFirstName() != null) {
                firstName = user.getFirstName();
            }
            if (user.getLastName() != null) {
                lastName = user.getLastName();
            }
            userContactInfoDTO.setUserName(firstName + lastName);
        }
        return userContactInfoDTO;
    }

    @Override
    @Transactional
    public void requestNotice(NoticeInfoDTO noticeInfoDto) {
        NoticeRule noticeRule = (NoticeRule)((Object)this.noticeRuleDAO.findUniqueBy("noticeRuleNo", noticeInfoDto.getNoticeRuleNo()));
        EmailTemplatesDTO emailTemplatesDTO = new EmailTemplatesDTO();
        emailTemplatesDTO.setEntityType("itsm.request");
        emailTemplatesDTO.setEno(noticeInfoDto.getEno());
        if (noticeRule != null) {
            String titleString = "";
            String contenString = "";
            if (noticeRule.isUseStatus() && noticeRule.getNoticeRuleNo() != null) {
                User assginUser;
                ArrayList<String> loginNames = new ArrayList<String>();
                if (noticeRule.getNoticeRuleNo().equals("notice_request_01")) {
                    emailTemplatesDTO.setEventCode(noticeInfoDto.getRequestCode());
                    emailTemplatesDTO.setTempDir(noticeRule.getEmailTemp());
                    titleString = "\u8bf7\u6c42\u81ea\u52a9\u767b\u5f55\u6d88\u606f";
                    emailTemplatesDTO.setEventCode(noticeInfoDto.getRequestCode());
                    emailTemplatesDTO.setTempDir("/" + noticeRule.getEmailTemp());
                }
                if (noticeRule.getNoticeRuleNo().equals("notice_request_02")) {
                    titleString = "\u8bf7\u6c42\u767b\u8bb0\u6210\u529f\u901a\u77e5";
                    emailTemplatesDTO.setEventCode(noticeInfoDto.getRequestCode());
                    emailTemplatesDTO.setTempDir("/" + noticeRule.getEmailTemp());
                }
                if (noticeRule.getNoticeRuleNo().equals("notice_request_03")) {
                    titleString = "\u8bf7\u6c42\u66f4\u65b0\u901a\u77e5";
                    emailTemplatesDTO.setEventCode(noticeInfoDto.getRequestCode());
                    emailTemplatesDTO.setTempDir("/" + noticeRule.getEmailTemp());
                }
                if (noticeRule.getNoticeRuleNo().equals("notice_request_04")) {
                    titleString = "\u8bf7\u6c42\u5173\u95ed\u901a\u77e5";
                    emailTemplatesDTO.setEventCode(noticeInfoDto.getRequestCode());
                    emailTemplatesDTO.setTempDir("/" + noticeRule.getEmailTemp());
                }
                if (noticeRule.getNoticeRuleNo().equals("notice_request_05")) {
                    loginNames = new ArrayList();
                    if (noticeRule.getUsers() != null) {
                        for (User users : noticeRule.getUsers()) {
                            loginNames.add(users.getLoginName());
                        }
                    }
                    noticeInfoDto.setLoginName(loginNames);
                    titleString = "\u521b\u5efa\u65b0\u8bf7\u6c42\u901a\u77e5";
                    emailTemplatesDTO.setEventCode(noticeInfoDto.getRequestCode());
                    emailTemplatesDTO.setTempDir("/" + noticeRule.getEmailTemp());
                }
                if (noticeRule.getNoticeRuleNo().equals("notice_request_06")) {
                    loginNames = new ArrayList();
                    if (noticeInfoDto.getUserNo() != null) {
                        assginUser = new User();
                        assginUser = (User)this.userDAO.findById((Serializable)noticeInfoDto.getUserNo());
                        loginNames.add(assginUser.getLoginName());
                    }
                    noticeInfoDto.setLoginName(loginNames);
                    titleString = "\u8bf7\u6c42\u6307\u6d3e\u901a\u77e5";
                    emailTemplatesDTO.setEventCode(noticeInfoDto.getRequestCode());
                    emailTemplatesDTO.setTempDir("/" + noticeRule.getEmailTemp());
                }
                if (noticeRule.getNoticeRuleNo().equals("notice_request_07")) {
                    loginNames = new ArrayList();
                    if (noticeRule.getUsers() != null) {
                        for (User users : noticeRule.getUsers()) {
                            loginNames.add(users.getLoginName());
                        }
                    }
                    noticeInfoDto.setLoginName(loginNames);
                    titleString = "\u8bf7\u6c42\u91cd\u65b0\u5f00\u542f\u901a\u77e5";
                    emailTemplatesDTO.setEventCode(noticeInfoDto.getRequestCode());
                    emailTemplatesDTO.setTempDir("/" + noticeRule.getEmailTemp());
                }
                if (noticeRule.getNoticeRuleNo().equals("notice_request_08")) {
                    loginNames = new ArrayList();
                    if (noticeRule.getUsers() != null) {
                        for (User users : noticeRule.getUsers()) {
                            loginNames.add(users.getLoginName());
                        }
                    }
                    noticeInfoDto.setLoginName(loginNames);
                    titleString = "\u8bf7\u6c42\u5173\u95ed\u901a\u77e5";
                    emailTemplatesDTO.setEventCode(noticeInfoDto.getRequestCode());
                    emailTemplatesDTO.setTempDir("/" + noticeRule.getEmailTemp());
                }
                if (noticeRule.getNoticeRuleNo().equals("notice_request_09")) {
                    loginNames = new ArrayList();
                    if (noticeInfoDto.getOrgNo() != null) {
                        UserQueryDTO userQueryDTO = new UserQueryDTO();
                        userQueryDTO.setOrgNo(noticeInfoDto.getOrgNo().longValue());
                        userQueryDTO.setLimit(10000);
                        List userList = this.userDAO.findBy("orgnization.orgNo", (Object)userQueryDTO.getOrgNo());
                        if (userList != null) {
                            for (User userEntity : userList) {
                                loginNames.add(userEntity.getLoginName());
                            }
                        }
                    }
                    noticeInfoDto.setLoginName(loginNames);
                    titleString = "\u8bf7\u6c42\u6307\u6d3e\u7ec4\u5458\u901a\u77e5";
                    emailTemplatesDTO.setEventCode(noticeInfoDto.getRequestCode());
                    emailTemplatesDTO.setTempDir("/" + noticeRule.getEmailTemp());
                }
                if (noticeRule.getNoticeRuleNo().equals("notice_request_10")) {
                    titleString = "\u8bf7\u6c42\u5904\u7406\u5b8c\u6210\u901a\u77e5";
                    emailTemplatesDTO.setEventCode(noticeInfoDto.getRequestCode());
                    emailTemplatesDTO.setTempDir("/" + noticeRule.getEmailTemp());
                }
                if (noticeRule.getNoticeRuleNo().equals("notice_request_11")) {
                    loginNames = new ArrayList();
                    if (noticeRule.getUsers() != null) {
                        for (User users : noticeRule.getUsers()) {
                            loginNames.add(users.getLoginName());
                        }
                    }
                    noticeInfoDto.setLoginName(loginNames);
                    titleString = "\u8bf7\u6c42\u5904\u7406\u5b8c\u6210\u901a\u77e5";
                    emailTemplatesDTO.setEventCode(noticeInfoDto.getRequestCode());
                    emailTemplatesDTO.setTempDir("/" + noticeRule.getEmailTemp());
                }
                if (noticeRule.getNoticeRuleNo().equals("notice_request_18")) {
                    loginNames = new ArrayList();
                    if (noticeInfoDto.getUserNo() != null) {
                        assginUser = new User();
                        assginUser = (User)this.userDAO.findById((Serializable)noticeInfoDto.getUserNo());
                        loginNames.add(assginUser.getLoginName());
                    }
                    noticeInfoDto.setLoginName(loginNames);
                    titleString = "\u8bf7\u6c42\u5347\u7ea7\u901a\u77e5";
                    emailTemplatesDTO.setEventCode(noticeInfoDto.getRequestCode());
                    emailTemplatesDTO.setTempDir("/" + noticeRule.getEmailTemp());
                }
                this.startSendEmail(noticeInfoDto.getLoginName(), titleString, contenString, emailTemplatesDTO);
            }
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void changeNotice(NoticeInfoDTO noticeInfoDto) {
        NoticeRule noticeRule = (NoticeRule)((Object)this.noticeRuleDAO.findUniqueBy("noticeRuleNo", noticeInfoDto.getNoticeRuleNo()));
        EmailTemplatesDTO emailTemplatesDTO = new EmailTemplatesDTO();
        emailTemplatesDTO.setEntityType("itsm.change");
        emailTemplatesDTO.setEno(noticeInfoDto.getEno());
        String titleString = null;
        String contenString = null;
        if (noticeRule != null && noticeRule.isUseStatus()) {
            ArrayList<String> sendEmail = new ArrayList<String>();
            if (noticeRule.getNoticeRuleNo().equals("notice_change_12")) {
                sendEmail = new ArrayList();
                if (noticeInfoDto.getUserNo() != null) {
                    User assginUser = new User();
                    assginUser = (User)this.userDAO.findById((Serializable)noticeInfoDto.getUserNo());
                    sendEmail.add(assginUser.getLoginName());
                }
                noticeInfoDto.setLoginName(sendEmail);
                titleString = "\u53d8\u66f4\u88ab\u6307\u6d3e\u65f6\u901a\u77e5\u6280\u672f\u5458";
                emailTemplatesDTO.setEventCode(noticeInfoDto.getRequestCode());
                emailTemplatesDTO.setTempDir("/" + noticeRule.getEmailTemp());
            }
            if (noticeRule.getNoticeRuleNo().equals("notice_change_13")) {
                sendEmail = new ArrayList();
                if (noticeInfoDto.getUsers() != null) {
                    for (User users : noticeInfoDto.getUsers()) {
                        sendEmail.add(users.getLoginName());
                    }
                    noticeInfoDto.setLoginName(sendEmail);
                    titleString = "\u53d8\u66f4\u5ba1\u6279\u901a\u77e5";
                    emailTemplatesDTO.setEventCode(noticeInfoDto.getRequestCode());
                    emailTemplatesDTO.setTempDir("/" + noticeRule.getEmailTemp());
                }
            }
            if (noticeRule.getNoticeRuleNo().equals("notice_change_14")) {
                sendEmail = new ArrayList();
                if (noticeRule.getUsers() != null) {
                    for (User users : noticeRule.getUsers()) {
                        sendEmail.add(users.getLoginName());
                    }
                }
                noticeInfoDto.setLoginName(sendEmail);
                titleString = "\u65b0\u7684\u53d8\u66f4\u521b\u5efa\u65f6\u901a\u77e5";
                emailTemplatesDTO.setEventCode(noticeInfoDto.getRequestCode());
                emailTemplatesDTO.setTempDir("/" + noticeRule.getEmailTemp());
            }
            if (noticeRule.getNoticeRuleNo().equals("notice_change_15")) {
                sendEmail = new ArrayList();
                if (noticeRule.getUsers() != null) {
                    for (User users : noticeRule.getUsers()) {
                        sendEmail.add(users.getLoginName());
                    }
                }
                noticeInfoDto.setLoginName(sendEmail);
                titleString = "\u53d8\u66f4\u88ab\u6279\u51c6\u6216\u62d2\u7edd\u65f6\u901a\u77e5";
                emailTemplatesDTO.setEventCode(noticeInfoDto.getRequestCode());
                emailTemplatesDTO.setTempDir("/" + noticeRule.getEmailTemp());
            }
            if (noticeRule.getNoticeRuleNo().equals("notice_change_16")) {
                sendEmail = new ArrayList();
                if (noticeRule.getUsers() != null) {
                    for (User users : noticeRule.getUsers()) {
                        sendEmail.add(users.getLoginName());
                    }
                }
                noticeInfoDto.setLoginName(sendEmail);
                titleString = "\u53d8\u66f4\u88ab\u5173\u95ed\u65f6\u901a\u77e5";
                emailTemplatesDTO.setEventCode(noticeInfoDto.getRequestCode());
                emailTemplatesDTO.setTempDir("/" + noticeRule.getEmailTemp());
            }
            if (noticeRule.getNoticeRuleNo().equals("notice_change_17")) {
                sendEmail = new ArrayList();
                if (noticeRule.getUsers() != null) {
                    for (User users : noticeRule.getUsers()) {
                        sendEmail.add(users.getLoginName());
                    }
                }
                noticeInfoDto.setLoginName(sendEmail);
                titleString = "\u53d8\u66f4\u88ab\u5173\u95ed\u65f6\u901a\u77e5CMDB";
                emailTemplatesDTO.setEventCode(noticeInfoDto.getRequestCode());
                emailTemplatesDTO.setTempDir("/" + noticeRule.getEmailTemp());
            }
            this.startSendEmail(noticeInfoDto.getLoginName(), titleString, contenString, emailTemplatesDTO);
        }
    }

    @Override
    public void startSendEmail(List<String> loginName, String titleString, String contentString, EmailTemplatesDTO emailTemplatesDTO) {
        if (loginName != null) {
            for (String usrString : loginName) {
                UserContactInfoDTO userContactInfoDTO = this.userContactInfoByLoginName(usrString);
                if (userContactInfoDTO == null || userContactInfoDTO.getEmail() == null) continue;
                EmailDTO emailDTO = new EmailDTO();
                emailDTO.setSubject(titleString);
                emailTemplatesDTO.setUserName(userContactInfoDTO.getUserName());
                emailDTO.setContent(this.generationEmailContent(emailTemplatesDTO));
                ArrayList<String> email = new ArrayList<String>();
                email.add(userContactInfoDTO.getEmail());
                emailDTO.setTo(email);
                try {
                    this.emailService.sendMail(emailDTO);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.error((Object)e);
                }
            }
        }
    }
}

