/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.sla.dao;

import com.sinba.common.dao.BaseDAOImplHibernate;
import com.sinba.common.dto.PageDTO;
import com.sinba.common.sla.dao.ISLAContractDAO;
import com.sinba.common.sla.dto.SLAContractQueryDTO;
import com.sinba.common.sla.entity.SLAContract;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SLAContractDAO
extends BaseDAOImplHibernate<SLAContract>
implements ISLAContractDAO {
    @Override
    public PageDTO findPager(SLAContractQueryDTO queryDTO, int start, int limit) {
        DetachedCriteria dc = DetachedCriteria.forClass(SLAContract.class);
        if (queryDTO != null) {
            if (queryDTO.getOrgNo() != null && StringUtils.hasText((String)queryDTO.getOrgNo().toString())) {
                dc.createAlias("org", "org").add((Criterion)Restrictions.eq((String)"org.orgNo", (Object)queryDTO.getOrgNo()));
            }
            if (queryDTO.getDcode() != null && StringUtils.hasText((String)queryDTO.getDcode().toString())) {
                dc.createAlias("slaSort", "slaSort").add((Criterion)Restrictions.eq((String)"slaSort.dcode", (Object)queryDTO.getDcode()));
            }
            if (StringUtils.hasText((String)queryDTO.getContractName())) {
                dc.add((Criterion)Restrictions.like((String)"contractName", (String)queryDTO.getContractName(), (MatchMode)MatchMode.ANYWHERE));
            }
        }
        dc.addOrder(Order.desc((String)"contractNo"));
        return super.findPageByCriteria(dc, start, limit);
    }

    @Override
    public SLAContract findByRulePackageNo(Long rulePackageNo) {
        List slaContract = super.getHibernateTemplate().find(" from SLAContract sl where sl.rulePackage.rulePackageNo=" + rulePackageNo);
        if (slaContract.size() > 0) {
            return (SLAContract)((Object)slaContract.get(0));
        }
        return null;
    }

    @Override
    public SLAContract findByServicesNo(Long servicesNo, Long byServicesNo) {
        DetachedCriteria dc = DetachedCriteria.forClass(SLAContract.class);
        dc.createAlias("serviceOrg", "serOrg").add((Criterion)Restrictions.eq((String)"serOrg.orgNo", (Object)servicesNo));
        dc.createAlias("byServiceOrg", "bySerOrg").add((Criterion)Restrictions.eq((String)"bySerOrg.orgNo", (Object)byServicesNo));
        dc.add((Criterion)Restrictions.le((String)"dataFlag", (Object)Byte.parseByte("98")));
        List slaList = this.getHibernateTemplate().findByCriteria(dc);
        if (slaList != null && slaList.size() > 0) {
            return (SLAContract)((Object)slaList.get(0));
        }
        return null;
    }
}

