/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.sla.dao;

import com.sinba.common.dao.BaseDAOImplHibernate;
import com.sinba.common.dto.PageDTO;
import com.sinba.common.sla.dao.ISLARuleDAO;
import com.sinba.common.sla.dto.SLARuleQueryDTO;
import com.sinba.common.sla.entity.SLARule;
import com.sinba.common.util.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SLARuleDAO
extends BaseDAOImplHibernate<SLARule>
implements ISLARuleDAO {
    @Override
    public PageDTO findPager(SLARuleQueryDTO qdto, int start, int limit) {
        DetachedCriteria dc = DetachedCriteria.forClass(SLARule.class);
        if (qdto.getRulePackageNo() != null) {
            dc.createAlias("rulePackage", "package").add((Criterion)Restrictions.eq((String)"package.rulePackageNo", (Object)qdto.getRulePackageNo()));
        }
        if (qdto.getContractNo() != null) {
            dc.createAlias("slaContract", "contract").add((Criterion)Restrictions.eq((String)"contract.contractNo", (Object)qdto.getContractNo()));
        }
        if (qdto != null) {
            if (StringUtils.hasText((String)qdto.getRuleName())) {
                dc.add((Criterion)Restrictions.like((String)"ruleName", (String)qdto.getRuleName(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (StringUtils.hasText((String)qdto.getDescription())) {
                dc.add((Criterion)Restrictions.like((String)"description", (String)qdto.getDescription(), (MatchMode)MatchMode.ANYWHERE));
            }
        }
        dc.addOrder(Order.desc((String)"ruleNo"));
        return super.findPageByCriteria(dc, start, limit);
    }
}

