/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.sla.entity;

import com.sinba.common.rules.entity.Rule;
import com.sinba.common.rules.entity.RuleAction;
import com.sinba.common.sla.entity.SLAContract;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;

@Entity
public class SLARule
extends Rule {
    @Column(nullable=true)
    private int respondTime;
    @Column(nullable=true)
    private int finishTime;
    @Column(columnDefinition="bit(1) default 0")
    private Boolean includeHoliday;
    @Transient
    private int rday;
    @Transient
    private int rhour;
    @Transient
    private int rminute;
    @Transient
    private int fday;
    @Transient
    private int fhour;
    @Transient
    private int fminute;
    @ManyToOne
    @JoinColumn(name="contractNo")
    private SLAContract slaContract;
    private Double responseRate;
    private Double completeRate;

    public Boolean getIncludeHoliday() {
        return this.includeHoliday;
    }

    public void setIncludeHoliday(Boolean includeHoliday) {
        this.includeHoliday = includeHoliday;
    }

    public Double getResponseRate() {
        return this.responseRate;
    }

    public void setResponseRate(Double responseRate) {
        this.responseRate = responseRate;
    }

    public Double getCompleteRate() {
        return this.completeRate;
    }

    public void setCompleteRate(Double completeRate) {
        this.completeRate = completeRate;
    }

    public int getRday() {
        this.rday = this.respondTime / 86400;
        return this.rday;
    }

    public void setRday(int rday) {
        this.rday = rday;
        this.respondTime = rday *= 86400;
    }

    public int getRhour() {
        this.rhour = this.respondTime / 3600;
        int i = 0;
        while (this.rhour >= 24) {
            this.rhour -= 24;
            ++i;
        }
        return this.rhour;
    }

    public void setRhour(int rhour) {
        this.rhour = rhour;
        this.respondTime += (rhour *= 3600);
    }

    public int getRminute() {
        this.rminute = this.respondTime / 60;
        int i = 0;
        while (this.rminute >= 60) {
            this.rminute -= 60;
            ++i;
        }
        return this.rminute;
    }

    public void setRminute(int rminute) {
        this.rminute = rminute;
        this.respondTime += (rminute *= 60);
    }

    public int getFday() {
        this.fday = this.finishTime / 86400;
        return this.fday;
    }

    public void setFday(int fday) {
        this.fday = fday;
        this.finishTime = fday *= 86400;
    }

    public int getFhour() {
        this.fhour = this.finishTime / 3600;
        int i = 0;
        while (this.fhour >= 24) {
            this.fhour -= 24;
            ++i;
        }
        return this.fhour;
    }

    public void setFhour(int fhour) {
        this.fhour = fhour;
        this.finishTime += (fhour *= 3600);
    }

    public int getFminute() {
        this.fminute = this.finishTime / 60;
        int i = 0;
        while (this.fminute >= 60) {
            this.fminute -= 60;
            ++i;
        }
        return this.fminute;
    }

    public void setFminute(int fminute) {
        this.fminute = fminute;
        this.finishTime += (fminute *= 60);
    }

    public SLAContract getSlaContract() {
        return this.slaContract;
    }

    public void setSlaContract(SLAContract slaContract) {
        this.slaContract = slaContract;
    }

    public int getRespondTime() {
        return this.respondTime;
    }

    public void setRespondTime(int respondTime) {
        this.respondTime = respondTime;
        RuleAction act1 = new RuleAction();
        act1.setPropertyName("respondTime");
        act1.setGivenValue(respondTime + "");
        super.getActions().add(act1);
    }

    public int getFinishTime() {
        return this.finishTime;
    }

    public void setFinishTime(int finishTime) {
        this.finishTime = finishTime;
        RuleAction act1 = new RuleAction();
        act1.setPropertyName("finishTime");
        act1.setGivenValue(finishTime + "");
        super.getActions().add(act1);
    }
}

