/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.sla.service;

import com.sinba.common.dto.PageDTO;
import com.sinba.common.security.dao.IUserDAO;
import com.sinba.common.security.entity.User;
import com.sinba.common.sla.dao.IPromoteRuleDAO;
import com.sinba.common.sla.dao.ISLAContractDAO;
import com.sinba.common.sla.dto.PromoteRuleDTO;
import com.sinba.common.sla.dto.PromoteRuleQueryDTO;
import com.sinba.common.sla.entity.PromoteRule;
import com.sinba.common.sla.entity.SLAContract;
import com.sinba.common.sla.service.IPromoteRuleService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class PromoteRuleService
implements IPromoteRuleService {
    @Autowired
    private IPromoteRuleDAO promoteRuleDAO;
    @Autowired
    private ISLAContractDAO slaContractDAO;
    @Autowired
    private IUserDAO userDAO;

    @Transactional
    public PageDTO findPromoteRuleByContractNo(PromoteRuleQueryDTO qdto, int start, int limit) {
        PageDTO p = this.promoteRuleDAO.findPager(qdto, start, limit);
        List entities = p.getData();
        ArrayList<PromoteRuleDTO> dtos = new ArrayList<PromoteRuleDTO>();
        for (PromoteRule entity : entities) {
            PromoteRuleDTO dto = new PromoteRuleDTO();
            PromoteRuleDTO.entity2dto((Object)((Object)entity), (Object)((Object)dto));
            if (entity.getAssignee() != null) {
                dto.setAssigneeName(entity.getAssignee().getLoginName());
                dto.setAssigneeNo(entity.getAssignee().getUserId());
            }
            if (entity.getSlaContract() != null) {
                dto.setContractNo(entity.getSlaContract().getContractNo());
            }
            dtos.add(dto);
        }
        p.setData(dtos);
        return p;
    }

    @Transactional
    public PromoteRule findPromoteRuleById(Long no) {
        PromoteRuleDTO dto = new PromoteRuleDTO();
        PromoteRule promoteRule = (PromoteRule)((Object)this.promoteRuleDAO.findById(no));
        PromoteRuleDTO.entity2dto((Object)((Object)promoteRule), (Object)((Object)dto));
        if (promoteRule.getAssignee() != null) {
            dto.setAssigneeNo(promoteRule.getAssignee().getUserId());
            dto.setAssigneeName(promoteRule.getAssignee().getLoginName());
        }
        return (PromoteRule)((Object)this.promoteRuleDAO.findById(no));
    }

    @Transactional
    public PromoteRule mergePromoteRuleEntity(PromoteRuleDTO promoteRuleDTO) {
        PromoteRule entity = (PromoteRule)((Object)this.promoteRuleDAO.findById(promoteRuleDTO.getRuleNo()));
        PromoteRuleDTO.dto2entity((Object)((Object)promoteRuleDTO), (Object)((Object)entity));
        if (promoteRuleDTO.getAssigneeNo() != null) {
            entity.setAssignee((User)this.userDAO.findById((Serializable)promoteRuleDTO.getAssigneeNo()));
        }
        return (PromoteRule)((Object)this.promoteRuleDAO.merge((Object)entity));
    }

    @Transactional
    public void removePromoteRule(Long no) {
        this.promoteRuleDAO.delete(this.promoteRuleDAO.findById(no));
    }

    @Transactional
    public void removePromoteRules(Long[] nos) {
        this.promoteRuleDAO.deleteByIds(nos);
    }

    @Transactional
    public void savePromoteRuleEntity(PromoteRuleDTO promoteRuleDTO) {
        PromoteRule entity = new PromoteRule();
        PromoteRuleDTO.dto2entity((Object)((Object)promoteRuleDTO), (Object)((Object)entity));
        if (promoteRuleDTO.getAssigneeNo() != null) {
            entity.setAssignee((User)this.userDAO.findById((Serializable)promoteRuleDTO.getAssigneeNo()));
        }
        if (promoteRuleDTO.getContractNo() != null) {
            entity.setSlaContract((SLAContract)((Object)this.slaContractDAO.findById(promoteRuleDTO.getContractNo())));
        }
        this.promoteRuleDAO.save((Object)entity);
    }
}

