/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.sla.service;

import com.sinba.common.dto.PageDTO;
import com.sinba.common.exception.ApplicationException;
import com.sinba.common.rules.dao.IRulePackageDAO;
import com.sinba.common.rules.entity.RulePackage;
import com.sinba.common.rules.utils.Chinese2Spell;
import com.sinba.common.security.dao.IOrganizationDAO;
import com.sinba.common.security.dao.IOrganizationServicesDAO;
import com.sinba.common.security.entity.Organization;
import com.sinba.common.security.entity.OrganizationServices;
import com.sinba.common.sla.dao.ISLAContractDAO;
import com.sinba.common.sla.dto.SLAContractDTO;
import com.sinba.common.sla.dto.SLAContractQueryDTO;
import com.sinba.common.sla.entity.SLAContract;
import com.sinba.common.sla.service.ISLAContractService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SLAContractService
implements ISLAContractService {
    @Autowired
    private ISLAContractDAO slaContractDAO;
    @Autowired
    private IOrganizationServicesDAO organizationServicesDAO;
    @Autowired
    private IRulePackageDAO rulePackageDAO;
    @Autowired
    private IOrganizationDAO organizationDAO;

    private void dto2entity(SLAContractDTO dto, SLAContract entity) {
        try {
            BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)dto));
        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }
    }

    private void entity2dto(SLAContract entity, SLAContractDTO dto) {
        try {
            BeanUtils.copyProperties((Object)((Object)dto), (Object)((Object)entity));
            if (entity.getServiceOrg() != null) {
                dto.setServiceOrgNo(entity.getServiceOrg().getOrgNo());
                dto.setServiceOrgName(entity.getServiceOrg().getOrgName());
            }
            if (entity.getRulePackage() != null) {
                dto.setRulePackageNo(entity.getRulePackage().getRulePackageNo());
            }
        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }
    }

    @Override
    @Transactional
    public SLAContractDTO findById(Long no) {
        SLAContract entity = (SLAContract)((Object)this.slaContractDAO.findById(no));
        SLAContractDTO dto = new SLAContractDTO();
        if (entity != null) {
            this.entity2dto(entity, dto);
        }
        return dto;
    }

    @Override
    public PageDTO findSLAContractByPager(SLAContractQueryDTO queryDTO, int start, int limit) {
        PageDTO p = this.slaContractDAO.findPager(queryDTO, start, limit);
        List entities = p.getData();
        ArrayList<SLAContractDTO> dtos = new ArrayList<SLAContractDTO>(entities.size());
        for (SLAContract entity : entities) {
            SLAContractDTO dto = new SLAContractDTO();
            this.entity2dto(entity, dto);
            dtos.add(dto);
        }
        p.setData(dtos);
        return p;
    }

    @Override
    @Transactional
    public Long[] findByServicesNosByContractNo(Long contractNo) {
        SLAContract sc = (SLAContract)((Object)this.slaContractDAO.findById(contractNo));
        if (sc != null && sc.getByServiceOrg() != null) {
            Long[] servicesNos = new Long[sc.getByServiceOrg().size()];
            int i = 0;
            for (Organization og : sc.getByServiceOrg()) {
                servicesNos[i] = og.getOrgNo();
                ++i;
            }
            return servicesNos;
        }
        return null;
    }

    @Override
    @Transactional
    public void mergeSLAContract(SLAContractDTO dto) {
        SLAContract entity = (SLAContract)((Object)this.slaContractDAO.findById(dto.getContractNo()));
        this.dto2entity(dto, entity);
        if (dto.getServiceOrgNo() != null) {
            OrganizationServices serviceOrg = (OrganizationServices)this.organizationServicesDAO.findById((Serializable)dto.getServiceOrgNo());
            entity.setServiceOrg(serviceOrg);
        }
        if (dto.getByServicesNos() != null && dto.getByServicesNos().length > 0) {
            Long[] servicesNos = dto.getByServicesNos();
            ArrayList<Organization> byServices = new ArrayList<Organization>();
            for (int i = 0; i < servicesNos.length; ++i) {
                if (servicesNos[i] == null) continue;
                byServices.add((Organization)this.organizationDAO.findById((Serializable)servicesNos[i]));
                this.getOrgChildren(servicesNos[i], byServices);
            }
            if (byServices.size() > 0) {
                entity.setByServiceOrg(byServices);
            }
        }
        this.slaContractDAO.merge((Object)entity);
    }

    public void getOrgChildren(Long parentNo, List<Organization> byServices) {
        List childrens = this.organizationDAO.findByParent(parentNo);
        if (childrens != null) {
            for (Organization og : childrens) {
                byServices.add(og);
                this.getOrgChildren(og.getOrgNo(), byServices);
            }
        }
    }

    @Override
    @Transactional
    public boolean removeSLAContract(Long no) {
        boolean result = true;
        Byte delete = 1;
        SLAContract slaContract = (SLAContract)((Object)this.slaContractDAO.findById(no));
        RulePackage rp = slaContract.getRulePackage();
        if (slaContract.getDataFlag().equals(delete)) {
            result = false;
        } else {
            this.rulePackageDAO.delete((Object)rp);
            this.slaContractDAO.delete((Object)slaContract);
        }
        return result;
    }

    @Override
    @Transactional
    public boolean removeSLAContracts(Long[] nos) {
        boolean result = true;
        Byte delete = 1;
        for (Long id : nos) {
            SLAContract slaContract = (SLAContract)((Object)this.slaContractDAO.findById(id));
            if (!slaContract.getDataFlag().equals(delete)) continue;
            result = false;
        }
        if (result) {
            for (int i = 0; i < nos.length; ++i) {
                SLAContract slaContract = (SLAContract)((Object)this.slaContractDAO.findById(nos[i]));
                RulePackage rp = slaContract.getRulePackage();
                this.rulePackageDAO.delete((Object)rp);
                this.slaContractDAO.delete((Object)slaContract);
            }
        }
        return result;
    }

    @Override
    @Transactional
    public void saveSLAContract(SLAContractDTO dto) {
        SLAContract entity = new SLAContract();
        this.dto2entity(dto, entity);
        if (dto.getServiceOrgNo() != null) {
            OrganizationServices serviceOrg = (OrganizationServices)this.organizationServicesDAO.findById((Serializable)dto.getServiceOrgNo());
            entity.setServiceOrg(serviceOrg);
        }
        if (dto.getByServicesNos() != null && dto.getByServicesNos().length > 0) {
            Long[] servicesNos = dto.getByServicesNos();
            ArrayList<Organization> byServices = new ArrayList<Organization>();
            for (int i = 0; i < servicesNos.length; ++i) {
                if (servicesNos[i] == null) continue;
                byServices.add((Organization)this.organizationDAO.findById((Serializable)servicesNos[i]));
                this.getOrgChildren(servicesNos[i], byServices);
            }
            if (byServices.size() > 0) {
                entity.setByServiceOrg(byServices);
            }
        }
        String packageName = "com.drools.drl." + Chinese2Spell.getWorld();
        RulePackage rulepackage = new RulePackage();
        rulepackage.setPackageName(packageName);
        rulepackage.setImports("com.sinba.itsm.request.dto.RequestDTO;");
        rulepackage.setLocation(new Date().getTime() + ".drl");
        this.rulePackageDAO.save((Object)rulepackage);
        RulePackage rp = (RulePackage)this.rulePackageDAO.findUniqueBy("packageName", (Object)packageName);
        entity.setRulePackage(rp);
        this.slaContractDAO.save((Object)entity);
    }
}

