/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.sla.service;

import com.sinba.common.dto.PageDTO;
import com.sinba.common.exception.ApplicationException;
import com.sinba.common.rules.entity.Rule;
import com.sinba.common.rules.entity.RuleConstraint;
import com.sinba.common.rules.entity.RulePackage;
import com.sinba.common.rules.parser.ProcreationDrlFiles;
import com.sinba.common.sla.dao.ISLAContractDAO;
import com.sinba.common.sla.dao.ISLARuleDAO;
import com.sinba.common.sla.dto.SLARuleDTO;
import com.sinba.common.sla.dto.SLARuleQueryDTO;
import com.sinba.common.sla.entity.SLAContract;
import com.sinba.common.sla.entity.SLARule;
import com.sinba.common.sla.service.ISLARuleService;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class SLARuleService
implements ISLARuleService {
    @Autowired
    private ISLARuleDAO slaRuleDAO;
    @Autowired
    private ISLAContractDAO slaContractDAO;
    private ProcreationDrlFiles procreationDrlFiles = new ProcreationDrlFiles();

    public void slaEntity2dto(SLARule entity, SLARuleDTO dto) {
        int te;
        int j;
        int i;
        if (entity.getRespondTime() != 0) {
            int time = entity.getRespondTime();
            i = 0;
            j = 0;
            i = 0;
            for (te = time / 60; te >= 60; te -= 60) {
                ++i;
            }
            j = 0;
            while (i >= 24) {
                ++j;
                i -= 24;
            }
            dto.setShowRespondTime(j + "DD" + i + "HH" + te + "MM");
        }
        if (entity.getFinishTime() != 0) {
            int time1 = entity.getFinishTime();
            i = 0;
            j = 0;
            i = 0;
            for (te = time1 / 60; te >= 60; te -= 60) {
                ++i;
            }
            j = 0;
            while (i >= 24) {
                ++j;
                i -= 24;
            }
            String s = String.format("%dDD%dHH%dMM", j, i, te);
            dto.setShowFinishTime(s);
        }
        try {
            BeanUtils.copyProperties((Object)((Object)dto), (Object)((Object)entity));
        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }
    }

    public PageDTO findPagerByContractNo(SLARuleQueryDTO qdto, int start, int limit) {
        PageDTO p = this.slaRuleDAO.findPager(qdto, start, limit);
        List entities = p.getData();
        ArrayList<SLARuleDTO> dtos = new ArrayList<SLARuleDTO>(entities.size());
        for (SLARule entity : entities) {
            SLARuleDTO dto = new SLARuleDTO();
            this.slaEntity2dto(entity, dto);
            dtos.add(dto);
        }
        p.setData(dtos);
        return p;
    }

    @Transactional
    public SLARule findSLARuleById(Long no) {
        SLARule slaRule = (SLARule)((Object)this.slaRuleDAO.findById(no));
        if (slaRule != null) {
            if (slaRule.getActions() != null) {
                slaRule.getActions().size();
            }
            if (slaRule.getCondition() != null) {
                slaRule.getCondition().getConstraints().size();
            }
            return slaRule;
        }
        return null;
    }

    @Transactional
    public SLARule mergeRuleEntity(SLARule slaRule) {
        Pattern pattern = Pattern.compile("[0-9]*");
        for (RuleConstraint constraint : slaRule.getCondition().getConstraints()) {
            Matcher isNum = pattern.matcher(constraint.getPropertyValue());
            if (!isNum.matches()) {
                constraint.setPropertyType(Boolean.valueOf(true));
            } else {
                constraint.setPropertyType(Boolean.valueOf(false));
            }
            constraint.setPattern(slaRule.getCondition());
        }
        slaRule = (SLARule)((Object)this.slaRuleDAO.merge((Object)slaRule));
        this.procreationDrlFiles.printDrlFiles((Rule)slaRule);
        return slaRule;
    }

    @Transactional
    public void removeRule(Long no) {
        RulePackage rulePackage = ((SLARule)((Object)this.slaRuleDAO.findById(no))).getRulePackage();
        this.slaRuleDAO.delete(this.slaRuleDAO.findById(no));
        this.procreationDrlFiles.printDrlFiles(rulePackage);
    }

    @Transactional
    public void removeRules(Long[] nos) {
        if (nos != null && nos.length > 0) {
            RulePackage rulePackage = ((SLARule)((Object)this.slaRuleDAO.findById(nos[0]))).getRulePackage();
            this.slaRuleDAO.deleteByIds(nos);
            this.procreationDrlFiles.printDrlFiles(rulePackage);
        }
    }

    @Transactional
    public void saveRuleEntity(SLARule slaRule) {
        if (slaRule.getSlaContract().getContractNo() != null) {
            SLAContract contract = (SLAContract)((Object)this.slaContractDAO.findById(slaRule.getSlaContract().getContractNo()));
            slaRule.setSlaContract(contract);
            slaRule.setRulePackage(contract.getRulePackage());
        }
        if (slaRule.getCondition() != null) {
            for (RuleConstraint constraint : slaRule.getCondition().getConstraints()) {
                constraint.setPattern(slaRule.getCondition());
            }
        }
        this.slaRuleDAO.save((Object)slaRule);
        this.procreationDrlFiles.printDrlFiles((Rule)slaRule);
    }
}

