/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.itsm.config.cab.service;

import com.sinba.common.security.dao.IUserDAO;
import com.sinba.common.security.entity.User;
import com.sinba.itsm.config.cab.dao.CABDAO;
import com.sinba.itsm.config.cab.dao.ICABMemberDAO;
import com.sinba.itsm.config.cab.dto.CABMemberDTO;
import com.sinba.itsm.config.cab.entity.CAB;
import com.sinba.itsm.config.cab.entity.CABMember;
import com.sinba.itsm.config.cab.service.ICABMemberService;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class CABMemberService
implements ICABMemberService {
    @Autowired
    private ICABMemberDAO cabMemberDAO;
    @Autowired
    private CABDAO cabDAO;
    @Autowired
    private IUserDAO userDAO;

    @Transactional
    public void saveCABMember(CABMemberDTO cabMembeDto) {
        CABMember cabMember = new CABMember();
        cabMember.setDescription(cabMembeDto.getDesc());
        if (cabMembeDto.getApprovalMember() != null) {
            cabMember.setApprovalMember((User)this.userDAO.findById((Serializable)cabMembeDto.getApprovalMember()));
        }
        if (cabMembeDto.getDelegateMember() != null) {
            cabMember.setDelegateMember((User)this.userDAO.findById((Serializable)cabMembeDto.getDelegateMember()));
        }
        this.cabMemberDAO.save((Object)cabMember);
        if (cabMembeDto.getCabId() != null) {
            CAB cab = (CAB)((Object)this.cabDAO.findById(cabMembeDto.getCabId()));
            cab.getCabMember().add(cabMember);
            this.cabDAO.merge((Object)cab);
        }
    }

    @Transactional
    public void editCABMember(CABMemberDTO cabMembeDto) {
        CABMember cabMember = (CABMember)((Object)this.cabMemberDAO.findById(cabMembeDto.getCabMemberId()));
        cabMember.setDescription(cabMembeDto.getDesc());
        if (cabMembeDto.getApprovalMember() != null) {
            cabMember.setApprovalMember((User)this.userDAO.findById((Serializable)cabMembeDto.getApprovalMember()));
        } else {
            cabMember.setApprovalMember(null);
        }
        if (cabMembeDto.getDelegateMember() != null) {
            cabMember.setDelegateMember((User)this.userDAO.findById((Serializable)cabMembeDto.getDelegateMember()));
        } else {
            cabMember.setDelegateMember(null);
        }
        this.cabMemberDAO.merge((Object)cabMember);
    }

    @Transactional
    public void deleteCABMember(Long cabId, Long[] cabMemberIds) {
        CAB cab = (CAB)((Object)this.cabDAO.findById(cabId));
        if (cabMemberIds != null && cab.getCabMember() != null) {
            for (Long id : cabMemberIds) {
                CABMember cabMember = (CABMember)((Object)this.cabMemberDAO.findById(id));
                if (!cab.getCabMember().contains((Object)cabMember)) continue;
                cab.getCabMember().remove((Object)cabMember);
            }
        }
        this.cabMemberDAO.deleteByIds(cabMemberIds);
        this.cabDAO.merge((Object)cab);
    }
}

