/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.itsm.config.cab.service;

import com.sinba.common.dto.PageDTO;
import com.sinba.itsm.config.cab.dao.ICABDAO;
import com.sinba.itsm.config.cab.dto.CABDTO;
import com.sinba.itsm.config.cab.dto.CABGridDTO;
import com.sinba.itsm.config.cab.dto.CABMemberGridDTO;
import com.sinba.itsm.config.cab.dto.CABQueryDTO;
import com.sinba.itsm.config.cab.entity.CAB;
import com.sinba.itsm.config.cab.entity.CABMember;
import com.sinba.itsm.config.cab.service.ICABService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class CABService
implements ICABService {
    @Autowired
    private ICABDAO cabDAO;

    @Transactional
    public PageDTO findPagerCAB(CABQueryDTO cabQueryDto, int start, int limit) {
        PageDTO page = this.cabDAO.findPagerCAB(cabQueryDto, start, limit);
        List entities = page.getData();
        ArrayList<CABGridDTO> dtos = new ArrayList<CABGridDTO>(entities.size());
        for (CAB entity : entities) {
            CABGridDTO dto = new CABGridDTO();
            dto.setCabId(entity.getCabId());
            dto.setCabName(entity.getCabName());
            dto.setCabDesc(entity.getCabDesc());
            dtos.add(dto);
        }
        page.setData(dtos);
        return page;
    }

    @Transactional
    public void saveCAB(CABDTO cabDto) {
        CAB cab = new CAB();
        cab.setCabName(cabDto.getCabName());
        cab.setCabDesc(cabDto.getCabDesc());
        this.cabDAO.save((Object)cab);
        cabDto.setCabId(cab.getCabId());
    }

    @Transactional
    public void editCAB(CABDTO cabDto) {
        CAB cab = (CAB)((Object)this.cabDAO.findById(cabDto.getCabId()));
        cab.setCabName(cabDto.getCabName());
        cab.setCabDesc(cabDto.getCabDesc());
        this.cabDAO.merge((Object)cab);
    }

    @Transactional
    public void deleteCAB(Long cabId, Long[] cabIds) {
        if (cabIds != null) {
            for (Long ids : cabIds) {
                CAB cab = (CAB)((Object)this.cabDAO.findById(ids));
                if (!cab.getCabMember().contains((Object)cab)) continue;
                cab.getCabMember().remove((Object)cab);
            }
            this.cabDAO.deleteByIds(cabIds);
        }
    }

    @Transactional
    public PageDTO findPagerCABMember(Long cabId, int page, int limit) {
        PageDTO pages = new PageDTO();
        if (cabId != null) {
            CAB cab = (CAB)((Object)this.cabDAO.findById(cabId));
            List<CABMember> cabMembers = cab.getCabMember();
            ArrayList<CABMemberGridDTO> cabMemGrid = new ArrayList<CABMemberGridDTO>(cabMembers.size());
            Collections.reverse(cabMembers);
            if (cabMembers != null && cabMembers.size() > 0) {
                int totalSize = cabMembers.size();
                int start = (page - 1) * limit;
                int end = limit * page - 1;
                if (end >= totalSize) {
                    end = totalSize - 1;
                }
                for (int i = start; i <= end; ++i) {
                    CABMemberGridDTO cabMemberGridDto = new CABMemberGridDTO();
                    cabMemberGridDto.setCabMemberId(cabMembers.get(i).getCabMemberId());
                    cabMemberGridDto.setDesc(cabMembers.get(i).getDescription());
                    if (cabMembers.get(i).getApprovalMember() != null) {
                        cabMemberGridDto.setApprovalMember(cabMembers.get(i).getApprovalMember().getLoginName());
                        cabMemberGridDto.setApprovalMemberId(cabMembers.get(i).getApprovalMember().getUserId());
                    }
                    if (cabMembers.get(i).getDelegateMember() != null) {
                        cabMemberGridDto.setDelegateMember(cabMembers.get(i).getDelegateMember().getLoginName());
                        cabMemberGridDto.setDelegateMemberId(cabMembers.get(i).getDelegateMember().getUserId());
                    }
                    cabMemGrid.add(cabMemberGridDto);
                }
            }
            pages.setData(cabMemGrid);
            pages.setTotalSize(cabMembers.size());
        }
        return pages;
    }
}

