/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.itsm.config.serviceDirectory.service;

import com.sinba.common.dto.PageDTO;
import com.sinba.common.exception.ApplicationException;
import com.sinba.itsm.config.serviceDirectory.dao.IServiceDirectoryDAO;
import com.sinba.itsm.config.serviceDirectory.dto.ServiceDirectoryDTO;
import com.sinba.itsm.config.serviceDirectory.dto.ServiceDirectoryGridDTO;
import com.sinba.itsm.config.serviceDirectory.dto.ServiceDirectoryQueryDTO;
import com.sinba.itsm.config.serviceDirectory.dto.SubServiceGridDTO;
import com.sinba.itsm.config.serviceDirectory.dto.SubServiceQueryDTO;
import com.sinba.itsm.config.serviceDirectory.entity.ServiceDirectory;
import com.sinba.itsm.config.serviceDirectory.entity.SubService;
import com.sinba.itsm.config.serviceDirectory.service.IServiceDirectoryService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDirectoryService
implements IServiceDirectoryService {
    @Autowired
    private IServiceDirectoryDAO serviceDirectoryDAO;

    @Override
    @Transactional
    public PageDTO findPagerServiceDirectory(ServiceDirectoryQueryDTO sdQueryDto, int start, int limit) {
        PageDTO pageDto = this.serviceDirectoryDAO.findPagerServiceDirectory(sdQueryDto, start, limit);
        List sdList = pageDto.getData();
        ArrayList<ServiceDirectoryGridDTO> sdDtos = new ArrayList<ServiceDirectoryGridDTO>(sdList.size());
        for (ServiceDirectory entity : sdList) {
            ServiceDirectoryGridDTO dto = new ServiceDirectoryGridDTO();
            dto.setServiceDirectoryId(entity.getServiceDirectoryId());
            dto.setServiceDirectoryName(entity.getServiceDirectoryName());
            dto.setServiceDirectoryDesc(entity.getDescription());
            sdDtos.add(dto);
        }
        pageDto.setData(sdDtos);
        return pageDto;
    }

    @Override
    @Transactional
    public PageDTO findPageSubService(SubServiceQueryDTO subServiceQueryDto, int page, int limit) {
        PageDTO pages = new PageDTO();
        if (subServiceQueryDto != null) {
            ServiceDirectory servieDirectory = (ServiceDirectory)((Object)this.serviceDirectoryDAO.findById(subServiceQueryDto.getServiceDirectoryId()));
            List<SubService> subServices = servieDirectory.getSubService();
            ArrayList<SubServiceGridDTO> subServiceGridDto = new ArrayList<SubServiceGridDTO>();
            Collections.reverse(subServices);
            if (subServices != null && subServices.size() > 0) {
                int totalSize = subServices.size();
                int start = (page - 1) * limit;
                int end = limit * page - 1;
                if (end >= totalSize) {
                    end = totalSize - 1;
                }
                for (int i = start; i <= end; ++i) {
                    SubServiceGridDTO sub = new SubServiceGridDTO();
                    sub.setSubServiceId(subServices.get(i).getSubServiceId());
                    sub.setSubServiceName(subServices.get(i).getSubServiceName());
                    sub.setSubServiceDesc(subServices.get(i).getDescription());
                    subServiceGridDto.add(sub);
                }
            }
            pages.setData(subServiceGridDto);
            pages.setTotalSize(subServices.size());
        }
        return pages;
    }

    @Override
    @Transactional
    public void saveServiceDirectory(ServiceDirectoryDTO sdDto) {
        ServiceDirectory servieDirectory = new ServiceDirectory();
        servieDirectory.setServiceDirectoryName(sdDto.getServiceDirectoryName());
        servieDirectory.setDescription(sdDto.getServiceDirectoryDesc());
        this.serviceDirectoryDAO.save((Object)servieDirectory);
        sdDto.setServiceDirectoryId(servieDirectory.getServiceDirectoryId());
    }

    @Override
    @Transactional
    public void editServiceDirectory(ServiceDirectoryDTO sdDto) {
        ServiceDirectory servieDirectory = (ServiceDirectory)((Object)this.serviceDirectoryDAO.findById(sdDto.getServiceDirectoryId()));
        servieDirectory.setServiceDirectoryName(sdDto.getServiceDirectoryName());
        servieDirectory.setDescription(sdDto.getServiceDirectoryDesc());
        this.serviceDirectoryDAO.merge((Object)servieDirectory);
    }

    @Override
    @Transactional
    public void deleteServiceDirectory(Long[] ids) {
        this.serviceDirectoryDAO.deleteByIds(ids);
    }

    @Override
    @Transactional
    public List<ServiceDirectoryGridDTO> findAllServiceDirectory() {
        List sds = this.serviceDirectoryDAO.findAll();
        ArrayList<ServiceDirectoryGridDTO> sdgDtos = new ArrayList<ServiceDirectoryGridDTO>();
        if (sds != null) {
            for (ServiceDirectory sd : sds) {
                ServiceDirectoryGridDTO sdgDto = new ServiceDirectoryGridDTO();
                sdgDto.setServiceDirectoryId(sd.getServiceDirectoryId());
                sdgDto.setServiceDirectoryName(sd.getServiceDirectoryName());
                sdgDto.setServiceDirectoryDesc(sd.getDescription());
                sdgDtos.add(sdgDto);
            }
        }
        return sdgDtos;
    }

    @Override
    @Transactional
    public ServiceDirectoryDTO findServiceDirectoryById(Long no) {
        ServiceDirectory entity = (ServiceDirectory)((Object)this.serviceDirectoryDAO.findById(no));
        ServiceDirectoryDTO dto = new ServiceDirectoryDTO();
        if (entity != null) {
            this.entity2dto(entity, dto);
        }
        return dto;
    }

    private void dto2entity(ServiceDirectoryDTO dto, ServiceDirectory entity) {
        try {
            BeanUtils.copyProperties((Object)((Object)entity), (Object)dto);
        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }
    }

    private void entity2dto(ServiceDirectory entity, ServiceDirectoryDTO dto) {
        try {
            BeanUtils.copyProperties((Object)dto, (Object)((Object)entity));
        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }
    }
}

