/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.itsm.config.serviceDirectory.service;

import com.sinba.itsm.config.serviceDirectory.dao.IServiceDirectoryDAO;
import com.sinba.itsm.config.serviceDirectory.dao.ISubServiceDAO;
import com.sinba.itsm.config.serviceDirectory.dto.SubServiceDTO;
import com.sinba.itsm.config.serviceDirectory.entity.ServiceDirectory;
import com.sinba.itsm.config.serviceDirectory.entity.SubService;
import com.sinba.itsm.config.serviceDirectory.service.ISubServiceService;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class SubServiceService
implements ISubServiceService {
    @Autowired
    private ISubServiceDAO subServiceDAO;
    @Autowired
    private IServiceDirectoryDAO serviceDirectoryDAO;

    @Transactional
    public void saveSubService(SubServiceDTO subServiceDTO) {
        SubService subService = new SubService();
        subService.setSubServiceName(subServiceDTO.getSubServiceName());
        subService.setDescription(subServiceDTO.getSubServiceDesc());
        this.subServiceDAO.save((Object)subService);
        if (subServiceDTO.getServiceDirectoryId() != null) {
            ServiceDirectory serviceDirectory = (ServiceDirectory)((Object)this.serviceDirectoryDAO.findById(subServiceDTO.getServiceDirectoryId()));
            if (serviceDirectory.getSubService() == null) {
                ArrayList<SubService> subServices = new ArrayList<SubService>();
                serviceDirectory.setSubService(subServices);
            }
            serviceDirectory.getSubService().add(subService);
            this.serviceDirectoryDAO.merge((Object)serviceDirectory);
        }
        subServiceDTO.setSubServiceId(subService.getSubServiceId());
    }

    @Transactional
    public void editSubService(SubServiceDTO subServiceDTO) {
        SubService subService = (SubService)((Object)this.subServiceDAO.findById(subServiceDTO.getSubServiceId()));
        subService.setSubServiceName(subServiceDTO.getSubServiceName());
        subService.setDescription(subServiceDTO.getSubServiceDesc());
        this.subServiceDAO.merge((Object)subService);
    }

    @Transactional
    public void deleteSubService(Long sdId, Long[] ids) {
        ServiceDirectory sds = (ServiceDirectory)((Object)this.serviceDirectoryDAO.findById(sdId));
        if (sds != null && sds.getSubService() != null) {
            for (Long id : ids) {
                SubService subService = (SubService)((Object)this.subServiceDAO.findById(id));
                if (!sds.getSubService().contains((Object)subService)) continue;
                sds.getSubService().remove((Object)subService);
            }
        }
        this.serviceDirectoryDAO.merge((Object)sds);
        this.subServiceDAO.deleteByIds(ids);
    }

    @Transactional
    public SubServiceDTO findSubServiceById(Long id) {
        SubServiceDTO subServiceDTO = new SubServiceDTO();
        SubService entity = (SubService)((Object)this.subServiceDAO.findById(id));
        subServiceDTO.setSubServiceId(entity.getSubServiceId());
        subServiceDTO.setSubServiceName(entity.getSubServiceName());
        subServiceDTO.setSubServiceDesc(entity.getDescription());
        subServiceDTO.setDataFlag(entity.getDataFlag());
        return subServiceDTO;
    }
}

