/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.itsm.config.updatelevel.service;

import com.sinba.common.dto.PageDTO;
import com.sinba.common.security.dao.IUserDAO;
import com.sinba.common.security.entity.User;
import com.sinba.itsm.config.updatelevel.dao.IUpdateLevelDAO;
import com.sinba.itsm.config.updatelevel.dto.UpdateLevelDTO;
import com.sinba.itsm.config.updatelevel.dto.UpdateLevelQueryDTO;
import com.sinba.itsm.config.updatelevel.entity.UpdateLevel;
import com.sinba.itsm.config.updatelevel.service.IUpdateLevelService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class UpdateLevelService
implements IUpdateLevelService {
    @Autowired
    public IUpdateLevelDAO updateLevelDAO;
    @Autowired
    public IUserDAO userDAO;

    @Transactional
    public PageDTO findPagerUpdateLevel(UpdateLevelQueryDTO qdto) {
        PageDTO p = this.updateLevelDAO.findPager(qdto);
        List entities = p.getData();
        ArrayList<UpdateLevelDTO> dtos = new ArrayList<UpdateLevelDTO>(entities.size());
        for (UpdateLevel ul : entities) {
            UpdateLevelDTO dto = new UpdateLevelDTO();
            UpdateLevelDTO.entity2dto((Object)((Object)ul), (Object)((Object)dto));
            if (ul.getApproval() != null) {
                dto.setApprovalName(ul.getApproval().getLoginName());
                dto.setApprovalNo(ul.getApproval().getUserId());
            }
            dtos.add(dto);
        }
        p.setData(dtos);
        return p;
    }

    @Transactional
    public void saveUpdateLevel(UpdateLevelDTO dto) {
        UpdateLevel entity = new UpdateLevel();
        UpdateLevelDTO.dto2entity((Object)((Object)dto), (Object)((Object)entity));
        if (dto.getApprovalNo() != null) {
            entity.setApproval((User)this.userDAO.findById((Serializable)dto.getApprovalNo()));
        }
        this.updateLevelDAO.save((Object)entity);
    }

    @Transactional
    public void mergeUpdateLevel(UpdateLevelDTO dto) {
        UpdateLevel entity = (UpdateLevel)((Object)this.updateLevelDAO.findById(dto.getUlId()));
        if (entity != null) {
            UpdateLevelDTO.dto2entity((Object)((Object)dto), (Object)((Object)entity));
            if (dto.getApprovalNo() != null) {
                entity.setApproval((User)this.userDAO.findById((Serializable)dto.getApprovalNo()));
            }
            this.updateLevelDAO.merge((Object)entity);
        }
    }

    @Transactional
    public boolean deleteUpdateLevel(Long[] ulIds) {
        boolean result = true;
        Byte delete = 1;
        for (Long id : ulIds) {
            UpdateLevel updateLevel = (UpdateLevel)((Object)this.updateLevelDAO.findById(id));
            if (!updateLevel.getDataFlag().equals(delete)) continue;
            result = false;
        }
        if (result) {
            this.updateLevelDAO.deleteByIds(ulIds);
        }
        return result;
    }
}

