/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.itsm.config.visit.service;

import com.sinba.common.dto.PageDTO;
import com.sinba.itsm.config.visit.dao.IVisitDAO;
import com.sinba.itsm.config.visit.dao.IVisitItemDAO;
import com.sinba.itsm.config.visit.dto.VisitDTO;
import com.sinba.itsm.config.visit.dto.VisitItemDTO;
import com.sinba.itsm.config.visit.entity.Visit;
import com.sinba.itsm.config.visit.entity.VisitItem;
import com.sinba.itsm.config.visit.service.IVisitItemService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class VisitItemService
implements IVisitItemService {
    @Autowired
    private IVisitItemDAO visitItemDAO;
    @Autowired
    private IVisitDAO visitDAO;

    @Transactional
    public PageDTO findPagerVisitItems(Long visitNo, int page1, int limit, String sord, String sidx) {
        PageDTO page = new PageDTO();
        if (visitNo != null) {
            Visit vis = (Visit)((Object)this.visitDAO.findById(visitNo));
            List<VisitItem> visitItems = vis.getVisitItems();
            int totalSize = visitItems.size();
            int start = (page1 - 1) * limit;
            int end = limit * page1 - 1;
            if (end >= totalSize) {
                end = totalSize - 1;
            }
            Collections.reverse(visitItems);
            ArrayList<VisitItemDTO> dtos = new ArrayList<VisitItemDTO>();
            for (int i = start; i <= end; ++i) {
                VisitItem visitItem = visitItems.get(i);
                VisitItemDTO visitItemDTO = new VisitItemDTO();
                VisitDTO.entity2dto((Object)((Object)visitItem), (Object)((Object)visitItemDTO));
                dtos.add(visitItemDTO);
            }
            page.setTotalSize(totalSize);
            page.setData(dtos);
        }
        return page;
    }

    @Transactional
    public void visitItemSave(VisitItemDTO visitItemDTO) {
        VisitItem visitItem = new VisitItem();
        VisitDTO.dto2entity((Object)((Object)visitItemDTO), (Object)((Object)visitItem));
        this.visitItemDAO.save((Object)visitItem);
        Visit visit = (Visit)((Object)this.visitDAO.findById(visitItemDTO.getVisitNo()));
        if (visitItem.getVisitItemNo() != null) {
            if (visit.getVisitItems() == null) {
                ArrayList<VisitItem> visitItems = new ArrayList<VisitItem>();
                visit.setVisitItems(visitItems);
            }
            visit.getVisitItems().add(visitItem);
        }
        this.visitDAO.merge((Object)visit);
        visitItemDTO.setVisitItemNo(visitItem.getVisitItemNo());
    }

    @Transactional
    public void visitItemUpdate(VisitItemDTO visitItemDTO) {
        VisitItem visitItem = (VisitItem)((Object)this.visitItemDAO.findById(visitItemDTO.getVisitItemNo()));
        VisitDTO.dto2entity((Object)((Object)visitItemDTO), (Object)((Object)visitItem));
        this.visitItemDAO.update((Object)visitItem);
    }

    @Transactional
    public void visitItemDelete(Long visitNo, Long[] visitItemNo) {
        Visit visit = (Visit)((Object)this.visitDAO.findById(visitNo));
        for (int i = 0; i < visitItemNo.length; ++i) {
            VisitItem deleteItem = (VisitItem)((Object)this.visitItemDAO.findById(visitItemNo[i]));
            if (visit.getVisitItems() == null || !visit.getVisitItems().contains((Object)deleteItem)) continue;
            visit.getVisitItems().remove((Object)deleteItem);
        }
        this.visitDAO.merge((Object)visit);
    }

    @Transactional
    public VisitItemDTO findById(Long visitItemNo) {
        VisitItemDTO dto = new VisitItemDTO();
        VisitItem entity = (VisitItem)((Object)this.visitItemDAO.findById(visitItemNo));
        VisitDTO.entity2dto((Object)((Object)entity), (Object)((Object)dto));
        return dto;
    }
}

