/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.itsm.config.visit.service;

import com.sinba.common.dto.PageDTO;
import com.sinba.itsm.config.visit.dao.IVisitDAO;
import com.sinba.itsm.config.visit.dto.VisitDTO;
import com.sinba.itsm.config.visit.dto.VisitWebDTO;
import com.sinba.itsm.config.visit.entity.Visit;
import com.sinba.itsm.config.visit.entity.VisitItem;
import com.sinba.itsm.config.visit.service.IVisitService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class VisitService
implements IVisitService {
    @Autowired
    private IVisitDAO visitDAO;

    @Transactional
    public PageDTO findPagerVisit(int start, int limit, String sord, String sidx, boolean useStatus) {
        PageDTO page = this.visitDAO.findPager(start, limit, sord, sidx, useStatus);
        List visList = page.getData();
        ArrayList<VisitDTO> dtos = new ArrayList<VisitDTO>(visList.size());
        for (Visit vs : visList) {
            VisitDTO visDto = new VisitDTO();
            VisitDTO.entity2dto((Object)((Object)vs), (Object)((Object)visDto));
            dtos.add(visDto);
        }
        page.setData(dtos);
        return page;
    }

    @Transactional
    public void visitSave(VisitDTO visitDto) {
        Visit visit = new Visit();
        VisitDTO.dto2entity((Object)((Object)visitDto), (Object)((Object)visit));
        this.visitDAO.save((Object)visit);
        visitDto.setVisitNo(visit.getVisitNo());
    }

    @Transactional
    public void visitUpdate(VisitDTO visitDto) {
        Visit visit = (Visit)((Object)this.visitDAO.findById(visitDto.getVisitNo()));
        visit.setVisitItemType(visitDto.getVisitItemType());
        visit.setVisitName(visitDto.getVisitName());
        visit.setUseStatus(visitDto.isUseStatus());
        visit.setVisitOrder(visitDto.getVisitOrder());
        this.visitDAO.update((Object)visit);
    }

    @Transactional
    public void visitDelete(Long[] visitNo) {
        this.visitDAO.deleteByIds(visitNo);
    }

    @Transactional
    public PageDTO findAllVisit(int start, int limit, String sord, String sidx, boolean useStatus) {
        PageDTO page = this.visitDAO.findPager(start, limit, sord, sidx, useStatus);
        List visList = page.getData();
        ArrayList<VisitWebDTO> dtos = new ArrayList<VisitWebDTO>(visList.size());
        for (Visit vs : visList) {
            VisitWebDTO visDto = new VisitWebDTO();
            VisitWebDTO.entity2dto((Object)((Object)vs), (Object)((Object)visDto));
            ArrayList<VisitItem> vistItems = new ArrayList<VisitItem>();
            if (vs.getVisitItems() != null) {
                for (VisitItem vi : vs.getVisitItems()) {
                    vistItems.add(vi);
                }
            }
            visDto.setVisitItems(vistItems);
            dtos.add(visDto);
        }
        page.setData(dtos);
        return page;
    }

    @Transactional
    public VisitDTO findById(Long visitNo) {
        VisitDTO dto = new VisitDTO();
        Visit entity = (Visit)((Object)this.visitDAO.findById(visitNo));
        VisitDTO.entity2dto((Object)((Object)entity), (Object)((Object)dto));
        return dto;
    }
}

