/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.compass.service;

import org.apache.log4j.Logger;
import org.compass.gps.CompassGps;
import org.springframework.util.Assert;

public class CompassIndexBuilder {
    private static final Logger LOGGER = Logger.getLogger(CompassIndexBuilder.class);
    private boolean buildIndex = false;
    private int lazyTime = 10;
    private CompassGps compassGps;
    private Thread indexThread = new Thread(){

        public void run() {
            try {
                Thread.sleep(CompassIndexBuilder.this.lazyTime * 1000);
                LOGGER.info((Object)"begin compass index...");
                long beginTime = System.currentTimeMillis();
                CompassIndexBuilder.this.compassGps.index();
                long costTime = System.currentTimeMillis() - beginTime;
                LOGGER.info((Object)"compss index finished.");
                LOGGER.info((Object)("costed " + costTime + " milliseconds"));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    };

    public void afterPropertiesSet() throws Exception {
        if (this.buildIndex) {
            Assert.notNull((Object)this.compassGps, (String)"CompassIndexBuilder not set CompassGps yet.");
            this.indexThread.setDaemon(true);
            this.indexThread.setName("Compass Indexer");
            this.indexThread.start();
        }
    }

    public void setBuildIndex(boolean buildIndex) {
        this.buildIndex = buildIndex;
    }

    public void setLazyTime(int lazyTime) {
        this.lazyTime = lazyTime;
    }

    public void setCompassGps(CompassGps compassGps) {
        this.compassGps = compassGps;
    }
}

