/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.compass.service;

import com.sinba.common.compass.dto.CompassQueryDTO;
import com.sinba.common.compass.service.ICompassSearchService;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import net.paoding.analysis.analyzer.PaodingAnalyzer;
import org.apache.commons.lang.xwork.StringUtils;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.queryParser.CompassMultiFieldQueryParser;
import org.compass.core.Compass;
import org.compass.core.CompassQuery;
import org.compass.core.CompassQueryBuilder;
import org.compass.core.CompassSession;
import org.compass.core.CompassTemplate;
import org.compass.core.support.search.CompassSearchCommand;
import org.compass.core.support.search.CompassSearchHelper;
import org.compass.core.support.search.CompassSearchResults;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompassSearchService
implements ICompassSearchService {
    @Resource
    private CompassTemplate compassTemplate;

    public CompassTemplate getCompassTemplate() {
        return this.compassTemplate;
    }

    public void setCompassTemplate(CompassTemplate compassTemplate) {
        this.compassTemplate = compassTemplate;
    }

    public CompassSearchResults.Page findAll(int pageNumber, int pagesize) {
        return null;
    }

    public static void main(String[] args) {
        System.out.println(new CompassSearchService().dissect("\u6211\u7684\u7535\u8111\u51fa\u95ee\u9898\u4e86\uff0c\u5f00\u4e0d\u4e86\u673a\u3002"));
    }

    public List<String> dissect(String keyword) {
        PaodingAnalyzer analyzer = new PaodingAnalyzer();
        ArrayList<String> words = new ArrayList<String>();
        try {
            if (StringUtils.isEmpty((String)keyword)) {
                words.add("");
            } else {
                Token token;
                TokenStream ts = analyzer.tokenStream("", (Reader)new StringReader(keyword));
                while ((token = ts.next()) != null) {
                    words.add(token.termText());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return words;
    }

    @Override
    public CompassSearchResults doSearch(CompassQueryDTO queryDTO, int pageNumber, int pageSize) {
        Compass compass = this.compassTemplate.getCompass();
        CompassSession session = compass.openSession();
        CompassQueryBuilder cqb = session.queryBuilder();
        CompassQueryBuilder.CompassBooleanQueryBuilder bQuery = cqb.bool();
        bQuery.addMust(cqb.alias(queryDTO.getAlias()));
        List<String> words = this.dissect(queryDTO.getQueryString());
        for (String word : words) {
            bQuery.addShould(cqb.queryString("*" + word + "*").toQuery());
        }
        bQuery.setMinimumNumberShouldMatch(1);
        CompassQuery cQuery = bQuery.toQuery();
        CompassSearchCommand csc = new CompassSearchCommand(cQuery, Integer.valueOf(pageNumber - 1));
        CompassSearchHelper csh = new CompassSearchHelper(compass, Integer.valueOf(pageSize));
        CompassSearchResults csr = csh.search(csc);
        return csr;
    }

    @Override
    public CompassSearchResults performSearch(CompassQueryDTO queryDTO, String[] fields, int pageNumber, int pageSize) {
        if (queryDTO == null || queryDTO.getQueryString() == null) {
            return null;
        }
        Compass compass = this.compassTemplate.getCompass();
        CompassSession session = compass.openSession();
        CompassQueryBuilder cqb = session.queryBuilder();
        CompassQueryBuilder.CompassBooleanQueryBuilder bQuery = cqb.bool();
        for (int i = 0; i < fields.length; ++i) {
            CompassQuery cq = cqb.fuzzy(fields[i], queryDTO.getQueryString(), 0.2f);
            bQuery.addShould(cq);
        }
        CompassQuery comQuery = cqb.queryString("*" + queryDTO.getQueryString() + "*").toQuery();
        bQuery.addShould(comQuery);
        CompassQuery cQuery = bQuery.toQuery();
        System.out.println(cQuery.toString());
        CompassSearchCommand csc = new CompassSearchCommand(cQuery, Integer.valueOf(pageNumber));
        CompassSearchHelper csh = new CompassSearchHelper(compass, Integer.valueOf(pageSize));
        CompassSearchResults csr = csh.search(csc);
        return csr;
    }

    private CompassMultiFieldQueryParser CompassMultiFieldQueryParser() {
        return null;
    }

    public void save(Object obj) {
        Compass compass = this.compassTemplate.getCompass();
        CompassSession session = compass.openSession();
        session.save(obj);
    }
}

