/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.internal.activity;

import java.util.Set;
import org.jbpm.jpdl.internal.activity.AssignActivity;
import org.jbpm.jpdl.internal.activity.JpdlBinding;
import org.jbpm.jpdl.internal.xml.JpdlParser;
import org.jbpm.pvm.internal.el.Expression;
import org.jbpm.pvm.internal.el.UelValueExpression;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.wire.Descriptor;
import org.jbpm.pvm.internal.wire.xml.WireParser;
import org.jbpm.pvm.internal.xml.Parse;
import org.w3c.dom.Element;

public class AssignBinding
extends JpdlBinding {
    private static final String FROM_EXPR = "from-expr";
    private static final String LANG = "lang";
    private static final String FROM_VAR = "from-var";
    private static final String FROM_DESC = "from";
    private static final String TO_EXPR = "to-expr";
    private static final String TO_VAR = "to-var";

    public AssignBinding() {
        super("assign");
    }

    public Object parseJpdl(Element element, Parse parse, JpdlParser parser) {
        AssignActivity assignActivity = new AssignActivity();
        if (element.hasAttribute(FROM_EXPR)) {
            String lang = XmlUtil.attribute((Element)element, (String)LANG);
            Expression fromExpression = Expression.create((String)element.getAttribute(FROM_EXPR), (String)lang);
            assignActivity.setFromExpression(fromExpression);
        } else if (element.hasAttribute(FROM_VAR)) {
            assignActivity.setFromVariable(element.getAttribute(FROM_VAR));
        } else {
            Element fromElement = XmlUtil.element((Element)element, (String)FROM_DESC);
            if (fromElement != null) {
                Set descriptorTags = WireParser.getInstance().getBindings().getTagNames("descriptor");
                Element descriptorElement = XmlUtil.element((Element)fromElement);
                if (descriptorElement != null && descriptorTags.contains(descriptorElement.getTagName())) {
                    Descriptor descriptor = parser.parseDescriptor(descriptorElement, parse);
                    assignActivity.setFromDescriptor(descriptor);
                } else {
                    parse.addProblem("missing descriptor element", fromElement);
                }
            } else {
                parse.addProblem("missing from-expr attribute, from-var attribute or from element", element);
            }
        }
        if (element.hasAttribute(TO_VAR)) {
            assignActivity.setToVariable(element.getAttribute(TO_VAR));
        } else if (element.hasAttribute(TO_EXPR)) {
            Expression expression = Expression.create((String)element.getAttribute(TO_EXPR), (String)"uel-value");
            assignActivity.setToExpression((UelValueExpression)expression);
        }
        return assignActivity;
    }
}

