/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.internal.activity;

import java.util.List;
import org.jbpm.jpdl.internal.activity.DecisionConditionActivity;
import org.jbpm.jpdl.internal.activity.DecisionExpressionActivity;
import org.jbpm.jpdl.internal.activity.DecisionHandlerActivity;
import org.jbpm.jpdl.internal.activity.JpdlBinding;
import org.jbpm.jpdl.internal.xml.JpdlParser;
import org.jbpm.pvm.internal.el.Expression;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.Condition;
import org.jbpm.pvm.internal.model.ExpressionCondition;
import org.jbpm.pvm.internal.model.TransitionImpl;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.wire.usercode.UserCodeCondition;
import org.jbpm.pvm.internal.wire.usercode.UserCodeReference;
import org.jbpm.pvm.internal.xml.Parse;
import org.w3c.dom.Element;

public class DecisionBinding
extends JpdlBinding {
    public DecisionBinding() {
        super("decision");
    }

    public Object parseJpdl(Element element, Parse parse, JpdlParser parser) {
        if (element.hasAttribute("expr")) {
            DecisionExpressionActivity decisionExpressionActivity = new DecisionExpressionActivity();
            String expressionText = element.getAttribute("expr");
            String language = XmlUtil.attribute((Element)element, (String)"lang");
            Expression expression = Expression.create((String)expressionText, (String)language);
            decisionExpressionActivity.setExpression(expression);
            return decisionExpressionActivity;
        }
        Element handlerElement = XmlUtil.element((Element)element, (String)"handler");
        if (handlerElement != null) {
            DecisionHandlerActivity decisionHandlerActivity = new DecisionHandlerActivity();
            UserCodeReference decisionHandlerReference = parser.parseUserCodeReference(handlerElement, parse);
            decisionHandlerActivity.setDecisionHandlerReference(decisionHandlerReference);
            return decisionHandlerActivity;
        }
        boolean hasConditions = false;
        List transitionElements = XmlUtil.elements((Element)element, (String)"transition");
        ActivityImpl activity = (ActivityImpl)parse.contextStackFind(ActivityImpl.class);
        List transitions = activity.getOutgoingTransitions();
        for (int i = 0; i < transitionElements.size(); ++i) {
            TransitionImpl transition = (TransitionImpl)transitions.get(i);
            Element transitionElement = (Element)transitionElements.get(i);
            Element conditionElement = XmlUtil.element((Element)transitionElement, (String)"condition");
            if (conditionElement == null) continue;
            hasConditions = true;
            if (conditionElement.hasAttribute("expr")) {
                ExpressionCondition expressionCondition = new ExpressionCondition();
                expressionCondition.setExpression(conditionElement.getAttribute("expr"));
                expressionCondition.setLanguage(XmlUtil.attribute((Element)conditionElement, (String)"lang"));
                transition.setCondition((Condition)expressionCondition);
                continue;
            }
            Element conditionHandlerElement = XmlUtil.element((Element)conditionElement, (String)"handler");
            if (conditionHandlerElement == null) continue;
            UserCodeCondition userCodeCondition = new UserCodeCondition();
            UserCodeReference conditionReference = parser.parseUserCodeReference(conditionHandlerElement, parse);
            userCodeCondition.setConditionReference(conditionReference);
            transition.setCondition((Condition)userCodeCondition);
        }
        if (hasConditions) {
            return new DecisionConditionActivity();
        }
        parse.addProblem("decision '" + element.getAttribute("name") + "' must have one of: expr attribute, handler attribute, handler element or condition expressions", element);
        return null;
    }
}

