/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.internal.activity;

import java.util.List;
import org.jbpm.api.JbpmException;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.api.model.OpenExecution;
import org.jbpm.api.model.Transition;
import org.jbpm.jpdl.internal.activity.JpdlActivity;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.Condition;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.TransitionImpl;

public class DecisionConditionActivity
extends JpdlActivity {
    private static final long serialVersionUID = 1L;

    public void execute(ActivityExecution execution) throws Exception {
        this.execute((ExecutionImpl)execution);
    }

    public void execute(ExecutionImpl execution) throws Exception {
        Transition transition = DecisionConditionActivity.findTransitionUsingConditions(execution);
        if (transition == null) {
            throw new JbpmException("no outgoing transition condition evaluated to true for decision " + execution.getActivity());
        }
        if (transition.getName() != null) {
            execution.historyDecision(transition.getName());
        }
        execution.take(transition);
    }

    public static Transition findTransitionUsingConditions(ExecutionImpl execution) {
        ActivityImpl activity = execution.getActivity();
        List outgoingTransitions = activity.getOutgoingTransitions();
        for (TransitionImpl transition : outgoingTransitions) {
            Condition condition = transition.getCondition();
            if (condition != null && !condition.evaluate((OpenExecution)execution)) continue;
            return transition;
        }
        return null;
    }
}

