/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.internal.activity;

import org.jbpm.jpdl.internal.activity.JpdlBinding;
import org.jbpm.jpdl.internal.activity.ScriptActivity;
import org.jbpm.jpdl.internal.xml.JpdlParser;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.script.ScriptManager;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.xml.Parse;
import org.w3c.dom.Element;

public class ScriptBinding
extends JpdlBinding {
    private static final String TAG = "script";

    public ScriptBinding() {
        super(TAG);
    }

    public Object parseJpdl(Element element, Parse parse, JpdlParser parser) {
        String language = null;
        String script = XmlUtil.attribute((Element)element, (String)"expr");
        Element textElement = XmlUtil.element((Element)element, (String)"text");
        if (script != null) {
            ScriptManager scriptManager = (ScriptManager)EnvironmentImpl.getFromCurrent(ScriptManager.class);
            language = scriptManager.getDefaultExpressionLanguage();
            if (textElement != null) {
                parse.addProblem("in <script ...> attribute expr can't be combined with a nested text element", element);
            }
        } else if (textElement != null) {
            language = XmlUtil.attribute((Element)element, (String)"lang");
            script = XmlUtil.getContentText((Element)textElement);
        } else {
            parse.addProblem("<script...> element must have either expr attribute or nested text element", element);
        }
        String variableName = XmlUtil.attribute((Element)element, (String)"var");
        ScriptActivity scriptActivity = new ScriptActivity();
        scriptActivity.setScript(script);
        scriptActivity.setLanguage(language);
        scriptActivity.setVariableName(variableName);
        return scriptActivity;
    }
}

