/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.itsm.knowledge.action;

import com.opensymphony.xwork2.ActionSupport;
import com.sinba.common.compass.dto.CompassQueryDTO;
import com.sinba.common.compass.service.ICompassSearchService;
import com.sinba.common.dto.PageDTO;
import com.sinba.itsm.knowledge.dto.KnowledgeDTO;
import com.sinba.itsm.knowledge.dto.KnowledgeQueryDTO;
import com.sinba.itsm.knowledge.entity.KnowledgeInfo;
import com.sinba.itsm.knowledge.service.IKnowledgeService;
import com.sinba.itsm.knowledge.service.KnowledgeService;
import java.util.ArrayList;
import java.util.List;
import org.compass.core.CompassHit;
import org.compass.core.support.search.CompassSearchResults;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnowledgeAction
extends ActionSupport {
    @Autowired
    private IKnowledgeService knowledgeService;
    @Autowired
    private ICompassSearchService compassSearchService;
    private KnowledgeDTO knowledgeDto = new KnowledgeDTO();
    private CompassQueryDTO compassQueryDto = new CompassQueryDTO();
    private KnowledgeQueryDTO knowledgeQueryDto = new KnowledgeQueryDTO();
    private List<KnowledgeDTO> list = new ArrayList<KnowledgeDTO>();
    private Long[] nos;
    private PageDTO knowledges;
    private int page = 1;
    private int rows = 10;
    private Long kid;
    private Long aid;
    private Long rid;
    private String title;
    private String content;
    private String sidx;
    private String sord;
    private String filePath;

    public String getSidx() {
        return this.sidx;
    }

    public void setSidx(String sidx) {
        this.sidx = sidx;
    }

    public String getSord() {
        return this.sord;
    }

    public void setSord(String sord) {
        this.sord = sord;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Long getRid() {
        return this.rid;
    }

    public void setRid(Long rid) {
        this.rid = rid;
    }

    public Long getAid() {
        return this.aid;
    }

    public void setAid(Long aid) {
        this.aid = aid;
    }

    public Long getKid() {
        return this.kid;
    }

    public void setKid(Long kid) {
        this.kid = kid;
    }

    public CompassQueryDTO getCompassQueryDto() {
        return this.compassQueryDto;
    }

    public void setCompassQueryDto(CompassQueryDTO compassQueryDto) {
        this.compassQueryDto = compassQueryDto;
    }

    public KnowledgeQueryDTO getKnowledgeQueryDto() {
        return this.knowledgeQueryDto;
    }

    public void setKnowledgeQueryDto(KnowledgeQueryDTO knowledgeQueryDto) {
        this.knowledgeQueryDto = knowledgeQueryDto;
    }

    public PageDTO getKnowledges() {
        return this.knowledges;
    }

    public void setKnowledges(PageDTO knowledges) {
        this.knowledges = knowledges;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public Long[] getNos() {
        return this.nos;
    }

    public void setNos(Long[] nos) {
        this.nos = nos;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public KnowledgeDTO getKnowledgeDto() {
        return this.knowledgeDto;
    }

    public void setKnowledgeDto(KnowledgeDTO knowledgeDto) {
        this.knowledgeDto = knowledgeDto;
    }

    public List<KnowledgeDTO> getList() {
        return this.list;
    }

    public String findKnowledgeById() {
        this.knowledgeDto = this.knowledgeService.findById(this.kid);
        return "singleKnowledge";
    }

    public String findAllKnowledges() {
        int start = (this.page - 1) * this.rows;
        this.knowledges = this.knowledgeService.findKnowledgesByPages(this.knowledgeQueryDto, start, this.rows, this.sidx, this.sord);
        this.knowledges.setPage(this.page);
        this.knowledges.setRows(this.rows);
        return "success";
    }

    public String saveKnowledgeInfo() {
        this.knowledgeService.saveKnowledgeInfo(this.knowledgeDto);
        return "success";
    }

    public String removeKnowledgeItems() {
        this.knowledgeService.removeKnowledgeItems(this.nos);
        return "success";
    }

    public String updateKnowledgeInfo() {
        this.knowledgeService.updateKnowledgeInfo(this.knowledgeDto);
        return "success";
    }

    public String findNewKnowledge() {
        this.list = this.knowledgeService.findNewKnowledge();
        return "findKnowledge";
    }

    public String findPopularKnowledge() {
        this.list = this.knowledgeService.findPopularKnowledge();
        return "findKnowledge";
    }

    public String fullSearch() {
        String[] fields = new String[]{"knTitle", "content", "keyWords"};
        CompassSearchResults csr = this.compassSearchService.performSearch(this.compassQueryDto, fields, this.page, this.rows);
        this.knowledges = new PageDTO();
        this.knowledges.setTotalSize(csr.getTotalHits());
        this.knowledges.setPage(this.page);
        this.knowledges.setRows(this.rows);
        ArrayList<KnowledgeDTO> data = new ArrayList<KnowledgeDTO>();
        CompassHit[] hit = csr.getHits();
        for (int i = 0; i < hit.length; ++i) {
            String alias = hit[i].alias();
            if (!alias.equals("KnowledgeInfo")) continue;
            KnowledgeInfo entity = (KnowledgeInfo)((Object)hit[i].data());
            KnowledgeDTO dto = new KnowledgeDTO();
            KnowledgeService.entity2dto(entity, dto);
            data.add(dto);
        }
        this.knowledges.setData(data);
        return "success";
    }

    public String deleteAttachment() {
        this.knowledgeService.deleteAttachment(this.kid, this.aid);
        return "success";
    }

    public String showKnowledge() {
        this.knowledgeDto = this.knowledgeService.findById(this.kid);
        return "showKnowledge";
    }

    public String exportKnowledgeFromExcel() {
        int start = (this.page - 1) * this.rows;
        this.filePath = this.knowledgeService.exportKnowledges(this.knowledgeQueryDto, start, this.rows, this.sidx, this.sord);
        return "success";
    }

    public String importKnowledgeFromExcel(KnowledgeQueryDTO dto) {
        this.knowledgeService.importKnowledgeFromExel(dto);
        return "success";
    }
}

