/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.itsm.knowledge.dao;

import com.sinba.common.dao.BaseDAOImplHibernate;
import com.sinba.common.dto.PageDTO;
import com.sinba.itsm.knowledge.dao.IKnowledgeDAO;
import com.sinba.itsm.knowledge.dto.KnowledgeQueryDTO;
import com.sinba.itsm.knowledge.entity.KnowledgeInfo;
import java.sql.SQLException;
import java.util.GregorianCalendar;
import java.util.List;
import org.compass.core.util.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate3.HibernateCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnowledgeDAO
extends BaseDAOImplHibernate<KnowledgeInfo>
implements IKnowledgeDAO {
    @Override
    public PageDTO findAllKnowledgeInfos(KnowledgeQueryDTO querydto, int start, int limit, String sidx, String sord) {
        DetachedCriteria dc = DetachedCriteria.forClass(KnowledgeInfo.class);
        if (querydto != null) {
            GregorianCalendar endTimeCl;
            if (querydto.getCategoryNames() != null && querydto.getCategoryNames().length > 0) {
                dc.createAlias("category", "c");
                dc.add(Restrictions.in((String)"c.eventName", (Object[])querydto.getCategoryNames()));
            }
            if (StringUtils.hasText((String)querydto.getKeyWord())) {
                dc.add((Criterion)Restrictions.like((String)"keyWords", (String)querydto.getKeyWord(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (StringUtils.hasText((String)querydto.getTitle())) {
                dc.add((Criterion)Restrictions.like((String)"title", (String)querydto.getTitle(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (querydto.getStartTime() != null && querydto.getEndTime() == null) {
                dc.add((Criterion)Restrictions.ge((String)"addTime", (Object)querydto.getStartTime()));
            }
            if (querydto.getStartTime() == null && querydto.getEndTime() != null) {
                endTimeCl = new GregorianCalendar();
                endTimeCl.setTime(querydto.getEndTime());
                endTimeCl.set(5, endTimeCl.get(5) + 1);
                dc.add((Criterion)Restrictions.le((String)"addTime", (Object)endTimeCl.getTime()));
            }
            if (querydto.getStartTime() != null && querydto.getEndTime() != null) {
                endTimeCl = new GregorianCalendar();
                endTimeCl.setTime(querydto.getEndTime());
                endTimeCl.set(5, endTimeCl.get(5) + 1);
                dc.add((Criterion)Restrictions.and((Criterion)Restrictions.le((String)"addTime", (Object)endTimeCl.getTime()), (Criterion)Restrictions.ge((String)"addTime", (Object)querydto.getStartTime())));
            }
        }
        if (sord != null && !sord.equals("") && sidx != null && !sidx.equals("")) {
            if ("desc".equals(sord)) {
                dc.addOrder(Order.desc((String)sidx));
            } else {
                dc.addOrder(Order.asc((String)sidx));
            }
        }
        return super.findPageByCriteria(dc, start, limit);
    }

    @Override
    public List<KnowledgeInfo> findNewKnowledge() {
        return this.getHibernateTemplate().executeFind((HibernateCallback)new HibernateCallback<List<KnowledgeInfo>>(){

            public List<KnowledgeInfo> doInHibernate(Session session) throws HibernateException, SQLException {
                String hql = " from KnowledgeInfo as k order by k.addTime desc and k.dataFlag!=99";
                Query query = session.createQuery(hql);
                query.setFirstResult(0);
                query.setMaxResults(5);
                return query.list();
            }
        });
    }

    @Override
    public List<KnowledgeInfo> findPopularKnowledge() {
        return this.getHibernateTemplate().executeFind((HibernateCallback)new HibernateCallback<List<KnowledgeInfo>>(){

            public List<KnowledgeInfo> doInHibernate(Session session) throws HibernateException, SQLException {
                String hql = "from KnowledgeInfo as k order by k.clickRate desc and k.dataFlag!=99";
                Query query = session.createQuery(hql);
                query.setFirstResult(0);
                query.setMaxResults(5);
                return query.list();
            }
        });
    }
}

