/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.itsm.knowledge.service;

import com.sinba.common.config.category.dto.CategoryDTO;
import com.sinba.common.config.category.dto.CategoryTreeViewDTO;
import com.sinba.common.config.category.entity.Category;
import com.sinba.common.exception.ApplicationException;
import com.sinba.itsm.knowledge.dao.IKnowledgeCategoryDAO;
import com.sinba.itsm.knowledge.entity.KnowledgeCategory;
import com.sinba.itsm.knowledge.service.IKnowledgeCategoryService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnowledgeCategoryService
implements IKnowledgeCategoryService {
    @Autowired
    private IKnowledgeCategoryDAO knowledgecategoryDAO;

    @Override
    @Transactional
    public List<CategoryTreeViewDTO> findKnowledgeCategoryTreeDtos(String name) {
        ArrayList<CategoryTreeViewDTO> dtos = new ArrayList<CategoryTreeViewDTO>();
        List<KnowledgeCategory> entities = this.knowledgecategoryDAO.findKnowledge(name);
        for (KnowledgeCategory entity : entities) {
            CategoryTreeViewDTO dto = new CategoryTreeViewDTO();
            KnowledgeCategoryService.entity2dto((Category)entity, dto);
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    @Transactional
    public void saveKnowledgeCategory(CategoryDTO dto) {
        KnowledgeCategory entity = new KnowledgeCategory();
        KnowledgeCategoryService.dto2entity(dto, entity);
        if (dto.getParentNo() != null) {
            KnowledgeCategory parent = (KnowledgeCategory)((Object)this.knowledgecategoryDAO.findById(dto.getParentNo()));
            entity.setParent(parent);
        }
        this.knowledgecategoryDAO.save((Object)entity);
        dto.setCno(entity.getCno());
    }

    @Override
    @Transactional
    public void removeKnowledgeCategory(Long kno) {
        this.knowledgecategoryDAO.delete(this.knowledgecategoryDAO.findById(kno));
    }

    @Override
    @Transactional
    public void updateKnowledgeCategory(CategoryDTO dto) {
        KnowledgeCategory entity = (KnowledgeCategory)((Object)this.knowledgecategoryDAO.findById(dto.getCno()));
        if (dto.getCname() != null) {
            entity.setCname(dto.getCname());
        }
        if (dto.getDescription() != null) {
            entity.setDescription(dto.getDescription());
        }
    }

    @Override
    @Transactional
    public void changeKnowledgeCategory(CategoryDTO dto) {
        KnowledgeCategory entity = (KnowledgeCategory)((Object)this.knowledgecategoryDAO.findById(dto.getCno()));
        KnowledgeCategory parent = (KnowledgeCategory)((Object)this.knowledgecategoryDAO.findById(dto.getParentNo()));
        entity.setParent(parent);
    }

    @Override
    @Transactional
    public CategoryDTO findKnowledgeCategoryById(long cno) {
        CategoryDTO dto = new CategoryDTO();
        KnowledgeCategory entity = (KnowledgeCategory)((Object)this.knowledgecategoryDAO.findById(Long.valueOf(cno)));
        KnowledgeCategoryService.entity2dto(entity, dto);
        if (dto != null && entity.getParent() != null) {
            dto.setParentNo(entity.getParent().getCno());
        }
        return dto;
    }

    public static void dto2entity(CategoryDTO dto, KnowledgeCategory entity) {
        try {
            BeanUtils.copyProperties((Object)((Object)entity), (Object)dto);
        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }
    }

    public static void entity2dto(KnowledgeCategory entity, CategoryDTO dto) {
        try {
            BeanUtils.copyProperties((Object)dto, (Object)((Object)entity));
        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }
    }

    public static void entity2dto(Category entity, CategoryTreeViewDTO dto) {
        try {
            dto.setData(entity.getCname());
            dto.getAttr().put("cno", "" + entity.getCno());
            dto.getAttr().put("cname", entity.getCname());
            dto.getAttr().put("description", entity.getDescription());
            if (entity.getChildren() != null && !entity.getChildren().isEmpty()) {
                dto.setState("close");
                for (Category ctg : entity.getChildren()) {
                    CategoryTreeViewDTO regDTO = new CategoryTreeViewDTO();
                    KnowledgeCategoryService.entity2dto(ctg, regDTO);
                    dto.getChildren().add(regDTO);
                }
            }
        }
        catch (Exception ex) {
            throw new ApplicationException("Exception caused while converting Entity into DTO: " + ex.getMessage());
        }
    }
}

