/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.itsm.knowledge.service;

import com.sinba.common.config.attachment.entity.Attachment;
import com.sinba.common.config.attachment.service.IAttachmentService;
import com.sinba.common.config.category.dao.IEventCategoryDAO;
import com.sinba.common.config.category.entity.EventCategory;
import com.sinba.common.dto.PageDTO;
import com.sinba.common.exception.ApplicationException;
import com.sinba.common.file.excel.ExcelUtil;
import com.sinba.itsm.knowledge.dao.IKnowledgeDAO;
import com.sinba.itsm.knowledge.dto.KnowledgeDTO;
import com.sinba.itsm.knowledge.dto.KnowledgeQueryDTO;
import com.sinba.itsm.knowledge.entity.KnowledgeInfo;
import com.sinba.itsm.knowledge.service.IKnowledgeService;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnowledgeService
implements IKnowledgeService {
    @Autowired
    private IKnowledgeDAO knowledgeDAO;
    @Autowired
    private IEventCategoryDAO categoryDAO;
    @Autowired
    private IAttachmentService attachmentService;

    public void findKnowledgeCategorys(String ename, List<String> strList) {
        EventCategory category = (EventCategory)this.categoryDAO.findUniqueBy("eventName", (Object)ename);
        strList.add(ename);
        if (category != null && category.getParentChildren() != null && category.getParentChildren().size() > 0) {
            for (EventCategory e : category.getParentChildren()) {
                strList.add(e.getEventName());
                this.findKnowledgeCategorys(e.getEventName(), strList);
            }
        }
    }

    @Override
    @Transactional
    public PageDTO findKnowledgesByPages(KnowledgeQueryDTO dto, int start, int limit, String sidx, String sord) {
        if (dto != null && dto.getCategory() != null && !dto.getCategory().equals("")) {
            ArrayList<String> strList = new ArrayList<String>();
            this.findKnowledgeCategorys(dto.getCategory(), strList);
            String[] arr = strList.toArray(new String[strList.size()]);
            dto.setCategoryNames(arr);
        }
        PageDTO pageDto = this.knowledgeDAO.findAllKnowledgeInfos(dto, start, limit, sidx, sord);
        List entitys = pageDto.getData();
        ArrayList<KnowledgeDTO> dtos = new ArrayList<KnowledgeDTO>(entitys.size());
        for (KnowledgeInfo entity : entitys) {
            KnowledgeDTO knowledgeDto = new KnowledgeDTO();
            if (entity.getCategory() != null) {
                knowledgeDto.setCategoryName(entity.getCategory().getEventName());
            }
            KnowledgeService.entity2dto(entity, knowledgeDto);
            dtos.add(knowledgeDto);
        }
        pageDto.setData(dtos);
        return pageDto;
    }

    @Override
    @Transactional
    public List<KnowledgeDTO> findNewKnowledge() {
        List<KnowledgeInfo> entitys = this.knowledgeDAO.findNewKnowledge();
        ArrayList<KnowledgeDTO> dtos = new ArrayList<KnowledgeDTO>(entitys.size());
        for (KnowledgeInfo entity : entitys) {
            if (entity.getDataFlag() == 99) continue;
            KnowledgeDTO dto = new KnowledgeDTO();
            KnowledgeService.entity2dto(entity, dto);
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    @Transactional
    public List<KnowledgeDTO> findPopularKnowledge() {
        List<KnowledgeInfo> entitys = this.knowledgeDAO.findPopularKnowledge();
        ArrayList<KnowledgeDTO> dtos = new ArrayList<KnowledgeDTO>(entitys.size());
        for (KnowledgeInfo entity : entitys) {
            if (entity.getDataFlag() == 99) continue;
            KnowledgeDTO dto = new KnowledgeDTO();
            KnowledgeService.entity2dto(entity, dto);
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    @Transactional
    public KnowledgeDTO findById(Long id) {
        List<Attachment> attrs;
        KnowledgeInfo entity = (KnowledgeInfo)((Object)this.knowledgeDAO.findById(id));
        entity.setClickRate(entity.getClickRate() + 1L);
        KnowledgeDTO dto = new KnowledgeDTO();
        EventCategory category = entity.getCategory();
        if (category != null) {
            dto.setCategoryName(category.getEventName());
            dto.setCategoryNo(category.getEventId());
        }
        if ((attrs = entity.getAttachements()) != null && attrs.size() > 0) {
            dto.setAttachments(attrs);
        }
        KnowledgeService.entity2dto(entity, dto);
        return dto;
    }

    @Override
    @Transactional
    public void updateKnowledgeInfo(KnowledgeDTO dto) {
        EventCategory category;
        KnowledgeInfo knowledgeInfo = (KnowledgeInfo)((Object)this.knowledgeDAO.findById(dto.getKid()));
        if (dto.getContent() != null) {
            knowledgeInfo.setContent(dto.getContent());
        }
        if (dto.getDescription() != null) {
            knowledgeInfo.setDescription(dto.getDescription());
        }
        if (dto.getKeyWords() != null) {
            knowledgeInfo.setKeyWords(dto.getKeyWords());
        }
        if (dto.getTitle() != null) {
            knowledgeInfo.setTitle(dto.getTitle());
        }
        if (dto.getPermission() != null) {
            knowledgeInfo.setPermission(dto.getPermission());
        }
        if (dto.getRemark() != null) {
            knowledgeInfo.setRemark(dto.getRemark());
        }
        if (dto.getCategoryNo() != null) {
            category = (EventCategory)this.categoryDAO.findById((Serializable)dto.getCategoryNo());
            knowledgeInfo.setCategory(category);
        } else {
            category = (EventCategory)this.categoryDAO.findUniqueBy("categoryRoot", (Object)"Knowledge");
            knowledgeInfo.setCategory(category);
        }
        if (dto.getAttachmentStr() != null) {
            List attrs = this.attachmentService.saveAttachment(dto.getAttachmentStr());
            if (knowledgeInfo.getAttachements() == null) {
                ArrayList<Attachment> attachments = new ArrayList<Attachment>();
                knowledgeInfo.setAttachements(attachments);
            }
            knowledgeInfo.getAttachements().addAll(attrs);
        }
        this.knowledgeDAO.update((Object)knowledgeInfo);
    }

    @Override
    @Transactional
    public void saveKnowledgeInfo(KnowledgeDTO dto) {
        EventCategory category;
        Calendar cd = Calendar.getInstance();
        Date d = cd.getTime();
        dto.setAddTime(d);
        KnowledgeInfo entity = new KnowledgeInfo();
        if (dto.getCategoryNo() != null) {
            category = (EventCategory)this.categoryDAO.findById((Serializable)dto.getCategoryNo());
            entity.setCategory(category);
        } else {
            category = (EventCategory)this.categoryDAO.findUniqueBy("categoryRoot", (Object)"Knowledge");
            entity.setCategory(category);
        }
        if (dto.getAttachmentStr() != null) {
            List attrs = this.attachmentService.saveAttachment(dto.getAttachmentStr());
            entity.setAttachements(attrs);
        }
        KnowledgeService.dto2entity(dto, entity);
        this.knowledgeDAO.save((Object)entity);
        dto.setKid(entity.getKid());
    }

    @Override
    @Transactional
    public void deleteAttachment(Long kid, Long aid) {
        List<Attachment> attrs;
        KnowledgeInfo knowledge = (KnowledgeInfo)((Object)this.knowledgeDAO.findById(kid));
        if (knowledge != null && (attrs = knowledge.getAttachements()) != null && attrs.size() > 0) {
            for (Attachment a : attrs) {
                if (!a.getAid().equals(aid)) continue;
                knowledge.getAttachements().remove(a);
                break;
            }
        }
    }

    @Override
    @Transactional
    public void removeKnowledgeItems(Long[] nos) {
        this.knowledgeDAO.deleteByIds(nos);
    }

    public static void dto2entity(KnowledgeDTO dto, KnowledgeInfo entity) {
        try {
            BeanUtils.copyProperties((Object)((Object)entity), (Object)dto);
        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }
    }

    public static void entity2dto(KnowledgeInfo entity, KnowledgeDTO dto) {
        try {
            BeanUtils.copyProperties((Object)dto, (Object)((Object)entity));
        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }
    }

    @Override
    @Transactional
    public String exportKnowledges(KnowledgeQueryDTO dto, int start, int limit, String sidx, String sord) {
        String filePath = "C:/Knowledge_" + new Date().getTime() + ".xls";
        String sheetName = "knowledgeBase";
        String[] colNames = new String[]{"\u6807\u9898", "\u5185\u5bb9", "\u5206\u7c7b", "\u65f6\u95f4"};
        ArrayList<String[]> data = new ArrayList<String[]>();
        PageDTO p = this.knowledgeDAO.findAllKnowledgeInfos(dto, start, limit, sidx, sord);
        if (p != null && p.getData() != null && p.getData().size() > 0) {
            List entities = p.getData();
            String categoryId = "";
            for (KnowledgeInfo item : entities) {
                if (item.getCategory() != null) {
                    categoryId = item.getCategory().getEventId() + "";
                }
                data.add(new String[]{item.getTitle(), item.getContent(), categoryId, item.getAddTime() + ""});
            }
            try {
                ExcelUtil.createSheet((String)sheetName, (String[])colNames, data, (OutputStream)new FileOutputStream(filePath));
                return filePath;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public String importKnowledgeFromExel(KnowledgeQueryDTO dto) {
        String filePath = dto.getImportPath();
        String sheetName = "knowledgeBase";
        List data = null;
        try {
            data = ExcelUtil.readSheet((String)sheetName, (InputStream)new FileInputStream(filePath));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (data != null && data.size() > 0) {
            for (String[] rowData : data) {
                KnowledgeInfo entity = new KnowledgeInfo();
                entity.setTitle(rowData[0].toString());
                entity.setContent(rowData[1].toString());
                Long cno = Long.parseLong(rowData[2]);
                EventCategory ec = (EventCategory)this.categoryDAO.findById((Serializable)cno);
                if (ec != null) {
                    entity.setCategory(ec);
                }
                entity.setAddTime(new Date(rowData[3]));
                this.knowledgeDAO.save((Object)entity);
            }
        }
        return null;
    }
}

