/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.itsm.change.dao;

import com.sinba.common.dao.BaseDAOImplHibernate;
import com.sinba.common.dto.PageDTO;
import com.sinba.itsm.change.dao.IChangeDAO;
import com.sinba.itsm.change.dto.ChangeCountResultDTO;
import com.sinba.itsm.change.dto.ChangeQueryDTO;
import com.sinba.itsm.change.entity.Changes;
import com.sinba.itsm.cim.dao.ICIDAO;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeDAO
extends BaseDAOImplHibernate<Changes>
implements IChangeDAO {
    private static int defaultStart = 0;
    private static int defaultLimit = 100000;
    @Autowired
    private ICIDAO ciDAO;

    @Override
    public PageDTO findPagerChange(ChangeQueryDTO qdto, int start, int limit, String sidx, String sord) {
        DetachedCriteria dc = DetachedCriteria.forClass(Changes.class);
        if (qdto != null) {
            GregorianCalendar endTimeCl;
            if (qdto.getChangeNo() != null) {
                dc.add((Criterion)Restrictions.like((String)"changeNo", (String)qdto.getChangeNo(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (qdto.geteTitle() != null) {
                dc.add((Criterion)Restrictions.like((String)"eTitle", (String)qdto.geteTitle(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (qdto.geteDesc() != null) {
                dc.add((Criterion)Restrictions.like((String)"eDesc", (String)qdto.geteDesc(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (qdto.getAssignee() != null) {
                dc.createAlias("technician", "te").add((Criterion)Restrictions.like((String)"te.loginName", (String)qdto.getAssignee(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (qdto.getCategoryNos() != null && qdto.getCategoryNos().length > 0) {
                dc.createAlias("category", "rc").add(Restrictions.in((String)"rc.eventId", (Object[])qdto.getCategoryNos()));
            }
            if (qdto.getStatusNo() != null) {
                dc.createAlias("status", "st").add((Criterion)Restrictions.eq((String)"st.dcode", (Object)qdto.getStatusNo()));
            }
            if (qdto.getPriorityNo() != null) {
                dc.createAlias("priority", "pr").add((Criterion)Restrictions.eq((String)"pr.dcode", (Object)qdto.getPriorityNo()));
            }
            if (qdto.getSeriousnessNo() != null) {
                dc.createAlias("seriousness", "se").add((Criterion)Restrictions.eq((String)"se.dcode", (Object)qdto.getSeriousnessNo()));
            }
            if (qdto.getEffectRangeNo() != null) {
                dc.createAlias("effectRange", "ef").add((Criterion)Restrictions.eq((String)"ef.dcode", (Object)qdto.getEffectRangeNo()));
            }
            if (qdto.getCiId() != null) {
                dc.createAlias("cis", "ci").add((Criterion)Restrictions.eq((String)"ci.ciId", (Object)qdto.getCiId()));
            }
            if (qdto.getStartTime() != null && qdto.getEndTime() == null) {
                dc.add((Criterion)Restrictions.ge((String)"createTime", (Object)qdto.getStartTime()));
            }
            if (qdto.getStartTime() == null && qdto.getEndTime() != null) {
                endTimeCl = new GregorianCalendar();
                endTimeCl.setTime(qdto.getEndTime());
                endTimeCl.set(5, endTimeCl.get(5) + 1);
                dc.add((Criterion)Restrictions.le((String)"createTime", (Object)endTimeCl.getTime()));
            }
            if (qdto.getStartTime() != null && qdto.getEndTime() != null) {
                endTimeCl = new GregorianCalendar();
                endTimeCl.setTime(qdto.getEndTime());
                endTimeCl.set(5, endTimeCl.get(5) + 1);
                dc.add((Criterion)Restrictions.and((Criterion)Restrictions.le((String)"createTime", (Object)endTimeCl.getTime()), (Criterion)Restrictions.ge((String)"createTime", (Object)qdto.getStartTime())));
            }
            if (qdto.getCountQuery() != null) {
                if (qdto.getCountQuery().equals("myNotResolveChange")) {
                    if (qdto.getCreator() != null) {
                        dc.add((Criterion)Restrictions.eq((String)"creator", (Object)qdto.getCreator()));
                    }
                    dc.add((Criterion)Restrictions.eq((String)"changeEnd", (Object)false));
                }
                if (qdto.getCountQuery().equals("myNotPassChange") && qdto.getCreator() != null) {
                    dc.createAlias("approveComments", "ac");
                    dc.createAlias("ac.approver", "acapprover");
                    dc.add((Criterion)Restrictions.eq((String)"acapprover.loginName", (Object)qdto.getCreator()));
                    dc.add(Restrictions.isNull((String)"ac.agreed"));
                }
                if (qdto.getCountQuery().equals("myPassChange") && qdto.getCreator() != null) {
                    dc.createAlias("approveComments", "ac");
                    dc.createAlias("ac.approver", "acapprover");
                    dc.add((Criterion)Restrictions.eq((String)"acapprover.loginName", (Object)qdto.getCreator()));
                    dc.add(Restrictions.isNotNull((String)"ac.agreed"));
                }
                if (qdto.getCountQuery().equals("myCloseChange")) {
                    if (qdto.getCreator() != null) {
                        dc.add((Criterion)Restrictions.eq((String)"creator", (Object)qdto.getCreator()));
                    }
                    dc.add((Criterion)Restrictions.eq((String)"changeEnd", (Object)true));
                }
                if (qdto.getCountQuery().equals("notResolveChange")) {
                    dc.add((Criterion)Restrictions.eq((String)"changeEnd", (Object)false));
                }
                if (qdto.getCountQuery().equals("closeChange")) {
                    dc.add((Criterion)Restrictions.eq((String)"changeEnd", (Object)true));
                }
                if (qdto.getCountQuery().equals("notAssigneeChange")) {
                    dc.add(Restrictions.isNull((String)"technician"));
                }
            }
        }
        if (sord != null && !sord.equals("") && sidx != null && !sidx.equals("")) {
            if (sord.equals("desc")) {
                dc.addOrder(Order.desc((String)sidx));
            } else {
                dc.addOrder(Order.asc((String)sidx));
            }
        }
        return super.findPageByCriteria(dc, start, limit);
    }

    @Override
    public String dayChangeCoun() {
        java.sql.Date date = new java.sql.Date(new Date().getTime());
        String hql = " from Changes ch where ch.createTime like '" + date + "%'";
        Integer count = this.getHibernateTemplate().find(hql).size() + 1;
        String counts = String.format("%04d", count);
        return counts;
    }

    public int countApproverChange(String type, String userName) {
        PageDTO pages = new PageDTO();
        ChangeCountResultDTO crDTO = new ChangeCountResultDTO();
        String hql = "";
        hql = " from Changes ch where ch.dataFlag not in(99) and ch.creator=? and ch.changeEnd=0";
        crDTO.setMyNotResolveChange(super.getHibernateTemplate().find(hql, (Object)userName).size());
        DetachedCriteria dc = DetachedCriteria.forClass(Changes.class);
        if (userName != null) {
            dc.createAlias("approveComments", "ac");
            dc.createAlias("ac.approver", "acapprover");
            dc.add((Criterion)Restrictions.eq((String)"acapprover.loginName", (Object)userName));
            if (type.equals("pass")) {
                dc.add(Restrictions.isNotNull((String)"ac.agreed"));
            } else {
                dc.add(Restrictions.isNull((String)"ac.agreed"));
            }
        }
        pages = super.findPageByCriteria(dc, defaultStart, defaultLimit);
        return pages.getTotalSize();
    }

    @Override
    public ChangeCountResultDTO countChange(ChangeQueryDTO queryDTO) {
        ChangeCountResultDTO crDTO = new ChangeCountResultDTO();
        String hql = "";
        hql = " from Changes ch where ch.dataFlag not in(99)";
        crDTO.setCountAllChanges(super.getHibernateTemplate().find(hql).size());
        hql = " from Changes ch where ch.dataFlag not in(99) and ch.creator=? and ch.changeEnd=0";
        crDTO.setMyNotResolveChange(super.getHibernateTemplate().find(hql, (Object)queryDTO.getCreator()).size());
        crDTO.setMyNotPassChange(this.countApproverChange("notPass", queryDTO.getCreator()));
        crDTO.setMyPassChange(this.countApproverChange("pass", queryDTO.getCreator()));
        hql = " from Changes ch where ch.dataFlag not in(99) and ch.creator=? and ch.changeEnd=1";
        crDTO.setMyCloseChange(super.getHibernateTemplate().find(hql, (Object)queryDTO.getCreator()).size());
        hql = " from Changes ch where ch.dataFlag not in(99) and ch.changeEnd=0";
        crDTO.setNotResolveChange(super.getHibernateTemplate().find(hql).size());
        hql = " from Changes ch where ch.dataFlag not in(99) and ch.changeEnd=1";
        crDTO.setCloseChange(super.getHibernateTemplate().find(hql).size());
        hql = " from Changes ch where ch.dataFlag not in(99) and ch.technician=null";
        crDTO.setNotAssigneeChange(super.getHibernateTemplate().find(hql).size());
        return crDTO;
    }

    @Override
    public Changes findByProblemNo(Long eno) {
        DetachedCriteria dc = DetachedCriteria.forClass(Changes.class);
        dc.createAlias("relatedProblems", "pb");
        dc.add((Criterion)Restrictions.eq((String)"pb.eno", (Object)eno));
        List changes = this.getHibernateTemplate().findByCriteria(dc);
        if (changes != null && changes.size() > 0) {
            return (Changes)((Object)changes.get(0));
        }
        return null;
    }
}

