/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.itsm.change.service;

import com.sinba.common.compass.dto.CompassQueryDTO;
import com.sinba.common.compass.service.ICompassSearchService;
import com.sinba.common.config.category.dao.IEventCategoryDAO;
import com.sinba.common.config.category.entity.EventCategory;
import com.sinba.common.config.dictionary.dao.IDataDictionaryItemsDAO;
import com.sinba.common.config.dictionary.entity.DataDictionaryItems;
import com.sinba.common.dto.PageDTO;
import com.sinba.common.file.excel.ExcelUtil;
import com.sinba.common.helpdeskCommon.dto.RelatedRequestGridDTO;
import com.sinba.common.jbpm.JbpmFacade;
import com.sinba.common.noticeRule.dto.NoticeInfoDTO;
import com.sinba.common.noticeRule.service.INoticeRuleService;
import com.sinba.common.security.dao.IOrganizationDAO;
import com.sinba.common.security.dao.IUserDAO;
import com.sinba.common.security.entity.Organization;
import com.sinba.common.security.entity.User;
import com.sinba.common.tools.dto.HistoryRecordDTO;
import com.sinba.common.tools.service.IHistoryRecordService;
import com.sinba.itsm.change.dao.IApproveCommentDAO;
import com.sinba.itsm.change.dao.IChangeDAO;
import com.sinba.itsm.change.dto.ApproveCommentDTO;
import com.sinba.itsm.change.dto.ApproveCommentGridDTO;
import com.sinba.itsm.change.dto.ChangeCountResultDTO;
import com.sinba.itsm.change.dto.ChangeDTO;
import com.sinba.itsm.change.dto.ChangeDetailsDTO;
import com.sinba.itsm.change.dto.ChangeGridDTO;
import com.sinba.itsm.change.dto.ChangeQueryDTO;
import com.sinba.itsm.change.entity.ApproveComment;
import com.sinba.itsm.change.entity.Changes;
import com.sinba.itsm.change.service.IChangeService;
import com.sinba.itsm.cim.dao.ICIDAO;
import com.sinba.itsm.cim.dto.CIGridDTO;
import com.sinba.itsm.cim.entity.CI;
import com.sinba.itsm.config.serviceDirectory.dao.IServiceDirectoryDAO;
import com.sinba.itsm.config.serviceDirectory.dto.ServiceDirectoryGridDTO;
import com.sinba.itsm.config.serviceDirectory.entity.ServiceDirectory;
import com.sinba.itsm.problem.dao.IProblemDAO;
import com.sinba.itsm.problem.dto.ProblemGridDTO;
import com.sinba.itsm.problem.entity.Problems;
import com.sinba.itsm.request.dao.IRequestDAO;
import com.sinba.itsm.request.entity.Request;
import java.io.InputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.compass.core.CompassHit;
import org.compass.core.support.search.CompassSearchResults;
import org.jbpm.api.ProcessInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeService
implements IChangeService {
    @Autowired
    private IChangeDAO changeDAO;
    @Autowired
    private IUserDAO userDAO;
    @Autowired
    private IDataDictionaryItemsDAO dataDictionaryItemsDAO;
    @Autowired
    private IEventCategoryDAO categoryDAO;
    @Autowired
    private ICIDAO ciDAO;
    @Autowired
    private IServiceDirectoryDAO serviceDirectoryDAO;
    @Autowired
    private IApproveCommentDAO approveCommentDAO;
    @Autowired
    private JbpmFacade jbpmFacade;
    @Autowired
    private IRequestDAO requestDAO;
    @Autowired
    private IOrganizationDAO organizationDAO;
    @Autowired
    private INoticeRuleService noticeRuleService;
    @Autowired
    private IHistoryRecordService historyRecordService;
    @Autowired
    private IProblemDAO problemDAO;
    @Autowired
    private ICompassSearchService compassSearchService;
    @Autowired
    private IEventCategoryDAO eventCategoryDAO;

    @Override
    @Transactional
    public PageDTO findPagerChange(ChangeQueryDTO qdto, int start, int limit, String sidx, String sord) {
        if (qdto != null && qdto.getCategoryNo() != null) {
            ArrayList<Long> longList = new ArrayList<Long>();
            this.findEventCategorys(qdto.getCategoryNo(), longList);
            Long[] cnos = new Long[longList.size()];
            for (int i = 0; i < longList.size(); ++i) {
                cnos[i] = (Long)longList.get(i);
            }
            qdto.setCategoryNos(cnos);
        }
        PageDTO pageDto = this.changeDAO.findPagerChange(qdto, start, limit, sidx, sord);
        List changes = pageDto.getData();
        ArrayList<ChangeGridDTO> girds = new ArrayList<ChangeGridDTO>(changes.size());
        for (Changes entity : changes) {
            ChangeGridDTO dto = new ChangeGridDTO();
            this.entityToDTO(entity, dto);
            girds.add(dto);
        }
        pageDto.setData(girds);
        return pageDto;
    }

    public void findEventCategorys(Long eventId, List<Long> longList) {
        EventCategory eventCategory = (EventCategory)this.eventCategoryDAO.findById((Serializable)eventId);
        longList.add(eventCategory.getEventId());
        if (eventCategory != null && eventCategory.getParentChildren() != null && eventCategory.getParentChildren().size() > 0) {
            for (EventCategory c : eventCategory.getParentChildren()) {
                longList.add(c.getEventId());
                this.findEventCategorys(c.getEventId(), longList);
            }
        }
    }

    public void entityToDTO(Changes entity, ChangeGridDTO dto) {
        dto.setEno(entity.getEno());
        dto.setEdesc(entity.getEdesc());
        dto.setChangeNo(entity.getChangeNo());
        dto.setEtitle(entity.getEtitle());
        dto.setCreateTime(entity.getCreateTime());
        dto.setCreator(entity.getCreator());
        if (entity.getTechnician() != null) {
            dto.setTechnician(entity.getTechnician().getUserId());
            dto.setTechnicianName(entity.getTechnician().getLoginName());
        }
        if (entity.getAssigneeGroup() != null) {
            dto.setOrgNo(entity.getAssigneeGroup().getOrgNo());
            dto.setOrgName(entity.getAssigneeGroup().getOrgName());
        }
        if (entity.getCategory() != null) {
            dto.setCategory(entity.getCategory().getEventId());
            dto.setCategoryName(entity.getCategory().getEventName());
        }
        if (entity.getEffectRange() != null) {
            dto.setEffectRange(entity.getEffectRange().getDcode());
            dto.setEffectRangeName(entity.getEffectRange().getDname());
        }
        if (entity.getPriority() != null) {
            dto.setPriority(entity.getPriority().getDcode());
            dto.setPriorityName(entity.getPriority().getDname());
        }
        if (entity.getSeriousness() != null) {
            dto.setSeriousness(entity.getSeriousness().getDcode());
            dto.setSeriousnessName(entity.getSeriousness().getDname());
        }
        if (entity.getStatus() != null) {
            dto.setStatusName(entity.getStatus().getDname());
            dto.setStatus(entity.getStatus().getDcode());
        }
    }

    @Override
    @Transactional
    public Long saveChange(ChangeDTO changeDto) {
        Changes change = new Changes();
        this.dto2entity(changeDto, change);
        change.setCreateTime(new Date());
        change.setStatus((DataDictionaryItems)this.dataDictionaryItemsDAO.findUniqueBy("dno", (Object)"change_new"));
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
        String today = fmt.format(new Date());
        change.setChangeNo("Change-" + today + this.changeDAO.dayChangeCoun());
        this.changeDAO.save((Object)change);
        HistoryRecordDTO historyRecordDto = new HistoryRecordDTO();
        historyRecordDto.setEno(change.getEno());
        historyRecordDto.setEventType("itsm.change");
        historyRecordDto.setCreatedTime(new Date());
        historyRecordDto.setOperator(changeDto.getCreator());
        historyRecordDto.setLogTitle("Change Create");
        this.historyRecordService.saveHistoryRecord(historyRecordDto);
        if (change.getTechnician() != null) {
            changeDto.setTechnicianName(change.getTechnician().getLoginName());
        }
        changeDto.setEno(change.getEno());
        HashMap<String, ChangeDTO> variables = new HashMap<String, ChangeDTO>();
        variables.put("dto", changeDto);
        String pid = this.jbpmFacade.startProcessAndNext("Changes", variables);
        change.setPid(pid);
        NoticeInfoDTO noticeInfoDto = new NoticeInfoDTO();
        noticeInfoDto.setRequestCode(change.getChangeNo());
        noticeInfoDto.setEno(change.getEno());
        noticeInfoDto.setNoticeRuleNo("notice_change_12");
        this.noticeRuleService.changeNotice(noticeInfoDto);
        return change.getEno();
    }

    @Override
    @Transactional
    public void changeBaseInfoEdit(ChangeDTO changeDto) {
        Changes change = (Changes)((Object)this.changeDAO.findById(changeDto.getEno()));
        this.dto2entity(changeDto, change);
        if (changeDto.getOrgNo() != null) {
            change.setAssigneeGroup((Organization)this.organizationDAO.findById((Serializable)changeDto.getOrgNo()));
        }
        this.changeDAO.merge((Object)change);
        HistoryRecordDTO historyRecordDto = new HistoryRecordDTO();
        historyRecordDto.setEno(change.getEno());
        historyRecordDto.setEventType("itsm.change");
        historyRecordDto.setCreatedTime(new Date());
        historyRecordDto.setOperator(changeDto.getCreator());
        historyRecordDto.setLogTitle("Change Edit");
        this.historyRecordService.saveHistoryRecord(historyRecordDto);
    }

    @Override
    @Transactional
    public void editChange(ChangeDTO changeDto) {
        Changes change = (Changes)((Object)this.changeDAO.findById(changeDto.getEno()));
        if (changeDto.getEffect() != null) {
            change.setEffect(changeDto.getEffect());
        }
        if (changeDto.getOnLinePlan() != null) {
            change.setOnLinePlan(changeDto.getOnLinePlan());
        }
        if (changeDto.getReturnPlan() != null) {
            change.setReturnPlan(changeDto.getReturnPlan());
        }
        if (changeDto.getChecklist() != null) {
            change.setChecklist(changeDto.getChecklist());
        }
        this.changeDAO.merge((Object)change);
    }

    @Override
    @Transactional
    public void deleteChange(Long[] ids) {
        this.changeDAO.deleteByIds(ids);
    }

    public void entity2dto(ChangeDetailsDTO changeDto, Changes change) {
        changeDto.setEno(change.getEno());
        changeDto.setChangeNo(change.getChangeNo());
        changeDto.setEtitle(change.getEtitle());
        changeDto.setEdesc(change.getEdesc());
        changeDto.setPlanStartTime(change.getPlanStartTime());
        changeDto.setPlanEndTime(change.getPlanEndTime());
        changeDto.setActualStartTime(change.getActualStartTime());
        changeDto.setActualEndTime(change.getActualEndTime());
        changeDto.setCreator(change.getCreator());
        changeDto.setCreateTime(change.getCreateTime());
        changeDto.setPid(change.getPid());
        changeDto.setChangeEnd(change.isChangeEnd());
        changeDto.setEffect(change.getEffect());
        changeDto.setOnLinePlan(change.getOnLinePlan());
        changeDto.setReturnPlan(change.getReturnPlan());
        changeDto.setChecklist(change.getChecklist());
        if (change.getTechnician() != null) {
            changeDto.setTechnicianNo(change.getTechnician().getUserId());
            changeDto.setTechnicianName(change.getTechnician().getLoginName());
        }
        if (change.getAssigneeGroup() != null) {
            changeDto.setOrgNo(change.getAssigneeGroup().getOrgNo());
            changeDto.setOrgName(change.getAssigneeGroup().getOrgName());
        }
        if (change.getEffectRange() != null) {
            changeDto.setEffectRangeNo(change.getEffectRange().getDcode());
            changeDto.setEffectRangeName(change.getEffectRange().getDname());
        }
        if (change.getPriority() != null) {
            changeDto.setPriorityNo(change.getPriority().getDcode());
            changeDto.setPriorityName(change.getPriority().getDname());
        }
        if (change.getSeriousness() != null) {
            changeDto.setSeriousnessNo(change.getSeriousness().getDcode());
            changeDto.setSeriousnessName(change.getSeriousness().getDname());
        }
        if (change.getStatus() != null) {
            changeDto.setStatusNo(change.getStatus().getDcode());
            changeDto.setStatusName(change.getStatus().getDname());
            changeDto.setStatusCode(change.getStatus().getDno());
        }
        if (change.getCategory() != null) {
            changeDto.setCategoryNo(change.getCategory().getEventId());
            changeDto.setCategoryName(change.getCategory().getEventName());
        }
        if (change.getCis() != null) {
            ArrayList<CIGridDTO> cis = new ArrayList<CIGridDTO>();
            for (CI cI : change.getCis()) {
                CIGridDTO cigDto = new CIGridDTO();
                cigDto.setCiId(cI.getCiId());
                cigDto.setCino(cI.getCino());
                cigDto.setCiname(cI.getCiname());
                if (cI.getStatus() != null) {
                    cigDto.setStatus(cI.getStatus().getDname());
                }
                if (cI.getCategory() != null) {
                    cigDto.setCategory(cI.getCategory().getCname());
                }
                cis.add(cigDto);
            }
            changeDto.setCigDTO(cis);
        }
        if (change.getServiceDirectory() != null) {
            ArrayList<ServiceDirectoryGridDTO> sdgs = new ArrayList<ServiceDirectoryGridDTO>();
            for (ServiceDirectory serviceDirectory : change.getServiceDirectory()) {
                ServiceDirectoryGridDTO sdgDto = new ServiceDirectoryGridDTO();
                sdgDto.setServiceDirectoryId(serviceDirectory.getServiceDirectoryId());
                sdgDto.setServiceDirectoryName(serviceDirectory.getServiceDirectoryName());
                sdgDto.setServiceDirectoryDesc(serviceDirectory.getDescription());
                sdgs.add(sdgDto);
            }
            changeDto.setSdgDTO(sdgs);
        }
        if (change.getApproveComments() != null) {
            ArrayList<ApproveCommentDTO> acs = new ArrayList<ApproveCommentDTO>();
            for (ApproveComment approveComment : change.getApproveComments()) {
                ApproveCommentDTO acDto = new ApproveCommentDTO();
                acDto.setApprover(approveComment.getApprover().getLoginName());
                acDto.setAgreed(approveComment.getAgreed());
                acs.add(acDto);
            }
            changeDto.setApproveComments(acs);
        }
    }

    public void dto2entity(ChangeDTO changeDto, Changes change) {
        change.setEtitle(changeDto.getEtitle());
        change.setEdesc(changeDto.getEdesc());
        change.setPlanStartTime(changeDto.getPlanStartTime());
        change.setPlanEndTime(changeDto.getPlanEndTime());
        change.setCreator(changeDto.getCreator());
        if (changeDto.getTechnicianNo() != null) {
            change.setTechnician((User)this.userDAO.findById((Serializable)changeDto.getTechnicianNo()));
        }
        if (changeDto.getOrgNo() != null) {
            change.setAssigneeGroup((Organization)this.organizationDAO.findById((Serializable)changeDto.getOrgNo()));
        }
        if (changeDto.getEffectRangeNo() != null) {
            change.setEffectRange((DataDictionaryItems)this.dataDictionaryItemsDAO.findById((Serializable)changeDto.getEffectRangeNo()));
        }
        if (changeDto.getPriorityNo() != null) {
            change.setPriority((DataDictionaryItems)this.dataDictionaryItemsDAO.findById((Serializable)changeDto.getPriorityNo()));
        }
        if (changeDto.getSeriousnessNo() != null) {
            change.setSeriousness((DataDictionaryItems)this.dataDictionaryItemsDAO.findById((Serializable)changeDto.getSeriousnessNo()));
        }
        if (changeDto.getStatusNo() != null) {
            change.setStatus((DataDictionaryItems)this.dataDictionaryItemsDAO.findById((Serializable)changeDto.getStatusNo()));
        }
        if (changeDto.getCategoryNo() != null) {
            change.setCategory((EventCategory)this.categoryDAO.findById((Serializable)changeDto.getCategoryNo()));
        }
        if (changeDto.getCis() != null) {
            ArrayList<CI> cis = new ArrayList<CI>();
            for (Long id : changeDto.getCis()) {
                CI ci = (CI)this.ciDAO.findById((Serializable)id);
                cis.add(ci);
            }
            change.setCis(cis);
        }
        if (changeDto.getServiceDirectory() != null) {
            ArrayList<ServiceDirectory> sds = new ArrayList<ServiceDirectory>();
            for (Long id : changeDto.getServiceDirectory()) {
                ServiceDirectory sd = (ServiceDirectory)this.serviceDirectoryDAO.findById((Serializable)id);
                sds.add(sd);
            }
            change.setServiceDirectory(sds);
        }
        if (changeDto.getRequestNos() != null && changeDto.getRequestNos().length > 0) {
            ArrayList<Request> requests = new ArrayList<Request>();
            for (Long id : changeDto.getRequestNos()) {
                requests.add((Request)this.requestDAO.findById((Serializable)id));
            }
            change.setRelatedRequest(requests);
        }
        if (changeDto.getProblemNos() != null && changeDto.getProblemNos().length > 0) {
            ArrayList<Problems> problems = new ArrayList<Problems>();
            for (Long id : changeDto.getProblemNos()) {
                problems.add((Problems)this.problemDAO.findById((Serializable)id));
            }
            change.setRelatedProblems(problems);
        }
    }

    @Override
    @Transactional
    public ChangeDetailsDTO findChangeInfo(ChangeQueryDTO qdto) {
        Changes change = (Changes)((Object)this.changeDAO.findById(qdto.getEno()));
        ChangeDetailsDTO changeDetailsDto = new ChangeDetailsDTO();
        this.entity2dto(changeDetailsDto, change);
        changeDetailsDto.setAssignee(qdto.getAssignee());
        changeDetailsDto.setTaskId(qdto.getTaskId());
        if (!change.isChangeEnd() && change.getPid() != null) {
            changeDetailsDto.setOutcomesSet(this.jbpmFacade.getOutcomes(change.getPid()));
        }
        return changeDetailsDto;
    }

    @Override
    @Transactional
    public void addApproveComment(ApproveCommentDTO acDto) {
        if (acDto != null) {
            Changes change;
            boolean existApp = true;
            ApproveComment ac = new ApproveComment();
            if ((acDto.getApproverNo() != null || acDto.getEno() != null) && (change = (Changes)((Object)this.changeDAO.findById(acDto.getEno()))).getApproveComments() != null) {
                for (ApproveComment ac1 : change.getApproveComments()) {
                    if (!ac1.getApprover().equals(this.userDAO.findById((Serializable)acDto.getApproverNo()))) continue;
                    existApp = false;
                }
                if (existApp) {
                    ac.setApprover((User)this.userDAO.findById((Serializable)acDto.getApproverNo()));
                    if (acDto.getAlternateNo() != null) {
                        ac.setAlternate((User)this.userDAO.findById((Serializable)acDto.getAlternateNo()));
                    } else {
                        ac.setAlternate(null);
                    }
                    this.approveCommentDAO.save(ac);
                    change.getApproveComments().add(ac);
                    this.changeDAO.merge((Object)change);
                }
            }
        }
    }

    @Override
    @Transactional
    public void editApproveComment(ApproveCommentDTO acDto) {
        ApproveComment ac = (ApproveComment)this.approveCommentDAO.findById(acDto.getAcId());
        ac.setAgreed(ac.getAgreed());
        ac.setComment(acDto.getComment());
        ac.setApproverTime(new Date());
        this.approveCommentDAO.merge(ac);
    }

    @Override
    @Transactional
    public void deleteApproveComment(Long changeId, Long[] ids) {
        if (ids != null) {
            ArrayList<ApproveComment> acs = new ArrayList<ApproveComment>();
            for (Long id : ids) {
                ApproveComment ac = (ApproveComment)this.approveCommentDAO.findById(id);
                acs.add(ac);
                Changes change = (Changes)((Object)this.changeDAO.findById(changeId));
                if (change.getApproveComments().contains(ac)) {
                    change.getApproveComments().remove(ac);
                }
                this.changeDAO.merge((Object)change);
            }
            this.approveCommentDAO.deleteAll(acs);
        }
    }

    @Override
    @Transactional
    public PageDTO findAllApporveComment(Long changeId, int start, int limit) {
        Changes change;
        PageDTO pageDto = new PageDTO();
        if (changeId != null && (change = (Changes)((Object)this.changeDAO.findById(changeId))).getApproveComments() != null) {
            ArrayList<ApproveCommentGridDTO> acgDtos = new ArrayList<ApproveCommentGridDTO>();
            for (ApproveComment ac : change.getApproveComments()) {
                ApproveCommentGridDTO acgDto = new ApproveCommentGridDTO();
                acgDto.setAcId(ac.getAcId());
                acgDto.setAgreed(ac.getAgreed());
                acgDto.setApprover(ac.getApprover().getLoginName());
                acgDto.setApproverNo(ac.getApprover().getUserId());
                acgDto.setApproverTime(ac.getApproverTime());
                acgDto.setComment(ac.getComment());
                if (ac.getAlternate() != null) {
                    acgDto.setAlternate(ac.getAlternate().getLoginName());
                    acgDto.setAlternateNo(ac.getAlternate().getUserId());
                }
                acgDtos.add(acgDto);
            }
            pageDto.setData(acgDtos);
            pageDto.setPage(start);
            pageDto.setTotalSize(acgDtos.size());
        }
        return pageDto;
    }

    public void entity22dto(ChangeDTO changeDto, Changes change) {
        changeDto.setEno(change.getEno());
        changeDto.setChangeNo(change.getChangeNo());
        changeDto.setEtitle(change.getEtitle());
        changeDto.setEdesc(change.getEdesc());
        changeDto.setPlanStartTime(change.getPlanStartTime());
        changeDto.setPlanEndTime(change.getPlanEndTime());
        changeDto.setCreator(change.getCreator());
        changeDto.setCreateTime(change.getCreateTime());
        changeDto.setPid(change.getPid());
        if (change.getApproveComments() != null && change.getApproveComments().size() > 0) {
            changeDto.setApproverNum(Long.parseLong(change.getApproveComments().size() + ""));
        }
        changeDto.setApproval(change.isApproval());
        if (change.getTechnician() != null) {
            changeDto.setTechnicianNo(change.getTechnician().getUserId());
            changeDto.setTechnicianName(change.getTechnician().getLoginName());
        }
        if (change.getEffectRange() != null) {
            changeDto.setEffectRangeNo(change.getEffectRange().getDcode());
        }
        if (change.getPriority() != null) {
            changeDto.setPriorityNo(change.getPriority().getDcode());
        }
        if (change.getSeriousness() != null) {
            changeDto.setSeriousnessNo(change.getSeriousness().getDcode());
        }
        if (change.getStatus() != null) {
            changeDto.setStatusNo(change.getStatus().getDcode());
        }
        if (change.getCategory() != null) {
            changeDto.setCategoryNo(change.getCategory().getEventId());
        }
        if (change.getApproveComments() != null) {
            ArrayList<ApproveCommentGridDTO> acgDto = new ArrayList<ApproveCommentGridDTO>();
            for (ApproveComment ac : change.getApproveComments()) {
                ApproveCommentGridDTO acg = new ApproveCommentGridDTO();
                acg.setAcId(ac.getAcId());
                acg.setApprover(ac.getApprover().getLoginName());
                acgDto.add(acg);
            }
            changeDto.setApproveCommentDTO(acgDto);
        }
        changeDto.setEffect(change.getEffect());
        changeDto.setOnLinePlan(change.getOnLinePlan());
        changeDto.setReturnPlan(change.getReturnPlan());
        changeDto.setChecklist(change.getChecklist());
    }

    public boolean ifApproverAllPass(List<ApproveComment> acs) {
        boolean result = true;
        if (acs != null) {
            for (ApproveComment ac : acs) {
                if (ac.getAgreed() == null) {
                    result = false;
                    continue;
                }
                if (ac.getAgreed().booleanValue()) continue;
                result = false;
            }
        }
        return result;
    }

    public boolean ifApproverAllDo(List<ApproveComment> acs) {
        boolean result = true;
        if (acs != null) {
            for (ApproveComment ac : acs) {
                if (ac.getAgreed() != null) continue;
                result = false;
            }
        }
        return result;
    }

    @Override
    @Transactional
    public void changeAction(ChangeDTO changeDto, ApproveCommentDTO acDto, HistoryRecordDTO hrDTO) {
        Changes change;
        if (changeDto.getChangeAction().equals("assingeeTechnician")) {
            this.assigneeTechnicianAction(changeDto);
        }
        if (changeDto.getChangeAction().equals("startChangePlan")) {
            change = (Changes)((Object)this.changeDAO.findById(changeDto.getEno()));
            change.setStatus((DataDictionaryItems)this.dataDictionaryItemsDAO.findUniqueBy("dno", (Object)"change_plan"));
            if (change.getActualStartTime() == null) {
                change.setActualStartTime(new Date());
            }
            this.changeDAO.merge((Object)change);
        }
        if (changeDto.getChangeAction().equals("submitApprover")) {
            this.submitApproverAction(changeDto);
        }
        if (changeDto.getChangeAction().equals("memberApprover")) {
            this.memberApproverAction(changeDto, acDto);
        }
        if (changeDto.getChangeAction().equals("implementComplete")) {
            change = (Changes)((Object)this.changeDAO.findById(changeDto.getEno()));
            change.setStatus((DataDictionaryItems)this.dataDictionaryItemsDAO.findUniqueBy("dno", (Object)"change_review"));
            this.changeDAO.merge((Object)change);
            this.processNext(changeDto.getPid(), "\u590d\u5ba1");
        }
        if (changeDto.getChangeAction().equals("review")) {
            this.reviewAction(changeDto);
        }
        this.saveHistoryRecord(changeDto.getEno(), hrDTO);
    }

    @Transactional
    public void assigneeTechnicianAction(ChangeDTO changeDto) {
        if (changeDto.getEno() != null) {
            Changes change = (Changes)((Object)this.changeDAO.findById(changeDto.getEno()));
            if (changeDto.getTechnicianNo() != null) {
                change.setTechnician((User)this.userDAO.findById((Serializable)changeDto.getTechnicianNo()));
            }
            if (change.getActualStartTime() == null) {
                change.setActualStartTime(new Date());
            }
            NoticeInfoDTO noticeInfoDto = new NoticeInfoDTO();
            noticeInfoDto.setRequestCode(change.getChangeNo());
            noticeInfoDto.setEno(change.getEno());
            noticeInfoDto.setNoticeRuleNo("notice_change_12");
            noticeInfoDto.setUserNo(changeDto.getTechnicianNo());
            this.noticeRuleService.changeNotice(noticeInfoDto);
            this.changeDAO.merge((Object)change);
        }
    }

    @Transactional
    public void submitApproverAction(ChangeDTO changeDto) {
        Changes change = (Changes)((Object)this.changeDAO.findById(changeDto.getEno()));
        change.setStatus((DataDictionaryItems)this.dataDictionaryItemsDAO.findUniqueBy("dno", (Object)"change_approval"));
        this.changeDAO.merge((Object)change);
        ChangeDTO dto = new ChangeDTO();
        this.entity22dto(dto, change);
        HashMap<String, ChangeDTO> variables = new HashMap<String, ChangeDTO>();
        variables.put("dto", dto);
        this.jbpmFacade.reSetVariablesByPid(changeDto.getPid(), variables);
        this.processNext(changeDto.getPid(), "\u6bcf\u4e2a\u5ba1\u6279\u59d4\u5458");
        NoticeInfoDTO noticeInfoDto = new NoticeInfoDTO();
        noticeInfoDto.setRequestCode(changeDto.getChangeNo());
        if (change.getApproveComments() != null) {
            ArrayList<User> user = new ArrayList<User>();
            for (ApproveComment ac : change.getApproveComments()) {
                if (ac == null || ac.getApprover() == null) continue;
                user.add(ac.getApprover());
            }
            noticeInfoDto.setUsers(user);
        }
        noticeInfoDto.setNoticeRuleNo("notice_change_13");
        noticeInfoDto.setRequestCode(change.getChangeNo());
        noticeInfoDto.setEno(change.getEno());
        noticeInfoDto.setUserNo(changeDto.getTechnicianNo());
        this.noticeRuleService.changeNotice(noticeInfoDto);
        this.changeDAO.merge((Object)change);
    }

    @Transactional
    public void memberApproverAction(ChangeDTO changeDto, ApproveCommentDTO acDto) {
        Changes change = (Changes)((Object)this.changeDAO.findById(changeDto.getEno()));
        if (acDto.getApprover() != null) {
            User user = (User)this.userDAO.findUniqueBy("loginName", (Object)acDto.getApprover());
            if (change.getApproveComments() != null) {
                for (ApproveComment ac : change.getApproveComments()) {
                    if (ac.getApprover().getUserId() != user.getUserId()) continue;
                    ac.setComment(acDto.getComment());
                    ac.setAgreed(acDto.getAgreed());
                    ac.setApproverTime(new Date());
                    this.approveCommentDAO.merge(ac);
                }
            }
        }
        if (change.getApproveComments() != null) {
            if (this.ifApproverAllDo(change.getApproveComments())) {
                if (this.ifApproverAllPass(change.getApproveComments())) {
                    change.setStatus((DataDictionaryItems)this.dataDictionaryItemsDAO.findUniqueBy("dno", (Object)"change_implement"));
                } else {
                    for (ApproveComment ac : change.getApproveComments()) {
                        ac.setAgreed(null);
                        ac.setApproverTime(null);
                        ac.setComment(null);
                        this.approveCommentDAO.merge(ac);
                    }
                    change.setStatus((DataDictionaryItems)this.dataDictionaryItemsDAO.findUniqueBy("dno", (Object)"change_plan"));
                }
            }
            ChangeDTO dto = new ChangeDTO();
            this.entity22dto(dto, change);
            dto.setApproval(this.ifApproverAllPass(change.getApproveComments()));
            HashMap<String, ChangeDTO> variables = new HashMap<String, ChangeDTO>();
            variables.put("dto", dto);
            this.jbpmFacade.completeTask(changeDto.getTaskId(), "\u5ba1\u6279\u7ed3\u675f", variables);
            NoticeInfoDTO noticeInfoDto = new NoticeInfoDTO();
            noticeInfoDto.setRequestCode(change.getChangeNo());
            noticeInfoDto.setEno(change.getEno());
            noticeInfoDto.setNoticeRuleNo("notice_change_15");
            this.noticeRuleService.changeNotice(noticeInfoDto);
        }
        this.changeDAO.merge((Object)change);
    }

    public void reviewAction(ChangeDTO changeDto) {
        Changes change = (Changes)((Object)this.changeDAO.findById(changeDto.getEno()));
        if (changeDto.getAction() != null) {
            if (changeDto.getAction().equals("close")) {
                change.setChangeEnd(true);
                change.setStatus((DataDictionaryItems)this.dataDictionaryItemsDAO.findUniqueBy("dno", (Object)"change_close"));
                change.setActualEndTime(new Date());
                this.changeDAO.merge((Object)change);
                this.processNext(changeDto.getPid(), "\u7ed3\u675f");
                NoticeInfoDTO noticeInfoDto = new NoticeInfoDTO();
                noticeInfoDto.setRequestCode(change.getChangeNo());
                noticeInfoDto.setEno(change.getEno());
                noticeInfoDto.setNoticeRuleNo("notice_change_16");
                this.noticeRuleService.changeNotice(noticeInfoDto);
                noticeInfoDto.setNoticeRuleNo("notice_change_17");
                this.noticeRuleService.changeNotice(noticeInfoDto);
            }
            if (changeDto.getAction().equals("goBack")) {
                change.setStatus((DataDictionaryItems)this.dataDictionaryItemsDAO.findUniqueBy("dno", (Object)"change_implement"));
                this.processNext(changeDto.getPid(), "\u9000\u56de\u53d8\u66f4\u5b9e\u65bd");
            }
        }
    }

    public void processNext(String pid, String toNext) {
        try {
            ProcessInstance pi = this.jbpmFacade.getInstanceById(pid);
            String nextActivityName = (String)this.jbpmFacade.getActivityNamesByInstance(pi).iterator().next();
            this.jbpmFacade.takeTask(pid, nextActivityName, "", toNext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @Transactional
    public boolean changeApproveMemberExist(ChangeDTO changeDTO) {
        if (changeDTO.getEno() != null) {
            Changes change = (Changes)((Object)this.changeDAO.findById(changeDTO.getEno()));
            return !change.getApproveComments().isEmpty();
        }
        return false;
    }

    @Transactional
    public void saveHistoryRecord(Long eno, HistoryRecordDTO historyRecordDTO) {
        historyRecordDTO.setEno(eno);
        historyRecordDTO.setEventType("itsm.change");
        historyRecordDTO.setCreatedTime(new Date());
        this.historyRecordService.saveHistoryRecord(historyRecordDTO);
    }

    @Override
    public ChangeCountResultDTO countChange(ChangeQueryDTO queryDTO) {
        ChangeCountResultDTO ccrDTO = this.changeDAO.countChange(queryDTO);
        if (queryDTO.getCreator() != null) {
            ccrDTO.setMyTask(this.jbpmFacade.findTaskDtos(queryDTO.getCreator(), 0, 1000).getTotalSize());
            ccrDTO.setMyGroupTask(this.jbpmFacade.findGroupTaskDtos(queryDTO.getCreator(), 0, 1000).getTotalSize());
        }
        return ccrDTO;
    }

    @Override
    @Transactional
    public void addRelatedRequest(Long changeId, Long[] enos) {
        if (changeId != null) {
            Changes change = (Changes)((Object)this.changeDAO.findById(changeId));
            if (enos != null) {
                ArrayList<Request> requests = new ArrayList<Request>();
                for (Long id : enos) {
                    Request request = (Request)this.requestDAO.findById((Serializable)id);
                    requests.add(request);
                    if (change.getRelatedRequest() == null || change.getRelatedRequest().contains(request)) continue;
                    change.getRelatedRequest().add(request);
                }
                if (change.getRelatedRequest() == null) {
                    change.setRelatedRequest(requests);
                }
            }
        }
    }

    @Override
    @Transactional
    public void deleteRelatedRequest(Long changeId, Long[] enos) {
        if (changeId != null) {
            Changes change = (Changes)((Object)this.changeDAO.findById(changeId));
            if (change.getRelatedRequest() != null && enos != null) {
                for (Long id : enos) {
                    Request request = (Request)this.requestDAO.findById((Serializable)id);
                    if (!change.getRelatedRequest().contains(request)) continue;
                    change.getRelatedRequest().remove(request);
                }
            }
            this.changeDAO.merge((Object)change);
        }
    }

    @Override
    @Transactional
    public void addRelatedProblem(Long changeId, Long[] enos) {
        if (changeId != null && enos != null && enos.length > 0) {
            Changes change = (Changes)((Object)this.changeDAO.findById(changeId));
            for (Long id : enos) {
                Problems problem = (Problems)this.problemDAO.findById((Serializable)id);
                if (change.getRelatedRequest() != null && (change.getRelatedRequest() == null || change.getRelatedProblems().contains(problem))) continue;
                change.getRelatedProblems().add(problem);
            }
        }
    }

    @Override
    @Transactional
    public void deleteRelatedProblem(Long changeId, Long[] enos) {
        if (changeId != null && enos != null && enos.length > 0) {
            Changes change = (Changes)((Object)this.changeDAO.findById(changeId));
            for (Long id : enos) {
                change.getRelatedProblems().remove(this.problemDAO.findById((Serializable)id));
            }
        }
    }

    @Override
    @Transactional
    public PageDTO getChangeRelatedRequest(Long changeId, int page, int limit) {
        Changes change = (Changes)((Object)this.changeDAO.findById(changeId));
        PageDTO p = new PageDTO();
        if (change.getRelatedRequest() != null && change.getRelatedRequest().size() > 0) {
            int totalSize = change.getRelatedRequest().size();
            int start = (page - 1) * limit;
            int end = 0;
            if (totalSize < limit) {
                end = totalSize - 1;
            } else {
                end = limit * page - 1;
                if (end > totalSize) {
                    end = totalSize - 1;
                }
            }
            ArrayList<RelatedRequestGridDTO> dtos = new ArrayList<RelatedRequestGridDTO>();
            for (int i = start; i <= end; ++i) {
                RelatedRequestGridDTO dto = new RelatedRequestGridDTO();
                dto.setEno(change.getRelatedRequest().get(i).getEno());
                if (change.getRelatedRequest().get(i).getRequestCategory() != null) {
                    dto.setEcategoryName(change.getRelatedRequest().get(i).getRequestCategory().getEventName());
                }
                dto.setEtitle(change.getRelatedRequest().get(i).getEtitle());
                dto.setRequestCode(change.getRelatedRequest().get(i).getRequestCode());
                if (change.getRelatedRequest().get(i).getCreatedBy() != null) {
                    dto.setCreatedByName(change.getRelatedRequest().get(i).getCreatedBy().getLoginName());
                }
                if (change.getRelatedRequest().get(i).getAssignee() != null) {
                    dto.setAssigneeName(change.getRelatedRequest().get(i).getAssignee().getLoginName());
                }
                if (change.getRelatedRequest().get(i).getPriority() != null) {
                    dto.setPriorityName(change.getRelatedRequest().get(i).getPriority().getDname());
                }
                if (change.getRelatedRequest().get(i).getStatus() != null) {
                    dto.setStatusName(change.getRelatedRequest().get(i).getStatus().getDname());
                }
                dto.setCreatedOn(change.getRelatedRequest().get(i).getCreatedOn());
                if (change.getRelatedRequest().get(i).getSlaContract() != null) {
                    dto.setSlaState(change.getRelatedRequest().get(i).getSlaContract().getContractName());
                }
                dtos.add(dto);
            }
            p.setData(dtos);
            p.setTotalSize(totalSize);
        }
        return p;
    }

    @Override
    @Transactional
    public PageDTO getChangeRelatedProblem(Long changeId, int page, int limit) {
        Changes change = (Changes)((Object)this.changeDAO.findById(changeId));
        PageDTO p = new PageDTO();
        if (change.getRelatedProblems() != null && change.getRelatedProblems().size() > 0) {
            int totalSize = change.getRelatedProblems().size();
            int start = (page - 1) * limit;
            int end = 0;
            if (totalSize < limit) {
                end = totalSize - 1;
            } else {
                end = limit * page - 1;
                if (end > totalSize) {
                    end = totalSize - 1;
                }
            }
            ArrayList<ProblemGridDTO> dtos = new ArrayList<ProblemGridDTO>();
            for (int i = start; i <= end; ++i) {
                ProblemGridDTO dto = new ProblemGridDTO();
                ProblemGridDTO.entity2dto((Problems)change.getRelatedProblems().get(i), (ProblemGridDTO)dto);
                dtos.add(dto);
            }
            p.setData(dtos);
            p.setTotalSize(totalSize);
        }
        return p;
    }

    @Override
    @Transactional
    public InputStream exportChangeItems(ChangeQueryDTO queryDTO, int start, int limit, String sidx, String sord) {
        String sheetName = "\u53d8\u66f4";
        String[] colNames = new String[]{"\u7f16\u53f7", "\u6807\u9898", "\u63cf\u8ff0", "\u6307\u6d3e\u7ec4", "\u6307\u6d3e\u6280\u672f\u5458", "\u5206\u7c7b", "\u72b6\u6001", "\u4f18\u5148\u7ea7", "\u5f71\u54cd\u8303\u56f4", "\u7d27\u6025\u5ea6", "\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4", "\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4", "\u521b\u5efa\u65f6\u95f4", "\u521b\u5efa\u8005"};
        ArrayList<String[]> data = new ArrayList<String[]>();
        PageDTO p = this.changeDAO.findPagerChange(queryDTO, start, limit, sidx, sord);
        if (p != null && p.getData() != null && p.getData().size() > 0) {
            List entities = p.getData();
            for (Changes item : entities) {
                this.convertChangeToStringArray(item, data);
            }
            try {
                return ExcelUtil.createSheetExcel((String)sheetName, (String[])colNames, data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ExcelUtil.createSheetExcel((String)sheetName, (String[])colNames, data);
    }

    public void convertChangeToStringArray(Changes item, List<String[]> data) {
        String assigneeGroup = "";
        String technician = "";
        String category = "";
        String status = "";
        String priority = "";
        String effectRange = "";
        String seriousness = "";
        String planStartTime = "";
        String planEndTime = "";
        String createTime = "";
        if (item.getAssigneeGroup() != null) {
            assigneeGroup = item.getAssigneeGroup().getOrgName();
        }
        if (item.getTechnician() != null) {
            technician = item.getTechnician().getLoginName();
        }
        if (item.getCategory() != null) {
            category = item.getCategory().getEventName();
        }
        if (item.getStatus() != null) {
            status = item.getStatus().getDname();
        }
        if (item.getPriority() != null) {
            priority = item.getPriority().getDname();
        }
        if (item.getEffectRange() != null) {
            effectRange = item.getEffectRange().getDname();
        }
        if (item.getSeriousness() != null) {
            seriousness = item.getSeriousness().getDname();
        }
        if (item.getPlanStartTime() != null) {
            planStartTime = ChangeService.DateToStr(item.getPlanStartTime());
        }
        if (item.getPlanEndTime() != null) {
            planEndTime = ChangeService.DateToStr(item.getPlanEndTime());
        }
        if (item.getCreateTime() != null) {
            createTime = ChangeService.DateToStr(item.getCreateTime());
        }
        data.add(new String[]{item.getChangeNo(), item.getEtitle(), item.getEdesc(), assigneeGroup, technician, category, status, priority, effectRange, seriousness, planStartTime, planEndTime, createTime, item.getCreator()});
    }

    public static String DateToStr(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String str = format.format(date);
        return str;
    }

    @Override
    @Transactional
    public ChangeDTO findChangeByProblem(Long problemNo) {
        Changes change = this.changeDAO.findByProblemNo(problemNo);
        if (change != null) {
            ChangeDTO dto = new ChangeDTO();
            dto.setEtitle(change.getEtitle());
            dto.setEno(change.getEno());
            return dto;
        }
        return null;
    }

    @Override
    @Transactional
    public PageDTO fullSearch(CompassQueryDTO compassQueryDTO, int page, int rows) {
        CompassSearchResults csr = this.compassSearchService.doSearch(compassQueryDTO, page, rows);
        PageDTO changes = new PageDTO();
        changes.setTotalSize(csr.getTotalHits());
        changes.setPage(page);
        changes.setRows(rows);
        ArrayList<ChangeGridDTO> data = new ArrayList<ChangeGridDTO>();
        CompassHit[] hit = csr.getHits();
        for (int i = 0; i < hit.length; ++i) {
            Changes entity = (Changes)((Object)hit[i].data());
            Changes newChanges = (Changes)((Object)this.changeDAO.findById(entity.getEno()));
            if (newChanges == null) continue;
            ChangeGridDTO dto = new ChangeGridDTO();
            this.entityToDTO(newChanges, dto);
            data.add(dto);
        }
        changes.setData(data);
        return changes;
    }
}

