/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.impl;

import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.apache.commons.pool.BaseObjectPool;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;

public class StackObjectPool
extends BaseObjectPool
implements ObjectPool {
    protected static final int DEFAULT_MAX_SLEEPING = 8;
    protected static final int DEFAULT_INIT_SLEEPING_CAPACITY = 4;
    protected Stack _pool = null;
    protected PoolableObjectFactory _factory = null;
    protected int _maxSleeping = 8;
    protected int _numActive = 0;

    public StackObjectPool() {
        this(null, 8, 4);
    }

    public StackObjectPool(int maxIdle) {
        this(null, maxIdle, 4);
    }

    public StackObjectPool(int maxIdle, int initIdleCapacity) {
        this(null, maxIdle, initIdleCapacity);
    }

    public StackObjectPool(PoolableObjectFactory factory) {
        this(factory, 8, 4);
    }

    public StackObjectPool(PoolableObjectFactory factory, int maxIdle) {
        this(factory, maxIdle, 4);
    }

    public StackObjectPool(PoolableObjectFactory factory, int maxIdle, int initIdleCapacity) {
        this._factory = factory;
        this._maxSleeping = maxIdle < 0 ? 8 : maxIdle;
        int initcapacity = initIdleCapacity < 1 ? 4 : initIdleCapacity;
        this._pool = new Stack();
        this._pool.ensureCapacity(initcapacity > this._maxSleeping ? this._maxSleeping : initcapacity);
    }

    public synchronized Object borrowObject() throws Exception {
        this.assertOpen();
        Object obj = null;
        try {
            obj = this._pool.pop();
        }
        catch (EmptyStackException e) {
            if (null == this._factory) {
                throw new NoSuchElementException();
            }
            obj = this._factory.makeObject();
        }
        if (null != this._factory && null != obj) {
            this._factory.activateObject(obj);
        }
        ++this._numActive;
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(Object obj) throws Exception {
        this.assertOpen();
        boolean success = true;
        if (null != this._factory) {
            if (!this._factory.validateObject(obj)) {
                success = false;
            } else {
                try {
                    this._factory.passivateObject(obj);
                }
                catch (Exception e) {
                    success = false;
                }
            }
        }
        boolean shouldDestroy = !success;
        StackObjectPool stackObjectPool = this;
        synchronized (stackObjectPool) {
            --this._numActive;
            if (this._pool.size() >= this._maxSleeping) {
                shouldDestroy = true;
            } else if (success) {
                this._pool.push(obj);
            }
            this.notifyAll();
        }
        if (shouldDestroy) {
            try {
                this._factory.destroyObject(obj);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public synchronized void invalidateObject(Object obj) throws Exception {
        this.assertOpen();
        --this._numActive;
        if (null != this._factory) {
            this._factory.destroyObject(obj);
        }
        this.notifyAll();
    }

    public int getNumIdle() {
        this.assertOpen();
        return this._pool.size();
    }

    public int getNumActive() {
        this.assertOpen();
        return this._numActive;
    }

    public synchronized void clear() {
        this.assertOpen();
        if (null != this._factory) {
            Enumeration enumeration = this._pool.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    this._factory.destroyObject(enumeration.nextElement());
                }
                catch (Exception exception) {}
            }
        }
        this._pool.clear();
    }

    public synchronized void close() throws Exception {
        this.clear();
        this._pool = null;
        this._factory = null;
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObject() throws Exception {
        Object obj = this._factory.makeObject();
        StackObjectPool stackObjectPool = this;
        synchronized (stackObjectPool) {
            ++this._numActive;
            this.returnObject(obj);
        }
    }

    public synchronized void setFactory(PoolableObjectFactory factory) throws IllegalStateException {
        this.assertOpen();
        if (0 < this.getNumActive()) {
            throw new IllegalStateException("Objects are already active");
        }
        this.clear();
        this._factory = factory;
    }
}

