/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.cmd;

import java.util.Date;
import org.jbpm.api.JbpmException;
import org.jbpm.api.cmd.Environment;
import org.jbpm.api.job.Job;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.cmd.AbstractCommand;
import org.jbpm.pvm.internal.cmd.CommandService;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.env.JobContext;
import org.jbpm.pvm.internal.job.JobImpl;
import org.jbpm.pvm.internal.jobexecutor.JobExceptionHandler;
import org.jbpm.pvm.internal.session.DbSession;
import org.jbpm.pvm.internal.tx.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecuteJobCmd
extends AbstractCommand<Job> {
    private static final long serialVersionUID = 1L;
    private static final Log log = Log.getLog((String)ExecuteJobCmd.class.getName());
    protected Long jobDbid;
    protected JobExceptionHandler jobExceptionHandler;

    public ExecuteJobCmd(String jobId) {
        if (jobId == null) {
            throw new JbpmException("jobId is null");
        }
        this.jobDbid = Long.parseLong(jobId);
    }

    public ExecuteJobCmd(Long jobDbid) {
        this.jobDbid = jobDbid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Job execute(Environment environmentInterface) throws Exception {
        EnvironmentImpl environment = (EnvironmentImpl)environmentInterface;
        DbSession dbSession = environment.get(DbSession.class);
        if (dbSession == null) {
            throw new JbpmException("no db-session configured");
        }
        JobImpl job = dbSession.get(JobImpl.class, this.jobDbid);
        if (job != null) {
            this.registerJobExceptionHandler(environment, job);
            JobContext jobContext = new JobContext(job);
            environment.setContext(jobContext);
            try {
                Date lockExpirationDate;
                log.debug("executing job " + job + "...");
                Boolean deleteJob = (Boolean)job.execute(environment);
                log.debug("executed job " + job);
                if (deleteJob.booleanValue()) {
                    dbSession.delete(job);
                }
                if ((lockExpirationDate = job.getLockExpirationTime()) == null) return job;
                long lockExpiration = lockExpirationDate.getTime();
                long currentTime = System.currentTimeMillis();
                if (currentTime <= lockExpiration) return job;
                throw new JbpmException("job took too long: lock expired " + (currentTime - lockExpiration) + "ms ago");
            }
            catch (Exception exception) {
                log.error("exception while executing '" + job + "'", (Throwable)exception);
                this.handleJobExecutionException(exception);
                return job;
            }
            finally {
                environment.removeContext(jobContext);
            }
        } else {
            log.debug("job " + this.jobDbid + " no longer exists");
        }
        return job;
    }

    protected void handleJobExecutionException(Exception exception) {
        if (this.jobExceptionHandler != null) {
            this.jobExceptionHandler.setException(exception);
        } else {
            log.warn("jobExceptionHandler hasnot initialized for exception : " + exception.getMessage());
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new JbpmException("job failed: " + exception.getMessage(), (Throwable)exception);
    }

    protected void registerJobExceptionHandler(Environment environment, JobImpl job) {
        Transaction transaction = (Transaction)environment.get(Transaction.class);
        CommandService commandService = (CommandService)environment.get("newTxRequiredCommandService");
        this.jobExceptionHandler = new JobExceptionHandler(job.getDbid(), commandService);
        try {
            transaction.registerSynchronization(this.jobExceptionHandler);
        }
        catch (Exception ex) {
            log.warn("cannot register synchronization on current transaction : " + ex.getMessage() + " job : " + job.getDbid());
        }
    }
}

