/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.lob;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.pvm.internal.lob.BlobStrategy;
import org.jbpm.pvm.internal.lob.BytesChop;
import org.jbpm.pvm.internal.lob.Lob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlobStrategyChopped
implements BlobStrategy {
    int chopSize = 1024;

    @Override
    public void set(byte[] bytes, Lob lob) {
        lob.bytesChops = this.chop(bytes);
    }

    @Override
    public byte[] get(Lob lob) {
        return this.glue(lob.bytesChops);
    }

    public List<BytesChop> chop(byte[] bytes) {
        ArrayList<BytesChop> chops = null;
        if (bytes != null && bytes.length > 0) {
            byte[] byteBlock;
            chops = new ArrayList<BytesChop>();
            int index = 0;
            while (bytes.length - index > this.chopSize) {
                byteBlock = new byte[this.chopSize];
                System.arraycopy(bytes, index, byteBlock, 0, this.chopSize);
                chops.add(new BytesChop(byteBlock));
                index += this.chopSize;
            }
            byteBlock = new byte[bytes.length - index];
            System.arraycopy(bytes, index, byteBlock, 0, bytes.length - index);
            chops.add(new BytesChop(byteBlock));
        }
        return chops;
    }

    public byte[] glue(List<BytesChop> bytesChops) {
        byte[] bytes = null;
        if (bytesChops != null) {
            for (BytesChop bytesChop : bytesChops) {
                if (bytes == null) {
                    bytes = bytesChop.getBytes();
                    continue;
                }
                byte[] oldValue = bytes;
                bytes = new byte[bytes.length + bytesChop.getBytes().length];
                System.arraycopy(oldValue, 0, bytes, 0, oldValue.length);
                System.arraycopy(bytesChop.getBytes(), 0, bytes, oldValue.length, bytesChop.getBytes().length);
            }
        }
        return bytes;
    }
}

