/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.repository;

import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.repository.Deployer;
import org.jbpm.pvm.internal.repository.DeploymentImpl;
import org.jbpm.pvm.internal.repository.RepositoryCache;

public class RulesDeployer
implements Deployer {
    public static final String CACHEKEY_KNOWLEDGEBASE = "KnowledgeBase";

    public void deploy(DeploymentImpl deployment) {
        KnowledgeBuilder knowledgeBuilder = null;
        for (String resourceName : deployment.getResourceNames()) {
            if (!resourceName.endsWith(".drl")) continue;
            if (knowledgeBuilder == null) {
                knowledgeBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
            }
            byte[] drlBytes = deployment.getBytes(resourceName);
            knowledgeBuilder.add(ResourceFactory.newByteArrayResource((byte[])drlBytes), ResourceType.DRL);
        }
        if (knowledgeBuilder != null) {
            if (knowledgeBuilder.hasErrors()) {
                for (KnowledgeBuilderError error : knowledgeBuilder.getErrors()) {
                    deployment.addProblem("drl problem: " + error.getMessage());
                }
            } else {
                KnowledgeBase knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase();
                knowledgeBase.addKnowledgePackages(knowledgeBuilder.getKnowledgePackages());
                RepositoryCache repositoryCache = EnvironmentImpl.getFromCurrent(RepositoryCache.class);
                repositoryCache.set(deployment.getId(), CACHEKEY_KNOWLEDGEBASE, knowledgeBase);
            }
        }
    }

    public static KnowledgeBase getKnowledgeBase(String deploymentId) {
        return RulesDeployer.getKnowledgeBase(deploymentId, CACHEKEY_KNOWLEDGEBASE);
    }

    public static KnowledgeBase getKnowledgeBase(String deploymentId, String knowledgeBaseName) {
        RepositoryCache repositoryCache = EnvironmentImpl.getFromCurrent(RepositoryCache.class);
        return (KnowledgeBase)repositoryCache.get(deploymentId, knowledgeBaseName);
    }

    public void updateResource(DeploymentImpl deployment, String resourceName, byte[] bytes) {
        if (resourceName.endsWith(".drl")) {
            throw new UnsupportedOperationException("drl resource updates is not implemented yet.  please contribute :-)");
        }
    }
}

