/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.wire.binding;

import java.util.ArrayList;
import org.jbpm.pvm.internal.email.impl.AddressFilter;
import org.jbpm.pvm.internal.email.impl.MailServer;
import org.jbpm.pvm.internal.email.impl.MailSessionImpl;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.wire.Descriptor;
import org.jbpm.pvm.internal.wire.binding.ObjectBinding;
import org.jbpm.pvm.internal.wire.binding.PropertiesBinding;
import org.jbpm.pvm.internal.wire.binding.WireDescriptorBinding;
import org.jbpm.pvm.internal.wire.descriptor.JndiDescriptor;
import org.jbpm.pvm.internal.wire.descriptor.ListDescriptor;
import org.jbpm.pvm.internal.wire.descriptor.ObjectDescriptor;
import org.jbpm.pvm.internal.wire.descriptor.PatternDescriptor;
import org.jbpm.pvm.internal.wire.descriptor.PropertiesDescriptor;
import org.jbpm.pvm.internal.xml.Parse;
import org.jbpm.pvm.internal.xml.Parser;
import org.w3c.dom.Element;

public class MailSessionBinding
extends WireDescriptorBinding {
    public MailSessionBinding() {
        super("mail-session");
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        ArrayList<Descriptor> serverDescriptors = new ArrayList<Descriptor>();
        for (Element serverElement : XmlUtil.elements(element, "mail-server")) {
            Element authenticatorElement;
            ObjectDescriptor serverDescriptor = new ObjectDescriptor(MailServer.class);
            serverDescriptors.add(serverDescriptor);
            Element filterElement = XmlUtil.element(serverElement, "address-filter");
            if (filterElement != null) {
                ArrayList<Descriptor> includeDescriptors = new ArrayList<Descriptor>();
                for (Element includeElement : XmlUtil.elements(filterElement, "include")) {
                    includeDescriptors.add(MailSessionBinding.parsePattern(includeElement, parse, parser));
                }
                ListDescriptor includesDescriptor = new ListDescriptor();
                includesDescriptor.setValueDescriptors(includeDescriptors);
                ArrayList<Descriptor> excludeDescriptors = new ArrayList<Descriptor>();
                for (Element excludeElement : XmlUtil.elements(filterElement, "exclude")) {
                    excludeDescriptors.add(MailSessionBinding.parsePattern(excludeElement, parse, parser));
                }
                ListDescriptor excludesDescriptor = new ListDescriptor();
                excludesDescriptor.setValueDescriptors(excludeDescriptors);
                ObjectDescriptor filterDescriptor = new ObjectDescriptor(AddressFilter.class);
                filterDescriptor.addInjection("includePatterns", includesDescriptor);
                filterDescriptor.addInjection("excludePatterns", excludesDescriptor);
                serverDescriptor.addInjection("addressFilter", filterDescriptor);
            }
            if (serverElement.hasAttribute("session-jndi")) {
                String jndiName = serverElement.getAttribute("session-jndi");
                JndiDescriptor jndiDescriptor = new JndiDescriptor(jndiName);
                serverDescriptor.addInjection("mailSession", jndiDescriptor);
                continue;
            }
            Element propertiesElement = XmlUtil.element(serverElement, "session-properties");
            if (propertiesElement != null) {
                PropertiesDescriptor propertiesDescriptor = PropertiesBinding.parseDescriptor(propertiesElement, parse, parser);
                serverDescriptor.addInjection("sessionProperties", propertiesDescriptor);
            } else {
                parse.addProblem("missing mail session properties or jndi name", serverElement);
            }
            if ((authenticatorElement = XmlUtil.element(serverElement, "authenticator")) == null) continue;
            ObjectDescriptor authenticatorDescriptor = ObjectBinding.parseObjectDescriptor(authenticatorElement, parse, parser);
            serverDescriptor.addInjection("authenticator", authenticatorDescriptor);
        }
        ListDescriptor serversDescriptor = new ListDescriptor();
        serversDescriptor.setValueDescriptors(serverDescriptors);
        ObjectDescriptor sessionDescriptor = new ObjectDescriptor(MailSessionImpl.class);
        sessionDescriptor.addInjection("mailServers", serversDescriptor);
        return sessionDescriptor;
    }

    public static PatternDescriptor parsePattern(Element element, Parse parse, Parser parser) {
        Boolean canonEq;
        String canonEqAttr;
        Boolean literal;
        String regex = XmlUtil.getContentText(element);
        PatternDescriptor patternDescriptor = new PatternDescriptor(regex);
        String literalAttr = XmlUtil.attribute(element, "literal");
        if (literalAttr != null && (literal = XmlUtil.parseBooleanValue(literalAttr)) != null) {
            patternDescriptor.setLiteral(literal);
        }
        if ((canonEqAttr = XmlUtil.attribute(element, "canonEq")) != null && (canonEq = XmlUtil.parseBooleanValue(canonEqAttr)) != null) {
            patternDescriptor.setCanonEq(canonEq);
        }
        return patternDescriptor;
    }
}

