/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.AnnotationInfo;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.core.SourceRange;
import org.eclipse.jdt.internal.core.SourceRefElement;

public class Annotation
extends SourceRefElement
implements IAnnotation {
    public static final IAnnotation[] NO_ANNOTATIONS = new IAnnotation[0];
    public static final IMemberValuePair[] NO_MEMBER_VALUE_PAIRS = new IMemberValuePair[0];
    protected String name;

    public Annotation(JavaElement parent, String name) {
        super(parent);
        this.name = name;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Annotation)) {
            return false;
        }
        return super.equals(o);
    }

    public IMember getDeclaringMember() {
        return (IMember)this.getParent();
    }

    public String getElementName() {
        return this.name;
    }

    public int getElementType() {
        return 16;
    }

    protected char getHandleMementoDelimiter() {
        return '}';
    }

    public IMemberValuePair[] getMemberValuePairs() throws JavaModelException {
        AnnotationInfo info = (AnnotationInfo)this.getElementInfo();
        return info.members;
    }

    public ISourceRange getNameRange() throws JavaModelException {
        ClassFile classFile;
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null && (classFile = (ClassFile)this.getClassFile()) != null) {
            classFile.getBuffer();
            return mapper.getNameRange(this);
        }
        AnnotationInfo info = (AnnotationInfo)this.getElementInfo();
        return new SourceRange(info.nameStart, info.nameEnd - info.nameStart + 1);
    }

    public ISourceRange getSourceRange() throws JavaModelException {
        ClassFile classFile;
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null && (classFile = (ClassFile)this.getClassFile()) != null) {
            classFile.getBuffer();
            return mapper.getSourceRange(this);
        }
        return super.getSourceRange();
    }

    public IClassFile getClassFile() {
        return ((JavaElement)this.getParent()).getClassFile();
    }

    protected void toStringName(StringBuffer buffer) {
        buffer.append('@');
        buffer.append(this.getElementName());
    }
}

