/*
 * Decompiled with CFR 0.152.
 */
package org.drools.xml.processes;

import org.drools.workflow.core.Node;
import org.drools.workflow.core.node.EndNode;
import org.drools.xml.ExtensibleXmlParser;
import org.drools.xml.processes.AbstractNodeHandler;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class EndNodeHandler
extends AbstractNodeHandler {
    protected Node createNode() {
        return new EndNode();
    }

    public void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        EndNode endNode = (EndNode)node;
        String terminate = element.getAttribute("terminate");
        if (terminate != null && "false".equals(terminate)) {
            endNode.setTerminate(false);
        }
    }

    public Class generateNodeFor() {
        return EndNode.class;
    }

    public void writeNode(Node node, StringBuilder xmlDump, boolean includeMeta) {
        EndNode endNode = (EndNode)node;
        this.writeNode("end", (Node)endNode, xmlDump, includeMeta);
        boolean terminate = endNode.isTerminate();
        if (!terminate) {
            xmlDump.append("terminate=\"false\" ");
        }
        this.endNode(xmlDump);
    }
}

