/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.itsm.problem.dao;

import com.sinba.common.dao.BaseDAOImplHibernate;
import com.sinba.common.dto.PageDTO;
import com.sinba.itsm.problem.dao.IProblemDAO;
import com.sinba.itsm.problem.dto.ProblemCountResultDTO;
import com.sinba.itsm.problem.dto.ProblemQueryDTO;
import com.sinba.itsm.problem.entity.Problems;
import java.util.Date;
import java.util.GregorianCalendar;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemDAO
extends BaseDAOImplHibernate<Problems>
implements IProblemDAO {
    @Override
    public String dayProblemCoun() {
        java.sql.Date date = new java.sql.Date(new Date().getTime());
        String hql = " from Problems ch where ch.createdOn like '" + date + "%'";
        Integer count = this.getHibernateTemplate().find(hql).size() + 1;
        String counts = String.format("%03d", count);
        return counts;
    }

    @Override
    public PageDTO findProblemPager(ProblemQueryDTO qdto) {
        DetachedCriteria dc = DetachedCriteria.forClass(Problems.class);
        int start = 0;
        int limit = 0;
        if (qdto != null) {
            GregorianCalendar endTimeCl;
            start = qdto.getStart();
            limit = qdto.getLimit();
            if (StringUtils.hasText((String)qdto.getProblemNo())) {
                dc.add((Criterion)Restrictions.like((String)"problemNo", (String)qdto.getProblemNo(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (qdto.getCategoryNos() != null && qdto.getCategoryNos().length > 0) {
                dc.createAlias("category", "rc").add(Restrictions.in((String)"rc.eventId", (Object[])qdto.getCategoryNos()));
            }
            if (StringUtils.hasText((String)qdto.getEtitle())) {
                dc.add((Criterion)Restrictions.like((String)"etitle", (String)qdto.getEtitle(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (qdto.getStatusNo() != null && qdto.getStatusNo() != 0L) {
                dc.createAlias("status", "st").add((Criterion)Restrictions.eq((String)"st.dcode", (Object)qdto.getStatusNo()));
            }
            if (qdto.getStartTime() != null && qdto.getEndTime() == null) {
                dc.add((Criterion)Restrictions.ge((String)"createdOn", (Object)qdto.getStartTime()));
            }
            if (qdto.getStartTime() == null && qdto.getEndTime() != null) {
                endTimeCl = new GregorianCalendar();
                endTimeCl.setTime(qdto.getEndTime());
                endTimeCl.set(5, endTimeCl.get(5) + 1);
                dc.add((Criterion)Restrictions.le((String)"createdOn", (Object)endTimeCl.getTime()));
            }
            if (qdto.getStartTime() != null && qdto.getEndTime() != null) {
                endTimeCl = new GregorianCalendar();
                endTimeCl.setTime(qdto.getEndTime());
                endTimeCl.set(5, endTimeCl.get(5) + 1);
                dc.add((Criterion)Restrictions.and((Criterion)Restrictions.le((String)"createdOn", (Object)endTimeCl.getTime()), (Criterion)Restrictions.ge((String)"createdOn", (Object)qdto.getStartTime())));
            }
            if (qdto.getCountQueryType() != null && !qdto.getCountQueryType().equals("")) {
                if (qdto.getCountQueryType().equals("myProposedProblem") && qdto.getCurrentUser() != null) {
                    dc.createAlias("createdBy", "cb").add((Criterion)Restrictions.eq((String)"cb.loginName", (Object)qdto.getCurrentUser()));
                }
                if (qdto.getCountQueryType().equals("assigneeToMyProblem") && qdto.getCurrentUser() != null && !qdto.getCurrentUser().equals("")) {
                    dc.createAlias("technician", "tc").add((Criterion)Restrictions.eq((String)"tc.loginName", (Object)qdto.getCurrentUser()));
                }
                if (qdto.getCountQueryType().equals("assigneeGroupProblem") && qdto.getOrgNo() != null && qdto.getOrgNo() != 0L) {
                    dc.createAlias("assigneeGroup", "ag").add((Criterion)Restrictions.eq((String)"ag.orgNo", (Object)qdto.getOrgNo()));
                }
            }
            if (StringUtils.hasText((String)qdto.getSidx()) && StringUtils.hasText((String)qdto.getSord())) {
                if ("desc".equals(qdto.getSord())) {
                    dc.addOrder(Order.desc((String)qdto.getSidx()));
                } else {
                    dc.addOrder(Order.asc((String)qdto.getSidx()));
                }
            }
        } else {
            dc.addOrder(Order.desc((String)"eno"));
        }
        return super.findPageByCriteria(dc, start, limit);
    }

    @Override
    public ProblemCountResultDTO countProblem(ProblemQueryDTO qdto) {
        ProblemCountResultDTO pcrDto = new ProblemCountResultDTO();
        String hql = "from Problems p where p.dataFlag not in(99)";
        pcrDto.setCountAllProblem(super.getHibernateTemplate().find(hql).size());
        hql = "from Problems p where p.dataFlag not in(99) and p.createdBy.loginName=?";
        pcrDto.setCountMyProblem(super.getHibernateTemplate().find(hql, (Object)qdto.getUserName()).size());
        hql = "from Problems p where p.dataFlag not in(99) and p.technician.loginName=?";
        pcrDto.setCountMyPeProblem(super.getHibernateTemplate().find(hql, (Object)qdto.getUserName()).size());
        hql = "from Problems p where p.dataFlag not in(99) and p.assigneeGroup.orgNo=?";
        pcrDto.setCountMyGrProblem(super.getHibernateTemplate().find(hql, (Object)qdto.getOrgNo()).size());
        return pcrDto;
    }
}

