/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.itsm.problem.service;

import com.opensymphony.xwork2.ActionContext;
import com.sinba.common.compass.dto.CompassQueryDTO;
import com.sinba.common.compass.service.ICompassSearchService;
import com.sinba.common.config.attachment.entity.Attachment;
import com.sinba.common.config.attachment.service.IAttachmentService;
import com.sinba.common.config.category.dao.IEventCategoryDAO;
import com.sinba.common.config.category.entity.EventCategory;
import com.sinba.common.config.comment.dao.ICommentDAO;
import com.sinba.common.config.comment.entity.Comment;
import com.sinba.common.config.dictionary.dao.IDataDictionaryItemsDAO;
import com.sinba.common.config.dictionary.entity.DataDictionaryItems;
import com.sinba.common.dto.PageDTO;
import com.sinba.common.exception.ApplicationException;
import com.sinba.common.helpdeskCommon.dto.RelatedRequestGridDTO;
import com.sinba.common.jbpm.JbpmFacade;
import com.sinba.common.security.dao.IOrganizationDAO;
import com.sinba.common.security.dao.IUserDAO;
import com.sinba.common.security.entity.Organization;
import com.sinba.common.security.entity.User;
import com.sinba.common.tools.dto.HistoryRecordDTO;
import com.sinba.common.tools.service.IHistoryRecordService;
import com.sinba.itsm.cim.dao.ICIDAO;
import com.sinba.itsm.cim.dto.CIGridDTO;
import com.sinba.itsm.cim.entity.CI;
import com.sinba.itsm.config.serviceDirectory.dao.IServiceDirectoryDAO;
import com.sinba.itsm.config.serviceDirectory.dto.ServiceDirectoryGridDTO;
import com.sinba.itsm.config.serviceDirectory.entity.ServiceDirectory;
import com.sinba.itsm.knowledge.dao.IKnowledgeDAO;
import com.sinba.itsm.knowledge.dto.KnowledgeDTO;
import com.sinba.itsm.knowledge.entity.KnowledgeInfo;
import com.sinba.itsm.problem.dao.IProblemDAO;
import com.sinba.itsm.problem.dto.CommentDTO;
import com.sinba.itsm.problem.dto.ProblemActionDTO;
import com.sinba.itsm.problem.dto.ProblemCountResultDTO;
import com.sinba.itsm.problem.dto.ProblemDTO;
import com.sinba.itsm.problem.dto.ProblemDetailsDTO;
import com.sinba.itsm.problem.dto.ProblemGridDTO;
import com.sinba.itsm.problem.dto.ProblemQueryDTO;
import com.sinba.itsm.problem.entity.Problems;
import com.sinba.itsm.problem.service.IProblemService;
import com.sinba.itsm.request.dao.IRequestDAO;
import com.sinba.itsm.request.entity.Request;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.compass.core.CompassHit;
import org.compass.core.support.search.CompassSearchResults;
import org.compass.core.util.StringUtils;
import org.jbpm.api.ProcessInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemService
implements IProblemService {
    @Autowired
    private IUserDAO userDAO;
    @Autowired
    private IDataDictionaryItemsDAO dataDictionaryItemsDAO;
    @Autowired
    private IEventCategoryDAO categoryDAO;
    @Autowired
    private ICIDAO ciDAO;
    @Autowired
    private IServiceDirectoryDAO serviceDirectoryDAO;
    @Autowired
    private IHistoryRecordService historyRecordService;
    @Autowired
    private IProblemDAO problemDAO;
    @Autowired
    private ICommentDAO commentDAO;
    @Autowired
    private IAttachmentService attachmentService;
    @Autowired
    private IOrganizationDAO organizationDAO;
    @Autowired
    private IRequestDAO requestDAO;
    @Autowired
    private JbpmFacade jbpmFacade;
    @Autowired
    private IKnowledgeDAO knowledgeDAO;
    @Autowired
    private ICompassSearchService compassSearchService;
    @Autowired
    private IEventCategoryDAO eventCategoryDAO;

    public void findEventCategorys(Long eventId, List<Long> longList) {
        EventCategory eventCategory = (EventCategory)this.eventCategoryDAO.findById((Serializable)eventId);
        longList.add(eventCategory.getEventId());
        if (eventCategory != null && eventCategory.getParentChildren() != null && eventCategory.getParentChildren().size() > 0) {
            for (EventCategory c : eventCategory.getParentChildren()) {
                longList.add(c.getEventId());
                this.findEventCategorys(c.getEventId(), longList);
            }
        }
    }

    @Override
    @Transactional
    public PageDTO findProblemPager(ProblemQueryDTO qdto) {
        if (qdto.getCategoryNo() != null) {
            ArrayList<Long> longList = new ArrayList<Long>();
            this.findEventCategorys(qdto.getCategoryNo(), longList);
            Long[] cnos = new Long[longList.size()];
            for (int i = 0; i < longList.size(); ++i) {
                cnos[i] = (Long)longList.get(i);
            }
            qdto.setCategoryNos(cnos);
        }
        if (qdto.getCurrentUser() != null && !qdto.getCurrentUser().equals("")) {
            User user = (User)this.userDAO.findUniqueBy("loginName", (Object)qdto.getCurrentUser());
            qdto.setOrgNo(user.getOrgnization().getOrgNo());
        }
        PageDTO pageDTO = this.problemDAO.findProblemPager(qdto);
        List entities = pageDTO.getData();
        ArrayList<ProblemGridDTO> dtos = new ArrayList<ProblemGridDTO>();
        for (Problems entity : entities) {
            ProblemGridDTO dto = new ProblemGridDTO();
            ProblemGridDTO.entity2dto(entity, dto);
            dtos.add(dto);
        }
        pageDTO.setData(dtos);
        return pageDTO;
    }

    @Override
    @Transactional
    public Long saveProblem(ProblemDTO dto) {
        Problems problem = new Problems();
        ProblemDTO.dto2entity((Object)((Object)dto), (Object)((Object)problem));
        this.dto2entity(dto, problem);
        problem.setStatus((DataDictionaryItems)this.dataDictionaryItemsDAO.findUniqueBy("dno", (Object)"problem_analyze"));
        this.problemDAO.save((Object)problem);
        this.saveHistoryRecord(problem.getEno(), "Problem Created", "Problem Created");
        try {
            HashMap<String, ProblemDTO> variables = new HashMap<String, ProblemDTO>();
            variables.put("dto", new ProblemDTO());
            String pid = this.jbpmFacade.startProcessAndNext("Problem", variables);
            if (pid != null) {
                problem.setPid(pid);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return problem.getEno();
    }

    @Transactional
    public void saveHistoryRecord(Long eno, String logTitle, String details) {
        HistoryRecordDTO historyRecordDto = new HistoryRecordDTO();
        historyRecordDto.setEno(eno);
        historyRecordDto.setEventType("itsm.problem");
        historyRecordDto.setCreatedTime(new Date());
        historyRecordDto.setLogTitle(logTitle);
        historyRecordDto.setLogDetails(details);
        if (ActionContext.getContext() != null) {
            String loginUser = (String)ActionContext.getContext().getSession().get("SPRING_SECURITY_LAST_USERNAME");
            historyRecordDto.setOperator(loginUser);
        }
        this.historyRecordService.saveHistoryRecord(historyRecordDto);
    }

    @Override
    @Transactional
    public void problemBaseInfoEdit(ProblemDTO dto) {
        Problems problem = (Problems)((Object)this.problemDAO.findById(dto.getEno()));
        String pid = problem.getPid();
        ProblemDTO.dto2entity((Object)((Object)dto), (Object)((Object)problem));
        this.dto2entity(dto, problem);
        problem.setPid(pid);
        this.problemDAO.update((Object)problem);
        this.saveHistoryRecord(problem.getEno(), "Problem Edit", "");
    }

    public void dto2entity(ProblemDTO dto, Problems problem) {
        if (problem != null) {
            if (dto.getProblemNo() == null) {
                problem.setProblemNo("PB-" + new SimpleDateFormat("yyyyMMdd").format(new Date()) + this.problemDAO.dayProblemCoun());
            }
            problem.setCreatedOn(new Date());
            if (StringUtils.hasText((String)dto.getCreatedByName())) {
                problem.setCreatedBy((User)this.userDAO.findUniqueBy("loginName", (Object)dto.getCreatedByName()));
            } else if (ActionContext.getContext() != null) {
                String loginUser = (String)ActionContext.getContext().getSession().get("SPRING_SECURITY_LAST_USERNAME");
                problem.setCreatedBy((User)this.userDAO.findUniqueBy("loginName", (Object)loginUser));
            }
            if (StringUtils.hasText((String)dto.getAssignName())) {
                problem.setTechnician((User)this.userDAO.findUniqueBy("loginName", (Object)dto.getAssignName()));
            }
            if (StringUtils.hasText((String)dto.getAssigneeGroupName())) {
                problem.setAssigneeGroup((Organization)this.organizationDAO.findUniqueBy("orgName", (Object)dto.getAssigneeGroupName()));
            }
            if (dto.getEffectRangeNo() != null) {
                problem.setEffectRange((DataDictionaryItems)this.dataDictionaryItemsDAO.findById((Serializable)dto.getEffectRangeNo()));
            }
            if (dto.getPriorityNo() != null) {
                problem.setPriority((DataDictionaryItems)this.dataDictionaryItemsDAO.findById((Serializable)dto.getPriorityNo()));
            }
            if (dto.getSeriousnessNo() != null) {
                problem.setSeriousness((DataDictionaryItems)this.dataDictionaryItemsDAO.findById((Serializable)dto.getSeriousnessNo()));
            }
            if (dto.getStatusNo() != null) {
                problem.setStatus((DataDictionaryItems)this.dataDictionaryItemsDAO.findById((Serializable)dto.getStatusNo()));
            }
            if (dto.getCategoryNo() != null) {
                problem.setCategory((EventCategory)this.categoryDAO.findById((Serializable)dto.getCategoryNo()));
            }
            if (StringUtils.hasText((String)dto.getAttachmentsStr())) {
                if (problem.getRelatedAttachments() != null && problem.getRelatedAttachments().size() > 0) {
                    problem.getRelatedAttachments().addAll(this.attachmentService.saveAttachment(dto.getAttachmentsStr()));
                } else {
                    problem.setRelatedAttachments(this.attachmentService.saveAttachment(dto.getAttachmentsStr()));
                }
            }
            if (dto.getRelatedConfigureItemNos() != null) {
                ArrayList<CI> cis = new ArrayList<CI>();
                for (Long id : dto.getRelatedConfigureItemNos()) {
                    cis.add((CI)this.ciDAO.findById((Serializable)id));
                }
                problem.setRelatedConfigureItems(cis);
            }
            if (dto.getServiceDirectoryNos() != null) {
                ArrayList<ServiceDirectory> sds = new ArrayList<ServiceDirectory>();
                for (Long id : dto.getServiceDirectoryNos()) {
                    sds.add((ServiceDirectory)this.serviceDirectoryDAO.findById((Serializable)id));
                }
                problem.setEffectServiceDirectory(sds);
            }
            if (dto.getEnos() != null && dto.getEnos().length > 0) {
                ArrayList<Request> reqlist = new ArrayList<Request>();
                for (Long eno : dto.getEnos()) {
                    reqlist.add((Request)this.requestDAO.findById((Serializable)eno));
                }
                problem.setRelatedRequests(reqlist);
            }
        }
    }

    @Override
    @Transactional
    public ProblemDTO findProblemById(Long eno) {
        Problems problem = (Problems)((Object)this.problemDAO.findById(eno));
        ProblemDTO dto = new ProblemDTO();
        this.entity2dto(problem, dto);
        return dto;
    }

    @Override
    @Transactional
    public ProblemDetailsDTO findProblemInfo(Long eno) {
        Problems problem = (Problems)((Object)this.problemDAO.findById(eno));
        ProblemDetailsDTO dto = new ProblemDetailsDTO();
        ProblemDetailsDTO.entity2dto((Object)((Object)problem), (Object)((Object)dto));
        this.entity2dto(problem, dto);
        return dto;
    }

    public void entity2dto(Problems entity, ProblemDTO dto) {
        CommentDTO cmdto;
        dto.setEno(entity.getEno());
        dto.setEtitle(entity.getEtitle());
        dto.setEdesc(entity.getEdesc());
        dto.setOverdueTime(entity.getOverdueTime());
        dto.setSolutions(entity.getSolutions());
        dto.setAlternatives(entity.getAlternatives());
        dto.setPid(entity.getPid());
        if (entity.getCategory() != null) {
            dto.setCategoryName(entity.getCategory().getEventName());
        }
        if (entity.getStatus() != null) {
            dto.setStatusName(entity.getStatus().getDname());
            dto.setStatusCode(entity.getStatus().getDno());
        }
        if (entity.getPriority() != null) {
            dto.setPriorityName(entity.getPriority().getDname());
        }
        if (entity.getEffectRange() != null) {
            dto.setEffectRangeName(entity.getEffectRange().getDname());
        }
        if (entity.getSeriousness() != null) {
            dto.setSeriousnessName(entity.getSeriousness().getDname());
        }
        if (entity.getAssigneeGroup() != null) {
            dto.setAssigneeGroupName(entity.getAssigneeGroup().getOrgName());
        }
        if (entity.getTechnician() != null) {
            dto.setAssignName(entity.getTechnician().getLoginName());
        }
        if (entity.getRelatedAttachments() != null && entity.getRelatedAttachments().size() > 0) {
            dto.setAttachments(entity.getRelatedAttachments());
        }
        if (entity.getEffectServiceDirectory() != null && entity.getEffectServiceDirectory().size() > 0) {
            ArrayList<String> sdList = new ArrayList<String>();
            for (ServiceDirectory sd : entity.getEffectServiceDirectory()) {
                sdList.add(sd.getServiceDirectoryName());
            }
            dto.setServiceDirectoryNames(sdList);
        }
        if (entity.getRelatedConfigureItems() != null && entity.getRelatedConfigureItems().size() > 0) {
            ArrayList<CIGridDTO> relatedCIS = new ArrayList<CIGridDTO>();
            for (CI ci : entity.getRelatedConfigureItems()) {
                CIGridDTO cidto = new CIGridDTO();
                cidto.setCiId(ci.getCiId());
                cidto.setCino(ci.getCino());
                cidto.setCiname(ci.getCiname());
                if (ci.getCategory() != null) {
                    cidto.setCategory(ci.getCategory().getCname());
                }
                if (ci.getStatus() != null) {
                    cidto.setStatus(ci.getStatus().getDname());
                }
                relatedCIS.add(cidto);
            }
            dto.setRelatedCIS(relatedCIS);
        }
        if (entity.getEffects() != null) {
            cmdto = new CommentDTO();
            cmdto.setRemark(entity.getEffects().getRemark());
            if (entity.getEffects().getAttachments() != null && entity.getEffects().getAttachments().size() > 0) {
                cmdto.setAttachments(entity.getEffects().getAttachments());
            }
            dto.setEffects(cmdto);
        }
        if (entity.getSymptom() != null) {
            cmdto = new CommentDTO();
            cmdto.setRemark(entity.getSymptom().getRemark());
            if (entity.getSymptom().getAttachments() != null && entity.getSymptom().getAttachments().size() > 0) {
                cmdto.setAttachments(entity.getSymptom().getAttachments());
            }
            dto.setSymptom(cmdto);
        }
        if (entity.getRootCauses() != null) {
            cmdto = new CommentDTO();
            cmdto.setRemark(entity.getRootCauses().getRemark());
            if (entity.getRootCauses().getAttachments() != null && entity.getRootCauses().getAttachments().size() > 0) {
                cmdto.setAttachments(entity.getRootCauses().getAttachments());
            }
            dto.setRootCauses(cmdto);
        }
        if (entity.getProblemSolution() != null) {
            KnowledgeDTO kdto = new KnowledgeDTO();
            kdto.setTitle(entity.getProblemSolution().getTitle());
            if (entity.getProblemSolution().getAttachements() != null) {
                ArrayList attrs = new ArrayList();
                attrs.addAll(entity.getProblemSolution().getAttachements());
                kdto.setAttachments(attrs);
            }
            kdto.setContent(entity.getProblemSolution().getContent());
            dto.setProblemSolutionDTO(kdto);
        }
    }

    public void entity2dto(Problems problem, ProblemDetailsDTO problemDto) {
        if (problem.getTechnician() != null) {
            problemDto.setAssignNo(problem.getTechnician().getUserId());
            problemDto.setAssignName(problem.getTechnician().getLoginName());
        }
        if (problem.getAssigneeGroup() != null) {
            problemDto.setAssigneeGroupNo(problem.getAssigneeGroup().getOrgNo());
            problemDto.setAssigneeGroupName(problem.getAssigneeGroup().getOrgName());
        }
        if (problem.getEffectRange() != null) {
            problemDto.setEffectRangeNo(problem.getEffectRange().getDcode());
            problemDto.setEffectRangeName(problem.getEffectRange().getDname());
        }
        if (problem.getPriority() != null) {
            problemDto.setPriorityNo(problem.getPriority().getDcode());
            problemDto.setPriorityName(problem.getPriority().getDname());
        }
        if (problem.getSeriousness() != null) {
            problemDto.setSeriousnessNo(problem.getSeriousness().getDcode());
            problemDto.setSeriousnessName(problem.getSeriousness().getDname());
        }
        if (problem.getStatus() != null) {
            problemDto.setStatusNo(problem.getStatus().getDcode());
            problemDto.setStatusName(problem.getStatus().getDname());
            problemDto.setStatusCode(problem.getStatus().getDno());
        }
        if (problem.getCategory() != null) {
            problemDto.setCategoryNo(problem.getCategory().getEventId());
            problemDto.setCategoryName(problem.getCategory().getEventName());
        }
        if (problem.getRelatedAttachments() != null && problem.getRelatedAttachments().size() > 0) {
            problemDto.setAttachments(problem.getRelatedAttachments());
        }
        if (problem.getRelatedConfigureItems() != null) {
            ArrayList<CIGridDTO> cis = new ArrayList<CIGridDTO>();
            for (CI cI : problem.getRelatedConfigureItems()) {
                CIGridDTO cigDto = new CIGridDTO();
                cigDto.setCiId(cI.getCiId());
                cigDto.setCino(cI.getCino());
                cigDto.setCiname(cI.getCiname());
                if (cI.getStatus() != null) {
                    cigDto.setStatus(cI.getStatus().getDname());
                }
                if (cI.getCategory() != null) {
                    cigDto.setCategory(cI.getCategory().getCname());
                }
                cis.add(cigDto);
            }
            problemDto.setCigDTO(cis);
        }
        if (problem.getEffectServiceDirectory() != null) {
            ArrayList<ServiceDirectoryGridDTO> sdgs = new ArrayList<ServiceDirectoryGridDTO>();
            for (ServiceDirectory serviceDirectory : problem.getEffectServiceDirectory()) {
                ServiceDirectoryGridDTO sdgDto = new ServiceDirectoryGridDTO();
                sdgDto.setServiceDirectoryId(serviceDirectory.getServiceDirectoryId());
                sdgDto.setServiceDirectoryName(serviceDirectory.getServiceDirectoryName());
                sdgDto.setServiceDirectoryDesc(serviceDirectory.getDescription());
                sdgs.add(sdgDto);
            }
            problemDto.setSdgDTO(sdgs);
        }
    }

    @Override
    @Transactional
    public void problemAssign(ProblemActionDTO dto) {
        if (dto != null && dto.getEno() != null) {
            Problems problem = (Problems)((Object)this.problemDAO.findById(dto.getEno()));
            String str = "";
            if (dto.getTcNo() != null) {
                problem.setTechnician((User)this.userDAO.findById((Serializable)dto.getTcNo()));
                str = str + " Assign to Technician: " + ((User)this.userDAO.findById((Serializable)dto.getTcNo())).getLoginName() + "; ";
            }
            if (dto.getGroupNo() != null) {
                problem.setAssigneeGroup((Organization)this.organizationDAO.findById((Serializable)dto.getGroupNo()));
                str = str + " Assign to Group: " + ((Organization)this.organizationDAO.findById((Serializable)dto.getGroupNo())).getOrgName() + "; ";
            }
            if (dto.getRemark() != null) {
                str = str + "Rmark: " + dto.getRemark();
            }
            this.problemDAO.update((Object)problem);
            this.saveHistoryRecord(problem.getEno(), "Assign Problem ", str);
        }
    }

    @Override
    @Transactional
    public void deleteAttachment(Long pno, Long aid, String flag) {
        Problems problem = (Problems)((Object)this.problemDAO.findById(pno));
        Attachment attr = this.attachmentService.findAttachmentById(aid);
        if ("symptom".equals(flag)) {
            problem.getSymptom().getAttachments().remove(attr);
        }
        if ("effect".equals(flag)) {
            problem.getEffects().getAttachments().remove(attr);
        }
        if ("rootCauses".equals(flag)) {
            problem.getRootCauses().getAttachments().remove(attr);
        }
        if ("problem".equals(flag)) {
            problem.getRelatedAttachments().remove(attr);
        }
        if ("solutions".equals(flag)) {
            problem.getProblemSolution().getAttachements().remove(attr);
        }
        this.problemDAO.save((Object)problem);
    }

    @Override
    @Transactional
    public void saveSymptom(CommentDTO commentDTO) {
        Problems problem = (Problems)((Object)this.problemDAO.findById(commentDTO.getEno()));
        Comment comment = null;
        if (problem.getSymptom() != null) {
            comment = problem.getSymptom();
            comment.getAttachments().addAll(this.attachmentService.saveAttachment(commentDTO.getAttachmentStr()));
        } else {
            comment = new Comment();
            comment.setAttachments(this.attachmentService.saveAttachment(commentDTO.getAttachmentStr()));
        }
        comment.setRemark(commentDTO.getRemark());
        problem.setSymptom((Comment)this.commentDAO.merge((Object)comment));
        this.problemDAO.merge((Object)problem);
        this.saveHistoryRecord(problem.getEno(), "Save Symptom Comment", "Save Symptom Comment");
    }

    @Override
    @Transactional
    public void saveEffects(CommentDTO commentDTO) {
        Problems problem = (Problems)((Object)this.problemDAO.findById(commentDTO.getEno()));
        Comment comment = null;
        if (problem.getEffects() != null) {
            comment = problem.getEffects();
            comment.getAttachments().addAll(this.attachmentService.saveAttachment(commentDTO.getAttachmentStr()));
        } else {
            comment = new Comment();
            comment.setAttachments(this.attachmentService.saveAttachment(commentDTO.getAttachmentStr()));
        }
        comment.setRemark(commentDTO.getRemark());
        problem.setEffects((Comment)this.commentDAO.merge((Object)comment));
        this.problemDAO.merge((Object)problem);
        this.saveHistoryRecord(problem.getEno(), "Save Effects Comment", "Save Effects Comment");
    }

    @Override
    @Transactional
    public void saveRootCauses(CommentDTO commentDTO) {
        Problems problem = (Problems)((Object)this.problemDAO.findById(commentDTO.getEno()));
        Comment comment = null;
        if (problem.getRootCauses() != null) {
            comment = problem.getRootCauses();
            comment.getAttachments().addAll(this.attachmentService.saveAttachment(commentDTO.getAttachmentStr()));
        } else {
            comment = new Comment();
            comment.setAttachments(this.attachmentService.saveAttachment(commentDTO.getAttachmentStr()));
        }
        comment.setRemark(commentDTO.getRemark());
        problem.setRootCauses((Comment)this.commentDAO.merge((Object)comment));
        this.problemDAO.merge((Object)problem);
        this.saveHistoryRecord(problem.getEno(), "Save RootCauses Comment", "Save RootCauses Comment");
    }

    @Override
    @Transactional
    public void saveAlternativeSoultions(ProblemDTO dto) {
        if (dto != null && dto.getEno() != null) {
            Problems problem = (Problems)((Object)this.problemDAO.findById(dto.getEno()));
            if (StringUtils.hasText((String)dto.getAlternatives())) {
                problem.setAlternatives(dto.getAlternatives());
                this.saveHistoryRecord(problem.getEno(), "Save Alternative Comment", "Save Alternative Comment");
                this.problemDAO.merge((Object)problem);
                return;
            }
        }
    }

    @Override
    @Transactional
    public void saveProblemSolutions(KnowledgeDTO dto, Long problemNo) {
        KnowledgeInfo pk;
        Problems problem;
        if (problemNo != null) {
            problem = (Problems)((Object)this.problemDAO.findById(problemNo));
            pk = null;
            if (problem.getProblemSolution() == null) {
                pk = new KnowledgeInfo();
                pk.setCategory((EventCategory)this.categoryDAO.findUniqueBy("categoryRoot", (Object)"Knowledge"));
                pk.setAttachements(this.attachmentService.saveAttachment(dto.getAttachmentStr()));
                pk.setCreateTime(new Date());
                pk.setAddTime(new Date());
                pk.setClickRate(Long.valueOf(0L));
            } else {
                pk = problem.getProblemSolution();
                pk.getAttachements().addAll(this.attachmentService.saveAttachment(dto.getAttachmentStr()));
            }
        } else {
            throw new ApplicationException("ERROR_NULL_ID");
        }
        pk.setTitle(dto.getTitle());
        pk.setContent(dto.getContent());
        problem.setProblemSolution((KnowledgeInfo)this.knowledgeDAO.merge((Object)pk));
        this.problemDAO.merge((Object)problem);
        this.saveHistoryRecord(problem.getEno(), "Save Solution ", "Save Solution,Title : " + pk.getTitle());
    }

    @Override
    @Transactional
    public PageDTO findProblemRelatedRequest(Long eno, int page, int limit) {
        Problems problem = (Problems)((Object)this.problemDAO.findById(eno));
        PageDTO p = new PageDTO();
        if (problem.getRelatedRequests() != null && problem.getRelatedRequests().size() > 0) {
            int totalSize = problem.getRelatedRequests().size();
            int start = (page - 1) * limit;
            int end = 0;
            if (totalSize < limit) {
                end = totalSize - 1;
            } else {
                end = limit * page - 1;
                if (end > totalSize) {
                    end = totalSize - 1;
                }
            }
            ArrayList<RelatedRequestGridDTO> dtos = new ArrayList<RelatedRequestGridDTO>();
            for (int i = start; i <= end; ++i) {
                Request rq = problem.getRelatedRequests().get(i);
                RelatedRequestGridDTO dto = new RelatedRequestGridDTO();
                dto.setEno(rq.getEno());
                dto.setEtitle(rq.getEtitle());
                dto.setRequestCode(rq.getRequestCode());
                dto.setCreatedOn(rq.getCreatedOn());
                if (rq.getRequestCategory() != null) {
                    dto.setEcategoryName(rq.getRequestCategory().getEventName());
                }
                if (rq.getCreatedBy() != null) {
                    dto.setCreatedByName(rq.getCreatedBy().getLoginName());
                }
                if (rq.getAssignee() != null) {
                    dto.setAssigneeName(rq.getAssignee().getLoginName());
                }
                if (rq.getPriority() != null) {
                    dto.setPriorityName(rq.getPriority().getDname());
                }
                if (rq.getStatus() != null) {
                    dto.setStatusName(rq.getStatus().getDname());
                }
                if (rq.getSlaContract() != null) {
                    dto.setSlaState(rq.getSlaContract().getContractName());
                }
                dtos.add(dto);
            }
            p.setData(dtos);
            p.setTotalSize(totalSize);
        }
        return p;
    }

    @Override
    @Transactional
    public void addRelatedRequest(Long[] requestNos, Long eno) {
        if (eno != null && requestNos != null && requestNos.length > 0) {
            Problems problem = (Problems)((Object)this.problemDAO.findById(eno));
            List<Request> relatedRequests = problem.getRelatedRequests();
            if (relatedRequests == null) {
                relatedRequests = new ArrayList<Request>();
            }
            for (Long reno : requestNos) {
                if (relatedRequests.contains(this.requestDAO.findById((Serializable)reno))) continue;
                relatedRequests.add((Request)this.requestDAO.findById((Serializable)reno));
            }
            problem.setRelatedRequests(relatedRequests);
            this.saveHistoryRecord(problem.getEno(), "Add Related Request", "Add Related Request");
            this.problemDAO.save((Object)problem);
        }
    }

    @Override
    @Transactional
    public void removeRelatedRequest(Long[] requestNos, Long eno) {
        if (eno != null && requestNos != null && requestNos.length > 0) {
            Problems problem = (Problems)((Object)this.problemDAO.findById(eno));
            for (Long reno : requestNos) {
                problem.getRelatedRequests().remove(this.requestDAO.findById((Serializable)reno));
            }
            this.saveHistoryRecord(problem.getEno(), "Remove Related Request", "Remove Related Request");
            this.problemDAO.save((Object)problem);
        }
    }

    @Override
    @Transactional
    public void actionFlow(ProblemActionDTO dto) {
        Problems problem = (Problems)((Object)this.problemDAO.findById(dto.getEno()));
        if (dto.getActionFlag().equals("resolveProblem")) {
            this.processNext(dto.getPid(), "\u89e3\u51b3\u95ee\u9898");
            this.saveHistoryRecord(dto.getEno(), "Resolve Problem", dto.getRemark());
            problem.setStatus((DataDictionaryItems)this.dataDictionaryItemsDAO.findUniqueBy("dno", (Object)"problem_resolve"));
            this.problemDAO.save((Object)problem);
            return;
        }
        if (dto.getActionFlag().equals("submitReview")) {
            this.processNext(dto.getPid(), "\u63d0\u4ea4\u8bc4\u5ba1");
            this.saveHistoryRecord(dto.getEno(), "Submit for Assessment", dto.getRemark());
            problem.setStatus((DataDictionaryItems)this.dataDictionaryItemsDAO.findUniqueBy("dno", (Object)"problem_submitApproval"));
            this.problemDAO.save((Object)problem);
            return;
        }
        if (dto.getActionFlag().equals("reviewProblem")) {
            if ("pass".equals(dto.getReviewOpinions())) {
                this.processNext(dto.getPid(), "\u901a\u8fc7");
                this.saveHistoryRecord(dto.getEno(), "Pass", dto.getRemark());
                problem.setStatus((DataDictionaryItems)this.dataDictionaryItemsDAO.findUniqueBy("dno", (Object)"problem_approvalPass"));
                this.problemDAO.save((Object)problem);
                return;
            }
            if ("backAnalyze".equals(dto.getReviewOpinions())) {
                this.processNext(dto.getPid(), "\u9000\u56de\u5206\u6790\u95ee\u9898");
                this.saveHistoryRecord(dto.getEno(), "Back to Analyze Problem", dto.getRemark());
                problem.setStatus((DataDictionaryItems)this.dataDictionaryItemsDAO.findUniqueBy("dno", (Object)"problem_analyze"));
                this.problemDAO.save((Object)problem);
                return;
            }
            if ("backResolve".equals(dto.getReviewOpinions())) {
                this.processNext(dto.getPid(), "\u9000\u56de\u89e3\u51b3\u95ee\u9898");
                this.saveHistoryRecord(dto.getEno(), "Back to Resolve Problem", dto.getRemark());
                problem.setStatus((DataDictionaryItems)this.dataDictionaryItemsDAO.findUniqueBy("dno", (Object)"problem_resolve"));
                this.problemDAO.save((Object)problem);
                return;
            }
            return;
        }
        if (dto.getActionFlag().equals("closeProblem")) {
            this.processNext(dto.getPid(), "\u5173\u95ed");
            this.saveHistoryRecord(dto.getEno(), "Close Problem", dto.getRemark());
            problem.setStatus((DataDictionaryItems)this.dataDictionaryItemsDAO.findUniqueBy("dno", (Object)"problem_closed"));
            this.problemDAO.save((Object)problem);
            return;
        }
    }

    public void processNext(String pid, String toNext) {
        try {
            ProcessInstance pi = this.jbpmFacade.getInstanceById(pid);
            String nextActivityName = (String)this.jbpmFacade.getActivityNamesByInstance(pi).iterator().next();
            this.jbpmFacade.takeTask(pid, nextActivityName, "", toNext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @Transactional
    public void deleteProblem(Long[] ids) {
        this.problemDAO.deleteByIds(ids);
    }

    @Override
    @Transactional
    public ProblemCountResultDTO countProblem(ProblemQueryDTO query) {
        if (query.getUserName() != null) {
            User user = (User)this.userDAO.findUniqueBy("loginName", (Object)query.getUserName());
            query.setOrgNo(user.getOrgnization().getOrgNo());
        }
        ProblemCountResultDTO pcrDto = this.problemDAO.countProblem(query);
        return pcrDto;
    }

    @Override
    @Transactional
    public PageDTO fullSearch(CompassQueryDTO compassQueryDTO, int page, int rows) {
        CompassSearchResults csr = this.compassSearchService.doSearch(compassQueryDTO, page, rows);
        PageDTO problems = new PageDTO();
        problems.setTotalSize(csr.getTotalHits());
        problems.setPage(page);
        problems.setRows(rows);
        ArrayList<ProblemGridDTO> data = new ArrayList<ProblemGridDTO>();
        CompassHit[] hit = csr.getHits();
        for (int i = 0; i < hit.length; ++i) {
            Problems entity = (Problems)((Object)hit[i].data());
            Problems newProblem = (Problems)((Object)this.problemDAO.findById(entity.getEno()));
            if (newProblem == null) continue;
            ProblemGridDTO dto = new ProblemGridDTO();
            ProblemGridDTO.entity2dto(newProblem, dto);
            data.add(dto);
        }
        problems.setData(data);
        return problems;
    }
}

