/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.common.BaseNode;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.RuleBasePartitionId;
import org.drools.reteoo.AsyncCompositeLeftTupleSinkAdapter;
import org.drools.reteoo.AsyncSingleLeftTupleSinkAdapter;
import org.drools.reteoo.CompositeLeftTupleSinkAdapter;
import org.drools.reteoo.EmptyLeftTupleSinkAdapter;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSinkPropagator;
import org.drools.reteoo.SingleLeftTupleSinkAdapter;
import org.drools.spi.PropagationContext;

public abstract class LeftTupleSource
extends BaseNode
implements Externalizable {
    protected LeftTupleSinkPropagator sink;

    public LeftTupleSource() {
    }

    LeftTupleSource(int id, RuleBasePartitionId partitionId, boolean partitionsEnabled) {
        super(id, partitionId, partitionsEnabled);
        this.sink = EmptyLeftTupleSinkAdapter.getInstance();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.sink = (LeftTupleSinkPropagator)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.sink);
    }

    protected void addTupleSink(LeftTupleSink tupleSink) {
        if (this.sink instanceof EmptyLeftTupleSinkAdapter) {
            this.sink = this.partitionsEnabled && !this.partitionId.equals(tupleSink.getPartitionId()) ? new AsyncSingleLeftTupleSinkAdapter(this.getPartitionId(), tupleSink) : new SingleLeftTupleSinkAdapter(this.getPartitionId(), tupleSink);
        } else if (this.sink instanceof SingleLeftTupleSinkAdapter) {
            CompositeLeftTupleSinkAdapter sinkAdapter = this.partitionsEnabled ? new AsyncCompositeLeftTupleSinkAdapter(this.getPartitionId()) : new CompositeLeftTupleSinkAdapter(this.getPartitionId());
            sinkAdapter.addTupleSink(this.sink.getSinks()[0]);
            sinkAdapter.addTupleSink(tupleSink);
            this.sink = sinkAdapter;
        } else {
            ((CompositeLeftTupleSinkAdapter)this.sink).addTupleSink(tupleSink);
        }
    }

    protected void removeTupleSink(LeftTupleSink tupleSink) {
        if (this.sink instanceof EmptyLeftTupleSinkAdapter) {
            throw new IllegalArgumentException("Cannot remove a sink, when the list of sinks is null");
        }
        if (this.sink instanceof SingleLeftTupleSinkAdapter) {
            this.sink = EmptyLeftTupleSinkAdapter.getInstance();
        } else {
            CompositeLeftTupleSinkAdapter sinkAdapter = (CompositeLeftTupleSinkAdapter)this.sink;
            sinkAdapter.removeTupleSink(tupleSink);
            if (sinkAdapter.size() == 1) {
                this.sink = this.partitionsEnabled && !this.partitionId.equals(tupleSink.getPartitionId()) ? new AsyncSingleLeftTupleSinkAdapter(this.getPartitionId(), sinkAdapter.getSinks()[0]) : new SingleLeftTupleSinkAdapter(this.getPartitionId(), sinkAdapter.getSinks()[0]);
            }
        }
    }

    public LeftTupleSinkPropagator getSinkPropagator() {
        return this.sink;
    }

    public abstract void updateSink(LeftTupleSink var1, PropagationContext var2, InternalWorkingMemory var3);

    public boolean isInUse() {
        return this.sink.size() > 0;
    }
}

