﻿<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>   
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ include file="../language.jsp" %>

<script src="../scripts/itsm/cm/ciTree.js?random=<%=new java.util.Date().getTime()%>"></script>
<script src="../scripts/itsm/cm/configureItemInfo.js?random=<%=new java.util.Date().getTime()%>"></script>


<div  class="loading" id="configureItemInfo_loading"><img src="../images/icons/loading.gif" /></div>



<!-- 新的面板 start-->
<div id="configureItemInfo_panel" class="easyui-panel content" fit="true" border="none">
	
	<div class="easyui-layout" fit="true">
		<div region="north" border="false" class="panelTop">
			<a class="easyui-linkbutton" plain="true" icon="icon-undo" style="margin-right:10px" id="configureItemInfo_returnToList"><fmt:message key="common.returnToList" /></a>
			&nbsp;|&nbsp;
			<sec:authorize url="/pages/ci!cItemUpdate.action">
				<a class="easyui-linkbutton" plain="true" icon="icon-edit" id="configureItem_edit_but"><fmt:message key="common.edit"/></a> 
			</sec:authorize>
		</div>
		
		<div region="west" id="configureItemInfo_west" split="true" title="<fmt:message key="label.resourceInformation"/>" style="width:400px;">
		
		<form>
        <s:hidden name="ciDto.ciId" id="configureCiInfoId" ></s:hidden>
        <s:hidden name="ciDto.categoryType" id="categoryType" ></s:hidden>
        <div class="lineTableBgDiv">
     	   <table style="width:100%" class="lineTable" cellspacing="1">
            <tr>
                <td width="30%"><fmt:message key="ci.ci"/><fmt:message key="common.category"/></td>
				<td>${ciDto.categoryName}</td>
			</tr>
			<tr>	
                <td><fmt:message key="lable.ci.assetNo"/></td>
                <td>${ciDto.cino}</td>
            </tr>
            <tr>
                <td><fmt:message key="label.name"/></td>
                <td>${ciDto.ciname}</td>
            </tr>
			<tr>    
                <td><fmt:message key="ci.productType"/></td>
                <td>${ciDto.model}</td>        
            </tr>
            <tr>
                <td><fmt:message key="ci.serialNumber"/></td>
                <td>${ciDto.serialNumber}</td>
            </tr>
			<tr>    
                <td><fmt:message key="ci.barcode"/></td>
                <td>${ciDto.barcode}</td>
            </tr>
			<tr>
                <td><fmt:message key="ci.purchaseNo"/></td>
                <td>${ciDto.poNo}</td>
            </tr>
            <tr>
                <td><fmt:message key="common.status"/></td>
                <td>${ciDto.status}</td>
            </tr>
			<tr>    
                <td><fmt:message key="ci.brands"/></td>
                <td>${ciDto.brandName}</td>
            </tr>
            <tr>
                <td><fmt:message key="label.supplier"/></td>
                <td>${ciDto.providerName}</td>
            </tr>
			<tr>    
                <td><fmt:message key="ci.location"/></td>
                <td>${ciDto.loc}</td>
            </tr>
            <tr>
                <td><fmt:message key="ci.purchaseDate"/></td>
                <td><fmt:formatDate type="date" value="${ciDto.buyDate}"  pattern="yyyy-MM-dd" /></td>
            </tr>
			<tr>    
                <td><fmt:message key="ci.arrivalDate"/></td>
                <td><fmt:formatDate type="date" value="${ciDto.arrivalDate}"  pattern="yyyy-MM-dd" /></td>
            </tr>
            
			<tr>    
                <td><fmt:message key="ci.warningDate"/></td>
                <td><fmt:formatDate type="date" value="${ciDto.warningDate}"  pattern="yyyy-MM-dd" /></td>
            </tr>
            <tr>
                <td><fmt:message key="ci.lifeCycle"/></td>
                <td>
                <c:if test="${ciDto.lifeCycle!='0'}">
                	${ciDto.lifeCycle}
                </c:if>
                </td>
           	</tr>
			<tr>     
                <td><fmt:message key="ci.warrantyDate"/></td>
                <td>
                <c:if test="${ciDto.warranty!='0'}">
                	${ciDto.warranty}
                </c:if>
                </td>
            </tr>
            <tr>
                <td><fmt:message key="ci.use"/></td>
                <td>${ciDto.userName}</td>
            </tr>
			<tr>    
                <td><fmt:message key="ci.owner"/></td>
                <td>${ciDto.owner}</td>  
            </tr>
          </table>
          </div>
        </form>
		</div>
		
		
		<div region="center" id="configureItemInfo_center" title='<fmt:message key="common.detailInfo"/>' style="padding:3px">
		
			<div id="configureItemInfoTab" class="easyui-tabs" fit="true" > 	
                <div title="<fmt:message key="config.extendedInfo"/>">
               	    <s:if test="attributeList==null"><span style="color:#939090"><h3><fmt:message key="label.ciNotExtendedInfo" /></h3></span></s:if>
                	 <div class="lineTableBgDiv">
     	   				<table style="width:100%" class="lineTable" cellspacing="1">
              			<s:iterator value="attributeList" status="attrs">
              			<tr>
						    <td width="30%"><s:property value="attrAsName"/></td>
						    <td>
						    	${ciDto.attrVals[attrName]}
							</td>
					    </tr>     
						</s:iterator>
                	</table>
                	</div>
                </div>
                <div title="<fmt:message key="common.attachment"/>" style="padding:10px;">
                	<c:forEach items="${ciDto.attachments}" varStatus="i" var="attachment">
						${i.count}、<a target="_blank" href="attachment!download.action?downloadAttachmentId=${attachment.aid }">${attachment.attachmentName}</a><br/>
					</c:forEach>
					<span style="color:#939090">
					<s:if test="ciDto.attachments==null">
						<h3><fmt:message key="label.notAttachment" /></h3>
					</s:if>
					</span>
                </div>
                
                <div title="<fmt:message key="ci.relatedCI"/>" style="padding:2px; width: 100%;">
                	<div style="display: none;" id="ciRelevancaToolbar">
                	<sec:authorize url="/pages/ciRelevance!save.action">
                    	<a class="easyui-linkbutton" icon="icon-add" plain="true" onclick="javascript:itsm.cm.configureItemInfo.open_ci_relevance_win()"><fmt:message key="common.add"/></a>
                    </sec:authorize>
                    
                    <sec:authorize url="/pages/ciRelevance!delete.action">   
                        <a class="easyui-linkbutton" icon="icon-cancel"  plain="true" onclick="javascript:itsm.cm.configureItemInfo.ciRelevancetool_bar_delete_aff()" ><fmt:message key="common.delete"/></a>
                    </sec:authorize> 	
                    	<a class="easyui-linkbutton"  plain="true" style="display: none">关联关系图</a>
                    	<a class="easyui-linkbutton"  plain="true" id="ciRelevanceTree_but" onclick="itsm.cm.configureItemInfo.ciRelevanceTree()"><fmt:message key="ci.ciRelevanceTreeView" /></a>
                    </div>
                	<table id="configureItemInfoRelevanceCI" ></table>
					<div id="configureItemInfoRelevanceCIPager"></div>
                </div>
                <div title="<fmt:message key="ci.ciInfo"/>" style="padding:5px; width: 100%;" id="configInfoDiv">  
                	<form>
                	<input type="hidden" name="hardwareDTO.ciId" value="${ciDto.ciId }" />	
                	<input type="hidden" name="hardwareDTO.ciHardwareId" id="ciHardwareId" />	
                	
                	
                	<div class="lineTableBgDiv">
     	   				<table style="width:100%" class="lineTable" cellspacing="1">
                		<tr>
                			<td width="30%"><fmt:message key="config.computerName" /></td>
                			<td width="70%"><input class="input" name="hardwareDTO.computerName" id="computerName" /></td>
                		</tr>
                		<tr>
                			<td><fmt:message key="config.lastLogin" /></td>
                			<td><input class="input" name="hardwareDTO.lastLogin" id="lastLogin" /></td>
                		</tr>
                		<tr><td><fmt:message key="config.serialNumber" /></td>
                			<td><input class="input" name="hardwareDTO.serialNumber" id="serialNumber" /></td>
                		</tr>
                		<tr><td><fmt:message key="config.systemName" /></td>
                			<td><input class="input" name="hardwareDTO.systemName" id="systemName" /></td>
                		</tr>
                		<tr><td><fmt:message key="config.systemVersion" /></td>
                			<td><input class="input" name="hardwareDTO.systemVersion" id="systemVersion" /></td>
                		</tr>
                		<tr><td><fmt:message key="config.mainboard" /></td>
                			<td><input class="input" name="hardwareDTO.mainboard" id="mainboard" /></td>
                		</tr>
                		<tr><td>CPU</td>
                			<td><input class="input" name="hardwareDTO.cpu" id="cpu" /></td>
                		</tr>
                		<tr><td><fmt:message key="config.memorySize" />(MB)</td>
                			<td><input class="input" name="hardwareDTO.memorySize" id="memorySize" /></td>
                		</tr>
                		<tr><td><fmt:message key="config.hardDriveModel" /></td>
                			<td><input class="input" name="hardwareDTO.hardDriveModel" id="hardDriveModel" /></td>
                		</tr>
                		<tr><td><fmt:message key="config.hardDriveSize" />(MB)</td>
                			<td><input class="input" name="hardwareDTO.hardDriveSize" id="hardDriveSize" /></td>
                		</tr>
                		<tr><td><fmt:message key="config.cdDrive" /> </td>
                			<td><input class="input" name="hardwareDTO.cdDrive" id="cdDrive" /></td>
                		</tr>
                		<tr><td><fmt:message key="config.networkAdapter" /> </td>
                			<td><input class="input" name="hardwareDTO.networkAdapter" id="networkAdapter" /></td>
                		</tr>
                		<tr><td><fmt:message key="config.desktopMonitor" /></td>
                			<td><input class="input" name="hardwareDTO.desktopMonitor" id="desktopMonitor" /></td>
                		</tr>
                		<tr><td><fmt:message key="config.monitor" /> </td>
                			<td><input class="input" name="hardwareDTO.monitor" id="monitor" /></td>
                		</tr>
                		<tr><td><fmt:message key="label.user.description" /> </td>
                			<td><input class="input" name="hardwareDTO.networkDescription" id="networkDescription" /></td>
                		</tr>
                		<tr><td><fmt:message key="title.snmp.IPAddress" /> </td>
                			<td><input class="input" name="hardwareDTO.networkIpAddress" id="networkIpAddress" /></td>
                		</tr>
                		<tr><td>MAC </td>
                			<td><input class="input" name="hardwareDTO.networkMacAddress" id="networkMacAddress" /></td>
                		</tr>
                		<tr><td><fmt:message key="common.remark" /></td>
                			<td>
                				<textarea class="textarea" name="hardwareDTO.remark" id="config_remark"></textarea>
                			</td>
                		</tr>
                		<tr><td colspan="2" align="center">
                			<a id="save_configInfo" plain="true" class="easyui-linkbutton" icon="icon-save" plain="false" onclick="itsm.cm.getConfig.updateConfigInfo()"><fmt:message key="common.save"/></a>
                			<a class="easyui-linkbutton" plain="true" onclick="itsm.cm.getConfig.saveConfigInfo()"><fmt:message key="config.getCurrentConfig"/></a>
    				 		<span id="getConfigInfoLoad"></span>
                		</td></tr>
                	</table>
                	</div>
                	</form>
                </div>
                <div title="<fmt:message key="config.installSort"/>" style="padding:2px; width: 100%;">         
                	<table id="installSoftwareGrid"></table>
					<div id="installSoftwarePager" ></div>
                </div>
                <div title="<fmt:message key="title.historyRequest"/>" style="padding:2px; width: 100%;">         
                	<table id="historyCall"></table>
					<div id="historyCallPager" ></div>
                </div>
                <div title="<fmt:message key="title.change.historyChange"/>" style="padding:2px; width: 100%;">         
                	<table id="historyChangeGrid"></table>
					<div id="historyChangePager" ></div>
                </div>
            </div>
			
		</div>	

	</div>
	
	
	
	
	
	
	
	
	<!-- 添加配置项关联 -->
	<div id="add_ci_relevance_win" title="<fmt:message key="common.add"/><fmt:message key="ci.relatedCI"/>" class="easyui-window" icon="icon-edit" closed="true" 
	collapsible="false" minimizable="false" maximizable="false" modal="true"  style="width:300px;height:200px;">
	    <form>
	    <input type="hidden" name="ciRelevanceDTO.ciRelevanceId" id="ciRelevanceId" />
	    <table width="100%" border="0" align="center" cellspacing="5">
	     	<tr>
	            <td><fmt:message key="ci.relatedCI"/></td>
	            <td>
	            <input type="hidden" name="ciRelevanceDTO.unCiRelevanceId" id="unCiRelevanceId" />	
	            <input name="ciRelevanceDTO.unCiRelevanceName" id="unCiRelevanceName" /></td>
	        </tr>
	        <tr>
	            <td><fmt:message key="ci.relatedDescription"/></td>
	            <td>
	            <input name="ciRelevanceDTO.relevanceDesc" id="relevanceDesc" /></td>
	        </tr>
	      	<tr>
	            <td colspan="2">
		            <div style="padding-top:10px; padding-bottom:10px">
		             <a  class="easyui-linkbutton" plain="true" icon="icon-ok" id="link_add_ci_relevance_ok"><fmt:message key="common.save"/></a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
		            
		            </div>
	            </td> 
	      	</tr>
	    </table>
	    </form>
	</div>
	
	
	<!-- 选择配置项 -->
	<div id="ci_select_win" class="easyui-window"  closed="true" collapsible="false" minimizable="false" 
	    maximizable="false" modal="true" title="<fmt:message key="common.select"/><fmt:message key="ci.ci"/>" style="width:650px;height:500px;padding:5px;">
	    	<div class="easyui-layout" style="width:630px;height:400px;">
	    		<div region="west" split="true" title="<fmt:message key="ci.ci"/><fmt:message key="common.category"/>" style="width:180px;padding:10px;">
	    			<div id="ci_select_tree"></div>
	    		</div>
	    		
	    		<div region="center" title="<fmt:message key="ci.ci"/>" style="width:400px;padding:4px;">
	    			<table id="ci_select_grid"></table>
	    			<div id="ci_select_pager"></div>
	    		</div>
	    	</div>
	</div>
	
	<div id="ci_select_Toolbar" style="display:none">
		<form>
		<input id="ci_select_toolbar_search" name="ciQueryDTO.ciname" />
		<a class="easyui-linkbutton" plain="true" icon="icon-search" onclick="selectQuery('ci_select_Toolbar','ci_select_grid')"><fmt:message key="common.search"/></a>
		</form>
	</div>
	
	<!-- 关联配置项树 -->
	<div id="ci_relevance_win" title="<fmt:message key="ci.ciRelevanceTreeView" />" class="easyui-window" icon="icon-edit" closed="true" 
	collapsible="false" minimizable="false" maximizable="false" modal="true"  style="width:500px;height:400px;">
	<div id="ci_relevance_tree"></div>
	</div>

	
</div>
