<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ include file="../../language.jsp" %>

<script src="../scripts/itsm/config/cab/cabAdmin.js?random=<%=new java.util.Date().getTime()%>"></script>
<script>
itsm.config.cab.cabadmin.cabMemberList();
</script>

<div class="loading" id="cabManage_loading"><img src="../images/icons/loading.gif" /></div>

<div class="content" id="cabManage_panel">
	
	<!-- CAB列表 -->
	<table id="cabGrid"></table>
	<div id="cabPager" class="srcoll" style="text-align:center;"></div>
	
	
	
	<!-- 工具 -->
	<div id="cabGridToolbar" style="display:none">
		<sec:authorize url="/pages/cab!saveCAB.action">
		<a class="easyui-linkbutton" plain="true" icon="icon-add" id="cab_add_but"><fmt:message key="common.add"/></a>
		</sec:authorize>
		<sec:authorize url="/pages/cab!editCAB.action">
		<a class="easyui-linkbutton" plain="true" icon="icon-edit" id="cab_edit_but"><fmt:message key="common.edit"/></a>
		</sec:authorize>
		<sec:authorize url="/pages/cab!deleteCAB.action">
		<a class="easyui-linkbutton" plain="true" icon="icon-cancel" id="cab_delete_but"><fmt:message key="common.delete"/></a>
		</sec:authorize>
	</div>
	<!-- 操作项 -->
	<div id="cabActFormatterDiv" style="display: none"><sec:authorize url="/pages/cab!editCAB.action"><a href="javascript:itsm.config.cab.cabadmin.cab_edit_aff()" title="<fmt:message key="common.edit"/>"><img src="../images/icons/edit.gif" /></a></sec:authorize>&nbsp;&nbsp;<sec:authorize url="/pages/cab!deleteCAB.action"><a href="javascript:itsm.config.cab.cabadmin.cab_delete_aff()" title="<fmt:message key="common.delete"/>"><img src="../images/icons/delete.gif" /></a></sec:authorize></div>
	<!-- 添加/编辑 -->
	<div id="cabAddOrEditDiv" class="easyui-window" closed="true" collapsible="false" minimizable="false" maximizable="false" modal="true" 
	title="<fmt:message key="common.add"/>/<fmt:message key="common.edit"/>" 
	style="width:350px;height:auto">
		<form>
			<input type="hidden" name="cabDto.cabId" id="cabId" />
			<div class="lineTableBgDiv" >
       		<table style="width:100%" class="lineTable" cellspacing="1">
				<tr>
					<td><fmt:message key="label.name"/><span style="color:red">&nbsp;*</span></td>
					<td><input name="cabDto.cabName" id="cabName" class="input" /></td>
				</tr>
				<tr>
					<td><fmt:message key="label.user.description"/></td>
					<td>
					<textarea class="textarea" name="cabDto.cabDesc" id="cabDesc"></textarea></td>
				</tr>
				<tr>
					<td colspan="2">
					<a class="easyui-linkbutton" plain="false" icon="icon-add" id="cab_add_opt_but" ><fmt:message key="common.save"/></a>	
					</td>
				</tr>
			</table>
			</div>
		</form>
	</div>
	
	
	<div style="height:3px"></div>
	<!-- cabMember列表 -->
	<table id="cabMemberGrid"></table>
	<div id="cabMemberPager" class="srcoll" style="text-align:center;"></div>
	<!-- 工具 -->
	<div id="cabMemberGridToolbar" style="display:none">
		<sec:authorize url="/pages/cabMember!addCabMember.action">
		<a class="easyui-linkbutton" plain="true" icon="icon-add" id="cabMember_add_but" href="javascript:itsm.config.cab.cabadmin.openCabMemberAddOrEditWin()"><fmt:message key="common.add"/></a>
		</sec:authorize>
		<sec:authorize url="/pages/cabMember!editCabMember.action">
		<a class="easyui-linkbutton" plain="true" icon="icon-edit" id="cabMember_edit_but" href="javascript:itsm.config.cab.cabadmin.cabMember_edit_aff()"><fmt:message key="common.edit"/></a>
		</sec:authorize>
		<sec:authorize url="/pages/cabMember!deleteCABMember.action">
		<a class="easyui-linkbutton" plain="true" icon="icon-cancel" id="cabMember_delete_but" href="javascript:itsm.config.cab.cabadmin.cabMember_delete_aff()"><fmt:message key="common.delete"/></a>
		</sec:authorize>
	</div>
	
	<!-- 添加/编辑 -->
	<div id="cabMemberAddDiv" class="easyui-window" closed="true" collapsible="false" minimizable="false" maximizable="false" modal="true" 
	title="<fmt:message key="common.add"/>/<fmt:message key="common.edit"/>" 
	style="width:350px;height:auto">
		<form id="cabMemberAddForm">
			<input type="hidden" name="cabMemberDto.cabId" id="cab_cabId" value="${param.cabId}" />
			<input type="hidden" name="cabMemberDto.cabMemberId" id="cabMemberId" />
			<div class="lineTableBgDiv" >
       		<table style="width:100%" class="lineTable" cellspacing="1">
				<tr>
					<td><fmt:message key="setting.cab.approvalMember" />
					<span style="color:red">&nbsp;*</span>
					</td>
					<td>
					<input id="approvalMemberName"  class="choose" style="width:100px" readonly/>
					&nbsp;<a onclick="cleanIdValue('approvalMemberName','approvalMember')"><fmt:message key="common.cleanNull" /></a>
					<input type="hidden" name="cabMemberDto.approvalMember" id="approvalMember" /></td>
				</tr>
				<tr>
					<td><fmt:message key="setting.cab.delegateMember" /></td>
					<td>
					<input id="delegateMemberName" class="choose" style="width:100px" readonly/>
					&nbsp;<a onclick="cleanIdValue('delegateMemberName','delegateMember')"><fmt:message key="common.cleanNull" /></a>
					<input type="hidden" name="cabMemberDto.delegateMember" id="delegateMember" /></td>
				</tr>
				<tr>
					<td><fmt:message key="label.user.description"/></td>
					<td>
					<textarea class="textarea" name="cabMemberDto.desc" id="cabMemberDesc"></textarea></td>
				</tr>
				<tr>
					<td colspan="2">
					<a class="easyui-linkbutton" plain="false" icon="icon-add" id="cabMember_add_opt_but"  onclick="itsm.config.cab.cabadmin.cabMemberAddOrEditOpt()"><fmt:message key="common.save"/></a>	
					</td>
				</tr>
			</table>
			</div>
		</form>
	</div>
	
	
</div>