<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags"%>
<%@ include file="../../language.jsp" %>

<script>
var _categoryCode = '${param.categoryCode}';

if(_categoryCode=="request")
	$('#myTree').val("Request");
if(_categoryCode=="problem")
	$('#myTree').val("Problem");
if(_categoryCode=="change")
	$('#myTree').val("Change");	
if(_categoryCode=="knowledge")
	$('#myTree').val("Knowledge");
	
</script>

<script src="../scripts/itsm/config/categoryManage/eventCategory.js?random=<%=new java.util.Date().getTime()%>"></script>

<div class="loading" id="evetCategoryLoading_${param.categoryCode}" ><img src="../images/icons/loading.gif" /></div>

<div id="evetCategoryContent_${param.categoryCode}" class="easyui-panel content" fit="true" border="none" >

	<div id="${param.categoryCode}CategoryDiv" class="easyui-layout" fit="true">

		<div region="east" id="treePanel" split="true" title="<fmt:message key="title.categoryTree"/>" style="width: 200px; padding: 15px; line-height: 20px">
			<div id="eventCategoryTree" >
				<input id="myTree" name="myTree" value="<fmt:message key="setting.requestCategory"/>" />
			</div>
		</div>
		
		<div region="center" title='<fmt:message key="title.categoryManagement"/>'>
		
			<table style="width: 100%; margin:0px">
				<tr>
					<td style="width:50%">
						<!-- edit panel -->
						<div id="editEventCategoryTree" class="easyui-panel" title="<fmt:message key="common.edit"/>" collapsible="false" minimizable="false" maximizable="false" closable="false" style="width: auto; height:auto;">
							<div class="lineTableBgDiv">
								<form id="editCategoryForm_${param.categoryCode}">
									<table style="width: 100%" class="lineTable" cellspacing="1">
										<tr>
											<td><fmt:message key="label.categoryName" />
											</td>
											<td><input name="eventCategoryDto.eventName" id="eventName_${param.categoryCode}" class="easyui-validatebox input" validType="length[1,200]" required="true" /></td>
										</tr>
										<tr>
											<td><fmt:message key="label.categoryDescription" /></td>
											<td><textarea name="eventCategoryDto.eventDescription" id="eventDescription_${param.categoryCode}" class="easyui-validatebox textarea" validType="length[5,200]"></textarea>
											</td>
										</tr>

										<tr>
											<td colspan="2" style="height: 50px">
												<sec:authorize url="/pages/event!update.action">
													<input name="eventCategoryDto.eventId" id="eventId_${param.categoryCode}" type="hidden" />
													<a class="easyui-linkbutton" icon="icon-save" id="save_data_${param.categoryCode}"><fmt:message key="common.save" /></a>
												</sec:authorize>
											</td>
										</tr>
									</table>
								</form>

							</div>
						</div></td>

					<td style="width: 50%">
						<!-- add panel -->
						<div id="addEventCategoryTree" class="easyui-panel" title="<fmt:message key="common.add"/>" collapsible="false" minimizable="false" maximizable="false" closable="false"style="width: auto; height: auto;">

							<form id="addEventCategoryForm_${param.categoryCode}">
								<div class="lineTableBgDiv">
									<table style="width: 100%" class="lineTable" cellspacing="1">

										<tr>
											<td><fmt:message key="label.categoryName" /></td>
											<td><input name="eventCategoryDto.eventName" id="eventName"class="easyui-validatebox input" validType="length[1,200]" required="true" /></td>
										</tr>

										<tr>
											<td><fmt:message key="label.categoryDescription" /></td>
											<td>
												<textarea name="eventCategoryDto.eventDescription" id="eventDescription"class="easyui-validatebox textarea" validType="length[5,200]"></textarea>
											</td>
										</tr>

										<tr>
											<td colspan="2" style="height: 50px">
												<sec:authorize url="/pages/event!save.action">
													<input name="eventCategoryDto.parentEventId" id="parentEventId_${param.categoryCode}" type="hidden" />
													<a class="easyui-linkbutton" icon="icon-ok" id="save_sub_${param.categoryCode}"><fmt:message key="common.save" /></a>
												</sec:authorize>
											</td>
										</tr>
									</table>
								</div>
							</form>

						</div>
						
					</td>

				</tr>


			</table>

		</div>
	</div>

</div>
