<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ include file="../../language.jsp" %>



<script> var _groupCode = "${param.groupCode}";</script>
<script src="../scripts/itsm/config/dataDictionary/dataDictionaryGrid.js?random=<%=new java.util.Date().getTime()%>"></script>



<div class="loading" id="dataDicionaryMain_loading_${param.groupCode}">
	<img src="../images/icons/loading.gif" />
</div>

<div id="dataDicionaryMain_content_${param.groupCode}" class="content"> 


<div region="center"  >
   
	<table id="dictionaryItemGrid_${param.groupCode}"></table>
    <div id="dictionaryItemGridPager_${param.groupCode}"></div>
    <div id="dataDictionaryGridToolbar" style="display:none">
    
    
<sec:authorize url="/pages/dataDictionaryItems!save.action">
<a class="easyui-linkbutton" plain="true" icon="icon-add" onclick="itsm.config.dataDictionary.dataDictionaryGrid.addDictionaryItem()" id="dictionaryItemGrid_add"><fmt:message key="common.add"/></a>
</sec:authorize>

<sec:authorize url="/pages/dataDictionaryItems!merge.action">
	<a class="easyui-linkbutton" plain="true" icon="icon-edit" onclick="itsm.config.dataDictionary.dataDictionaryGrid.editDictionary()" id="dictionaryItemGrid_edit"><fmt:message key="common.edit"/></a> 
</sec:authorize>

<sec:authorize url="/pages/dataDictionaryItems!delete.action">
<a class="easyui-linkbutton" plain="true" icon="icon-cancel" onclick="itsm.config.dataDictionary.dataDictionaryGrid.delDictionary()" id="dictionaryItemGrid_delete"><fmt:message key="common.delete"/></a> 
</sec:authorize>

<sec:authorize url="/pages/dataDictionaryItems!find.action">
<a class="easyui-linkbutton" plain="true" icon="icon-search" onclick="itsm.config.dataDictionary.dataDictionaryGrid.openSearchWindow()" id="dictionaryItemGrid_search" ><fmt:message key="common.search"/></a>
</sec:authorize>


&nbsp;&nbsp; | <fmt:message key="label.dc.export"/>：
<select id="exportDataDc">
<option value="chooseExportType">--<fmt:message key="label.dc.chooseExportStyle"/>--</option>
<option value="view"><fmt:message key="label.dc.exportCurrentView"/></option>
</select>

&nbsp;&nbsp; | <fmt:message key="label.dc.import"/>：
<select id="importDataDc">
<option value="chooseImportType">--<fmt:message key="label.dc.chooseImportStyle"/>--</option>
<option value="excel"><fmt:message key="label.dc.importFromExcel"/></option>
</select>
    

</div>
    
    
    
    
</div>

<!-- 新增 -->
<div id="addEditDictionaryWindow_${param.groupCode}"  class="easyui-window"  closed="true" collapsible="false" minimizable="false" maximizable="false" modal="true" title="<fmt:message key="label.dc.addDc"/>" style="width:400px;height:auto">
	<form id="addDataDictionaryForm_${param.groupCode}">

	<div class="lineTableBgDiv" >
    <table  class="lineTable"  width="100%" cellspacing="1"> 
     
     <tr>
            <td>
         <fmt:message key="label.name"/>
            </td>
            <td>
            <input id="dname" name="dataDictionaryItemsDto.dname" class="easyui-validatebox" required="true" class="easyui-validatebox input" validType="length[1,200]"/>
            </td> 
      </tr>
           
        <tr>
            <td>
           <fmt:message key="label.common.desc"/>
            </td>
            <td>
            <input id="description" name="dataDictionaryItemsDto.description" class="easyui-validatebox input" validType="length[5,200]"/>
            </td>
        </tr>
         <tr>
            <td width="100px">
           <fmt:message key="common.remark"/>
            </td>
            <td>
           <textarea id="remark" name="dataDictionaryItemsDto.remark" class="easyui-validatebox textarea" validType="length[5,200]"></textarea>
            </td>
        </tr>
        
        <tr>
            <td colspan="2">
                <div style="padding-top:8px;">
                <input id="dcode" name="dataDictionaryItemsDto.dcode" type="hidden"/>
                <input type="hidden" id="groupCode" name="dataDictionaryItemsDto.groupCode" value="${param.groupCode}" />
                <a id="saveDataDictionaryBtn"  class="easyui-linkbutton" icon="icon-save"><fmt:message key="common.save"/></a>
                </div>
        </td>
        </tr>
    </table>
    </div>
    </form>
</div>

<!-- 搜索 -->
<div id="searchDataDictionaryDiv"  class="easyui-window"  closed="true" collapsible="false" minimizable="false" maximizable="false"  title="<fmt:message key="common.search"/>" style="width:380px;height:auto">
	<form>
   <div class="lineTableBgDiv" >
    <table  class="lineTable"  width="100%" cellspacing="1"> 
        <tr>
            <td width="100px">
          <fmt:message key="label.name"/>
        
            </td>
            <td>
           <input id="dataDictionaryQueryDto_dname" name="dataDictionaryQueryDto.dname" style="width:263px" />
            </td>
        </tr>
       <tr>
            <td width="100px">
           <fmt:message key="label.common.desc"/>
            </td>
            <td>
           <input id="dataDictionaryQueryDto_description" name="dataDictionaryQueryDto.description" required="true" style="width:263px" />
            </td>
        </tr>
        <tr>
            <td colspan="2">
                <div style="padding-top:8px;">
                	<input name="dataDictionaryQueryDto.groupCode" type="hidden" value="${param.groupCode}"/>
                	<a id="searchDataDictionaryBtn" class="easyui-linkbutton" icon="icon-search"><fmt:message key="common.search"/></a>
                </div>
        </td>
        </tr>
    </table>
    </div>
    </form>
</div>



<!-- 导入数据 -->
<div id="importDataWindow"  class="easyui-window" closed="true" collapsible="false" minimizable="false" maximizable="false" modal="true" title="<fmt:message key="label.dc.import"/>" style="width:400px;height:auto">
	<form>
   <div class="lineTableBgDiv" >
    <table  class="lineTable"  width="100%" cellspacing="1"> 
        <tr>
            <td width="100px">
            <fmt:message key="label.dc.filePath"/>
        
            </td>
            <td>
           	<input type="file" class="easyui-validatebox input" required="true" name="dataDictionaryQueryDto.importFile" id="importFile_${param.groupCode}" onchange="checkFileType(this,'xls')"/>
            </td>
        </tr>

        <tr>
            <td colspan="2">
                <div style="padding-top:8px;">
                	<a id="importDataDictionaryBtn" class="easyui-linkbutton" icon="icon-ok"><fmt:message key="label.dc.import"/></a>
                </div>
        </td>
        </tr>
    </table>
    </div>
    </form>
</div>


 <!-- 导出的隐藏信息 -->
    <div style="display: none;" id="exportDictionaryWindow">
	   <form action="dataDictionaryItems!export.action?dataDictionaryQueryDto.groupCode=${param.groupCode}" method="post">
	     <table>
	     <tr>
			<td>			
				<input id="exportDictionary_dname" name="dataDictionaryQueryDto.dname" class="input">
				<input id="exportDictionary_description" name="dataDictionaryQueryDto.description" class="input">
				
				<input id="exportDictionary_sidx" name="sidx" class="input">
				<input id="exportDictionary_sord" name="sord" class="input">
				<input id="exportDictionary_page" name="page" class="input">
				<input id="exportDictionary_rows" name="rows" class="input">
			</td>
		</tr>
	     </table>
	   </form>
    </div>

</div>