<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ include file="../../language.jsp" %>

<script src="../scripts/itsm/config/serviceDirectory/serviceDirectory.js?random=<%=new java.util.Date().getTime()%>"></script>
<script>itsm.config.serviceDirectory.serviceDirectoryAdmin.subServiceList();</script>
<div class="loading" id="serviceDirectoryManage_loading"><img src="../images/icons/loading.gif" /></div>

<div id="serviceDirectoryManage_panel" class="content">

	<!--服务目录列表 -->
	<table id="serviceDirectoryGrid"></table>
	<div id="serviceDirectoryPager"></div>
	
	<!-- 工具 -->
	<div id="serviceDirectoryGridToolbar" style="display:none">
		<sec:authorize url="/pages/sd!saveServiceDirectory.action">
		<a class="easyui-linkbutton" plain="true" icon="icon-add" id="serviceDirectory_add_but"><fmt:message key="common.add"/></a>
		</sec:authorize>
		<sec:authorize url="/pages/sd!editServiceDirectory.action">
		<a class="easyui-linkbutton" plain="true" icon="icon-edit" id="serviceDirectory_edit_but"><fmt:message key="common.edit"/></a>
		</sec:authorize>
		<sec:authorize url="/pages/sd!deleteServiceDirectory.action">
		<a class="easyui-linkbutton" plain="true" icon="icon-cancel" id="serviceDirectory_delete_but"><fmt:message key="common.delete"/></a>
		</sec:authorize>
	</div>
	<!-- 操作项 -->
	<div id="serviceDirectoryActFormatterDiv" style="display: none"><sec:authorize url="/pages/sd!editServiceDirectory.action"><a href="javascript:itsm.config.serviceDirectory.serviceDirectoryAdmin.sd_edit_aff()" title="<fmt:message key="common.edit"/>"><img src="../images/icons/edit.gif" /></a></sec:authorize>&nbsp;&nbsp;<sec:authorize url="/pages/sd!deleteServiceDirectory.action"><a href="javascript:itsm.config.serviceDirectory.serviceDirectoryAdmin.sd_delete_aff()" title="<fmt:message key="common.delete"/>"><img src="../images/icons/delete.gif" /></a></sec:authorize></div>
	<!-- 添加/编辑 -->
	<div id="serviceDirectoryAddOrEditDiv" class="easyui-window" closed="true" collapsible="false" minimizable="false" maximizable="false" modal="true" 
	title="<fmt:message key="common.add"/>/<fmt:message key="common.edit"/>" 
	style="width:350px;height:auto">
		<form>
			<input type="hidden" name="sdDto.serviceDirectoryId" id="serviceDirectoryId" />
			<div class="lineTableBgDiv" >
       		<table style="width:100%" class="lineTable" cellspacing="1">
				<tr>
					<td><fmt:message key="label.name"/><span style="color:red">&nbsp;*</span></td>
					<td><input name="sdDto.serviceDirectoryName" id="serviceDirectoryName" class="input"/></td>
				</tr>
				<tr>
					<td><fmt:message key="label.user.description"/></td>
					<td>
					<textarea class="textarea"  name="sdDto.serviceDirectoryDesc" id="serviceDirectoryDesc"></textarea></td>
				</tr>
				<tr>
					<td colspan="2">
					<a class="easyui-linkbutton" plain="false" icon="icon-add" id="serviceDirectory_add_opt_but" ><fmt:message key="common.save"/></a>	
					</td>
				</tr>
			</table>
			</div>
		</form>
	</div>
	
	<div style="height:3px"></div>
	
	<!-- 服务列表 -->
	<table id="subServiceGrid"></table>
	<div id="subServicePager" class="srcoll" style="text-align:center;"></div>
	
	<!-- 工具 -->
	<div id="subServiceGridToolbar" style="display:none">
		<sec:authorize url="/pages/subService!saveSubService.action">
		<a class="easyui-linkbutton" plain="true" icon="icon-add" id="subService_add_but" onclick="itsm.config.serviceDirectory.serviceDirectoryAdmin.openSubServiceAddOrEditWin()"><fmt:message key="common.add"/></a>
		</sec:authorize>
		<sec:authorize url="/pages/subService!editSubService.action">
		<a class="easyui-linkbutton" plain="true" icon="icon-edit" id="subService_edit_but" onclick="itsm.config.serviceDirectory.serviceDirectoryAdmin.subService_edit_aff()"><fmt:message key="common.edit"/></a>
		</sec:authorize>
		<sec:authorize url="/pages/subService!deleteSubService.action">
		<a class="easyui-linkbutton" plain="true" icon="icon-cancel" id="subService_delete_but" onclick="itsm.config.serviceDirectory.serviceDirectoryAdmin.subService_delete_aff()"><fmt:message key="common.delete"/></a>
		</sec:authorize>
	</div>
	
	<!-- 添加/编辑 -->
	<div id="subServiceAddDiv" class="easyui-window" closed="true" collapsible="false" minimizable="false" maximizable="false" modal="true" 
	title="<fmt:message key="common.add"/>/<fmt:message key="common.edit"/>" 
	style="width:350px;height:auto">
		<form>
			<input type="hidden" name="ssDto.serviceDirectoryId" id="subServiceId_serviceDirectoryId" value="${param.serviceDirectoryId}" />
			<input type="hidden" name="ssDto.subServiceId" id="subServiceId" />
			<div class="lineTableBgDiv" >
       		<table style="width:100%" class="lineTable" cellspacing="1">
				<tr>
					<td><fmt:message key="label.name"/><span style="color:red">&nbsp;*</span></td>
					<td><input name="ssDto.subServiceName" id="subServiceName" class="input"/></td>
				</tr>
				<tr>
					<td><fmt:message key="label.user.description"/></td>
					<td>
					<textarea class="textarea" name="ssDto.subServiceDesc" id="subServiceDesc"></textarea></td>
				</tr>
				<tr>
					<td colspan="2">
					
					<a class="easyui-linkbutton" plain="false" icon="icon-add" id="subService_add_opt_but" onclick="itsm.config.serviceDirectory.serviceDirectoryAdmin.subServiceAddOrEditOpt()"><fmt:message key="common.save"/></a>	
					</td>
				</tr>
			</table>
			</div>
		</form>
	</div>
	
	
	
	
</div>