﻿<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%
response.setHeader("Cache-Control","no-store");
response.setHeader("Pragrma","no-cache");
response.setDateHeader("Expires",0);

if(session.getAttribute("loginUserName")==null){
	response.sendRedirect( "login.jsp");
}
%> 
<fmt:setLocale value="${empty cookie['language'].value?'zh_CN':cookie['language'].value}"/>
<fmt:setBundle basename="i18n.itilbase"/>

<c:set var="lang" value="${empty cookie['language'].value?'zh_CN':cookie['language'].value}"/>
<c:set var="currentTime" value="<%=new java.util.Date().getTime()%>"/>


<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<title><fmt:message key="i18n.mainTitle"/></title>
<script>var userName="${loginUserName}";</script>

	<link rel="stylesheet" type="text/css" href="../scripts/jquery/easyui/themes/icon.css">
	<link rel="stylesheet" type="text/css" href="../scripts/jquery/easyui/themes/default/easyui.css">
	<link rel="stylesheet" type="text/css" href="../scripts/jquery/jqgrid/redmond/jquery-ui-1.8.1.custom.css" />
	<link rel="stylesheet" type="text/css" href="../scripts/jquery/jqgrid/css/jqgrid.css" /> 
    <link rel="stylesheet" type="text/css" href="../styles/style.css">
	<link rel="stylesheet" type="text/css" href="../styles/comm.css">
	<link rel="stylesheet" type="text/css" href="../scripts/jquery/easyui/datetimepicker/jquery-calendar.css"/>
	<link rel="stylesheet" type="text/css" href="../scripts/jquery/easyui/datetimepicker/styles.css"/>
	<link rel='stylesheet' type='text/css' href='../scripts/jquery/fullcalendar-1.4.3/fullcalendar.css' />
	<link rel="stylesheet" type="text/css" href="../scripts/jquery/uploadify/uploadify.css"   /> 
	<link rel="stylesheet" type="text/css" href="../styles/${lang}.css">
	<script src="../scripts/i18n/i18n_${lang}.js"></script>
	<script src="../scripts/jquery/jquery-1.4.2.min.js"></script>
	<script src="../scripts/jquery/uploadify/swfobject.js" ></script>   
	<script src="../scripts/jquery/uploadify/jquery.uploadify.v2.1.4.min.js" ></script>
	
	<script src="../scripts/jquery/jquery-ui-1.8.2.custom/js/jquery-ui-1.8.2.custom.min.js"></script>
	<script src="../scripts/jquery/easyui/jquery.easyui.min.js"></script>
	<script src="../scripts/jquery/easyui/locale/easyui-lang-${lang}.js"></script>
	<script src="../scripts/jquery/jquery.query-2.1.7.js"></script>
	<script src="../scripts/jquery/jquery-json.js"></script>

	<script src="../scripts/jquery/jqgrid/js/jqGrid.js"></script>
	<script src="../scripts/jquery/jqgrid/js/i18n/grid_locale-${lang}.js"></script>

	<script src="../scripts/jquery/jstree/js/lib/jquery.cookie.js?random=${currentTime}"></script>
	<script src="../scripts/jquery/jstree/js/lib/jquery.hotkeys.js?random=${currentTime}"></script>
	<script src="../scripts/jquery/jstree/js/jquery.jstree.js?random=${currentTime}"></script>
	<script src="../scripts/jquery/jstree/js/rewritejstree.js?random=${currentTime}"></script>
	<script src="../scripts/jquery/ajaxfileupload/ajaxfileupload.js?random=${currentTime}"></script>
	<script src="../scripts/jquery/editor/xheditor-zh-cn.min.js?v=1.1.1&random=${currentTime}"></script>
	<script src='../scripts/jquery/fullcalendar-1.4.3/fullcalendar.min.js?random=${currentTime}'></script>
	<script src="../scripts/core/import.js?random=${currentTime}"></script>
	<script src="../scripts/core/package.js?random=${currentTime}"></script>
	<script src="../scripts/core/tabUtil.js?random=${currentTime}"></script>

	<script src="../scripts/jqgrid_common.js"></script>
	<script src="../scripts/easyui_common.js"></script>
	<script src="../scripts/jquery_common.js"></script>
	<script src="../scripts/itsm/common/index.js"></script>
	<script src="../scripts/itsm/common/initEditor.js?random=${currentTime}"></script>
	<script src="../scripts/itsm/common/initUploader.js?random=${currentTime}"></script>
	<script src="../scripts/itsm/knowledge/leftHotNews.js"></script>
	
	<script src="../scripts/itsm/tools/eventTask.js?random=${currentTime}"></script>
	<script src="../scripts/itsm/tools/historyRecord.js?random=${currentTime}"></script>
	<script src="../scripts/itsm/tools/eventCost.js?random=${currentTime}"></script>
	<script src="../scripts/itsm/compass/fullSearch.js?random=${currentTime}"></script>
		
	
	
	<script>
	
		var login_userName='${loginUserName}';

		
		//窗口大小改变时
		$(window).resize(function(){
			refreshWindow();	
		});
		
		//Layoutshou，重绘UI
		$(function(){

				$('body').layout('panel','west').panel({
					
					onCollapse:function(){
						refreshWindow();
					},
					onExpand:function(){
						refreshWindow();
					}
				});
		});

		//window.onerror=function(){return true};
		
		
		var loadCategoryFlag="0";



		var clickRefreshTab=['<fmt:message key="label.request.requestState" />',
							 '<fmt:message key="label.request.form" />',
							 '<fmt:message key="label.request.priority" />',
							 '<fmt:message key="label.request.complexity" />',
							 '<fmt:message key="label.request.seriousness" />',
							 '<fmt:message key="label.request.effect" />',
							 '<fmt:message key="label.supplier" />',
							 '<fmt:message key="setting.dataDict.useStatus" />',
							 '<fmt:message key="ci.location" />',
							 '<fmt:message key="ci.brands" />',
							 '<fmt:message key="change.changeStatus" />',
							 '<fmt:message key="problem.problemStatus" />',
		             		 '<fmt:message key="setting.requestCategory" />',
		                     '<fmt:message key="setting.problemCategory" />',
		                     '<fmt:message key="change.changeCategory" />',
		                     '<fmt:message key="knowledge.knowledgeCategory" />'
			             	];


		
		window.onload=function(){

			$('#itsmMainTab').tabs({
	            onSelect:function(title){

					 $.each(clickRefreshTab,function(n,value) {   
						 
						 if(title==value && loadCategoryFlag=="0"){
							$('#itsmMainTab').tabs('getSelected').panel('refresh');
						 	loadCategoryFlag="1";
						 	setTimeout(function(){loadCategoryFlag="0";},500);
							return false;
						 }	 
				     });   
				}
			});
		
		}
		
		
	</script>


	
</head>
<body class="easyui-layout">

<!-- 顶部 -->

<div region="north" split="true" class="header" style="overflow:hidden;">

<table width="100%">
	<tr>
		<td>
		<a href="index.jsp">
	
			<img src="../images/comm/itiad.png" border="0" style="width:120;height:30px" /></a>
		</td>
		<td  valign="bottom">
			
			<table cellpadding="0" cellspacing="0">
				<tr>	
				

					<sec:authorize url="PORTAL_MAIN">
						<td valign="bottom" width="80">
							<div class="tab" id="protal_link"><fmt:message key="title.mainTab.protal"/></div>
						</td>
					</sec:authorize>
					
					<sec:authorize url="REQUEST_MAIN">
						<sec:authorize url="/pages/request!findRequests.action">
						<td valign="bottom" width="80">
							<div class="tab" id="requestTopMenu"><fmt:message key="title.mainTab.request"/></div>
						</td>
						</sec:authorize>
					</sec:authorize>
					
					<!-- 后续开发 -->
					<sec:authorize url="PROBLEM_MAIN">
						<sec:authorize url="/pages/problem!findProblemPager.action">
				
						<td valign="bottom" width="80">
							<div class="tab" id="problemTopMenu"><fmt:message key="title.mainTab.problem"/></div>
						</td>
						</sec:authorize>
					</sec:authorize>
					
					<sec:authorize url="CHANGE_MAIN">
					<td valign="bottom" width="80">
						<div class="tab" id="changeTopMenu"><fmt:message key="title.mainTab.change"/></div>
					</td>
					</sec:authorize>
					
					<sec:authorize url="KNOWLEDGEBASE_MAIN">
						<sec:authorize url="/pages/knowledgeInfo!findAllKnowledges.action">
						<td valign="bottom" width="80">
							<div class="tab" id="knowledgeTopMenu"><fmt:message key="title.mainTab.knowledgeBase"/></div>
						</td>
						</sec:authorize>
					</sec:authorize>
					
					<sec:authorize url="CONFIGITEM_MAIN">
					
						<td valign="bottom" width="80">
							<div class="tab" id="CITopMenu"><fmt:message key="title.mainTab.configItem"/></div>
						</td>
						
					</sec:authorize>
					
					<sec:authorize url="BASICSET_MAIN">
						<td valign="bottom" width="80">
							<div class="tab" id="basicSetTopMenu"><fmt:message key="title.mainTab.basicSet"/></div>
						</td>
					</sec:authorize>

					<sec:authorize url="REPORT_MAIN">
						<td valign="bottom" width="80">
							<div class="tab" id="reportTopMenu"><fmt:message key="title.mainTab.report"/></div>
						</td>
					</sec:authorize>
					
					<sec:authorize url="TOOLS_MAIN">
						<td valign="bottom" width="80">
							<div class="tab" id="toolsTopMenu"><fmt:message key="title.mainTab.tool"/></div>
						</td>
					</sec:authorize>
					
				</tr>
			</table>
		</td>
		<td align="right" valign="bottom">
			<table width="100%">
				<tr>
					<td>
					
					
							<%
							String userName=(String)session.getAttribute("loginUserName");
							String userNameShort=userName;
							if(userName!=null&& userName.length()>6){
								userNameShort=userName.substring(0,6)+"..";
							}
							%>
							
						<span class="head_user" title="<%=userName%>">
							<%=userNameShort %>[<a onclick="javascript:openTab('<fmt:message key="title.tool.im"/>','../pages/tools/im.jsp')"><span id="norederim"></span></a>]
						</span>
					</td>
					
					<td>
						<a class="head_refresh" onclick="refreshWindow()"><fmt:message key="common.refresh"/></a>
					</td>
					
					<td>
						<a onclick="logOut()" class="head_exit"><fmt:message key="common.loginOut"/></a>
					</td>
					
				</tr>
			</table>
		</td>
	</tr>
</table>

</div>

<!-- 管理员权限菜单 -->
<div region="west" id="leftMenu" split="true" title='<fmt:message key="common.mainMenu" />' style="width:235px;"></div>
	
 
 
 
<!-- 中间部分 -->
<div region="center" id="regCenter">
   <div id="itsmMainTab" class="easyui-tabs" fit="true" border="false"></div>
</div>
 
 <!-- 底部 -->
<div region="south" split="true" style="height:40px; padding:8px; text-align:center">
Business Rises on I.T.&nbsp;；&nbsp;
I.T. Rises on GuoYu ITILBase II. 
&nbsp;&nbsp;
&copy; 2009-2011 reserved by GuoYuSoft Corp, <a href="http://www.bangzhutai.com" target="_bank">www.bangzhutai.com</a> 
</div>
<!-- 底部结束 -->    



<%-- 选择关联配置项窗口（多选） --%>
<%@ include file="includes/selectCI.jsp"%>

<%-- 选择用户窗口（单选） --%>
<%@ include file="includes/selectUser.jsp"%>

<%--显示操作进程 --%>
<%@ include file="includes/process.jsp"%>

<%--数据字典静态页面 --%>
<%@ include file="includes/dataDictionatyStatic.jsp"%>

<%--Tab右键菜单 --%>
<%@ include file="includes/tabMenu.jsp"%>

<%--分类选择 --%>
<%@ include file="includes/index_Categorys.jsp"%>

<%--选择关联请求窗口 --%>
<%@ include file="includes/index_relatedRequest.jsp"%>

<%--添加编辑任务窗口 --%>
<%@ include file="includes/index_Task.jsp"%>

<%--时间及人工成本 --%>
<%@ include file="includes/index_timeCost.jsp"%>

<%-- 时间人工成本关联任务 --%>
<%@ include file="includes/index_timeCostRelatedTask.jsp"%>

<%-- 选择关联的问题 --%>
<%@ include file="includes/index_relatedProblem.jsp"%>

<%-- 导入数据窗口 --%>
<%@ include file="includes/index_importExcel.jsp"%>

<!-- 全文搜索 -->
<%@ include file="includes/index_fullSearch.jsp"%>




</body>
</html>