﻿<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<%
response.setHeader("Cache-Control","no-store");
response.setHeader("Pragrma","no-cache");
response.setDateHeader("Expires",0);

if(session.getAttribute("loginUserName")!=null){
	response.sendRedirect( "index.jsp");
}
%> 




<fmt:setLocale value="${empty cookie['language'].value?'zh_CN':cookie['language'].value}"/>
<fmt:setBundle basename="i18n.itilbase"/>
<c:set var="lang" value="${empty cookie['language'].value?'zh_CN':cookie['language'].value}"/>

<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<title>


<fmt:message key="i18n.loginTitle"/> - <fmt:message key="i18n.mainTitle"/></title>
<head>

    
    

	<script src="../scripts/i18n/i18n_${lang}.js"></script>
	<script src="../scripts/jquery/jquery-1.4.2.min.js"></script>
	<script src="../scripts/jquery/easyui/jquery.easyui.min.js"></script>
	<script src="../scripts/jquery/jquery.corner.js"></script>
	<script src="../scripts/i18n/i18n_${lang}.js"></script>
	<script src="../scripts/easyui_common.js"></script>
	
	
	
	
	<script>

	var allowLoginFlag=true;
	var contextPath="${pageContext.request.contextPath}";
	var onlineUsers="${onlineUsers}".replace('[','').replace(']','').replace(/ /g,'').split(","); 
	</script>
	
	<script src="../scripts/itsm/common/login.js"></script>

	<link rel="stylesheet" type="text/css" href="../scripts/jquery/easyui/themes/default/easyui.css">
    <link rel="stylesheet" type="text/css" href="../scripts/jquery/easyui/themes/icon.css">
    <link rel="stylesheet" type="text/css" href="../styles/style.css">
    <link rel="stylesheet" type="text/css" href="../styles/comm.css">
    <link rel="stylesheet" type="text/css" href="../styles/${lang}.css">
    

</head>

<body style="margin:0px;background-image:url(../images/comm/login-bg.jpg);background-repeat:no-repeat; background-position:top;font-size:12px;" >
 <!-- 
<div style="border-bottom:#99bbe8 1px solid;padding:5px;text-align:center;color:#000000">

<fmt:message key="label.browsersNote" /> 
<a href="http://www.bangzhutai.com" target="_blank" style="margin-left:20px"><fmt:message key="label.company.website" /></a>


<c:if test="${not empty leftUseDay and leftUseDay<65}">
&nbsp;&nbsp;&nbsp;ITILBase II Ver1.2，<span style="color:#ff0000">剩余试用天数：${leftUseDay}天</span>，获取正式版请联系我们，电话：0756-2210327 ，客服QQ：1477274212
</c:if>




</div>
-->


<!-- 使用自带的CSS创建ID为LOGIN的窗口 -->

<div id="all_login">

<div id="loginWindow" closed="true" class="easyui-window" collapsible="false" minimizable="false" maximizable="false" closable="false" title="<fmt:message key="i18n.mainTitle"/>" style="width:380px;height:auto;" >


<form id="userLogin" name="userLogin" method="POST" action="${pageContext.request.contextPath}/j_spring_security_check" style="text-align:center;margin:0px">
  <table cellspacing="5" width="96%" align="center" style="text-align:left;">
      <tr>
        <td colspan="2">
          	<img src="../images/comm/logo.png" />
          </td>
      </tr>
      
      
       <tr>
      
        <td>
        	<fmt:message key="i18n.language"/>
        </td>
        <td>
        
        	<select onchange="setLanguage(this.value)" id="languageSelect">
        		<option value="zh_CN">简体中文</option>
        		<option value="zh_TW">繁體中文</option>
        		<option value="en_US">English</option>
        	</select>
        	
        	 <script>
        	 
        	 
        	 function setLanguage(lang){
        		 
        		 setCookie('language',lang,300);
        		 location.reload();
        		 
        	 }
        	 
        	 
	           var lan="${cookie['language'].value}";
	           
	         
	           if(lan!=null && lan!=''){
	        	   
	        	   $('#languageSelect').val(lan);
	           }else{
	        	   
	        	   $('#languageSelect').val('zh_CN');
	           }
	           
           </script>

        </td>
      </tr>
      
      
      <tr>
        <td>
        	<fmt:message key="i18n.username"/>
        </td>
        <td><input name="j_username" id="j_username" class="easyui-validatebox input" validType="text" required="true" onblur="checkUserOnlie(this.value)"/></td>
      </tr>
      <tr>
        <td ><fmt:message key="i18n.password"/></td>
        <td><input type="password" name="j_password" id="j_password"  class="easyui-validatebox input" required="true"/></td>
      </tr>
      <!-- 
      <tr>
        <td><fmt:message key="label.verificationCode"/></td>
        <td>
        <input id="validateCode" name="j_validate" style="width:80px"/>&nbsp;<img id="validateCode_img" onclick="refreshCheckCode()" style="vertical-align:middle;cursor:pointer;"/>
        </td>
      </tr>
      -->
      
	  <tr>
        <td colspan="2">
         <table width="100%">
    	  <tr>
    	    <td>
    	      <input type="checkbox" name="_spring_security_remember_me" id="_spring_security_remember_me"/>
              <fmt:message key="i18n.cookieAlert"/>
            </td>
          </tr>
          </table>
        </td>
     </tr>
    </table>
</form>


<div style="border-top:#99bbe8 1px solid; border-bottom:#99bbe8 1px solid; padding:10px; background-color:#e4edfe;text-align:center; margin-left:0px; margin-right:0px;margin-bottom:8px; margin-top:8px">
	      <a onclick="checkBoforeLogin()" class="easyui-linkbutton" icon="icon-ok" style="margin-right:10px"><fmt:message key="i18n.doLogin"/></a>
   	      <a onclick="userLogin.reset()" class="easyui-linkbutton" icon="icon-undo" style="margin-right:10px"><fmt:message key="i18n.reset"/></a>
          <!--  
          <a class="easyui-linkbutton" icon="icon-roleSet" href="javascript:window.location.href='/itsm-crm/pages/register/register.jsp?language=${lang}'" target="_blank"><fmt:message key="title.register.userRegister" /></a> 
          -->
</div>

<div style="padding-bottom:5px;text-align:right;font-weight:bold;">
	<a href="note.jsp" target="_bank"><fmt:message key="label.newFeatures"/>...&nbsp;</a>
</div>


</div>


<div style="font-size:24px;font-weight:bold;text-align:center;color:#2080C0;font-family:Arial;position:absolute; bottom:0;width:100%;border-top:#99bbe8 1px solid;padding-top:3px;padding-bottom:3px">
Business Rises on IT; IT Rises on GuoYu ITILBase


<div style="font-size:12px;color:#000000;line-height:25px;font-weight:normal">
Solutions for <span style="text-decoration:underline">IT services management of in-house and outsourcing cases</span> (ITSM), <span style="text-decoration:underline">IT tickets or requests tracking</span>, 
<span style="text-decoration:underline">IT helpdesk system</span>, <span style="text-decoration:underline">ITIL processes tracking</span>, <span style="text-decoration:underline">Fixed Assets or CI management</span>, and <span style="text-decoration:underline">ITIL based CRM</span>.
</div>

</div>


<div id="autoLoginWindow" closed="true" class="easyui-window" collapsible="false" minimizable="false" maximizable="false" closable="false" title="<fmt:message key="i18n.mainTitle"/>" style="width:368px;height:auto" >

<div style="padding:25px;color:#ff0000">
系统检测到您已经登录，正在为您跳转，请稍后...
</div>

</div>



		<c:if test="${param.error == 'true'}">
      	
      	<script>
      	
      	setTimeout(function(){  
      		msgShow('<fmt:message key="err.userNameOrPassword"/>','show');		
		},500);  
      	
      	
      	setCookie('cookie_userName','',0);
		setCookie('cookie_userPassword','',0);
		
      	</script>
      	
      	</c:if>

</div>



</body>
</html>