﻿<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<%
response.setHeader("Cache-Control","no-store");
response.setHeader("Pragrma","no-cache");
response.setDateHeader("Expires",0);
%> 


<fmt:setLocale value="en_US"/>
<fmt:setBundle basename="i18n.itilbase"/>
<c:set var="lang" value="en_US"/>

<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<title><fmt:message key="i18n.loginTitle"/> - <fmt:message key="i18n.mainTitle"/></title>
<head>

	<script src="../scripts/jquery/jquery-1.4.2.min.js"></script>
	<script src="../scripts/jquery/easyui/jquery.easyui.min.js"></script>
	<script src="../scripts/jquery/jquery.corner.js"></script>
	<script src="../scripts/i18n/i18n_${lang}.js"></script>
	<script src="../scripts/easyui_common.js"></script>

	<link rel="stylesheet" type="text/css" href="../scripts/jquery/easyui/themes/default/easyui.css">
    <link rel="stylesheet" type="text/css" href="../scripts/jquery/easyui/themes/icon.css">
    <link rel="stylesheet" type="text/css" href="../styles/style.css">
    <link rel="stylesheet" type="text/css" href="../styles/${lang}.css">
    
	<script>
	
	
	setCookie('language','en_US',300);
	
	$(window).resize(function(){
		location.reload();
    });

	
	document.onkeydown = function(evt){
		var evt = window.event?window.event:evt;
		if(evt.keyCode==13)
		{
			FormCheck();
		}
	}
	
	
	function FormCheck(){	
		
		
		if($('#userLogin').form('validate')){
			
			//验证用户是否被禁用
			var uname=$('#j_username').val();
			var pwd=$('#j_password').val();
			
			
			
			var url = 'user!findDisable.action';
			
			var prarm={"userName":uname,"pwd":pwd};
			
			
			$.post(url,prarm,function(res){
				
			if(res=="exist"){
				
				msgAlert(i18n['validate_userDisableOrNorexist'],'error');
				
			}else{
		
				 var form = document.getElementById('userLogin');

				 if($("#_spring_security_remember_me").attr("checked")==true){
					
					
					setCookie('cookie_userName',uname,14);
					setCookie('cookie_userPassword',pwd,14);

				 }
				 
				
				 $.get('getCode.jsp'+'?random='+Math.random()*10+1,function(res){
					 
					 	res=res.replace(/(^\s*)|(\s*$)/g, ""); 
						var inputVerificationCode=$('#validateCode').val();
						
						if(res==inputVerificationCode){
							
							 form.submit();
							
						}else{
							msgShow(i18n['validate_error_verificationCode'],'show');
						}
				 });
				 
			}

			});
		}
	}
	
	
	//设置COOKIE
	function setCookie(c_name,value,exdays){
		
		var exdate=new Date();
		exdate.setDate(exdate.getDate() + exdays);
		var c_value=escape(value) + ((exdays==null) ? "" : "; expires="+exdate.toUTCString());
		document.cookie=c_name + "=" + c_value;
	}
	
	//取得COOKIE
	function getCookie(c_name){

	var i,x,y,ARRcookies=document.cookie.split(";");
	for (i=0;i<ARRcookies.length;i++){
		  x=ARRcookies[i].substr(0,ARRcookies[i].indexOf("="));
		  y=ARRcookies[i].substr(ARRcookies[i].indexOf("=")+1);
		  x=x.replace(/^\s+|\s+$/g,"");
		  if (x==c_name){
		    return unescape(y);
		  }
	  }
	}
	
	
	$(document).ready(function(){


		if(getCookie("cookie_userName")!=null && getCookie("cookie_userPassword")!=null){
			

			$('#autoLoginWindow').window('open');
			
			$('#j_username').val(getCookie('cookie_userName'));
			$('#j_password').val(getCookie('cookie_userPassword'));
			
			 $.get('getCode.jsp?random='+new Date(),function(res){
				 	res=res.replace(/(^\s*)|(\s*$)/g, ""); 
					$('#validateCode').val(res);
					FormCheck();
			 });
			
		}else{
			
			$('#loginWindow').window('open');
		}
	});
	
	
</script>

<script src="../scripts/i18n/i18n_${lang}.js"></script>


</head>
<body style="margin:0px;background-image:url(../images/comm/login-bg.jpg);background-repeat:no-repeat; background-position:top;font-size:12px;" >

<div style="border-bottom:#99bbe8 1px solid;padding:5px;text-align:center;color:#000000">

<fmt:message key="label.browsersNote" /> 
<a href="http://www.bangzhutai.com" target="_blank" style="margin-left:20px"><fmt:message key="label.company.website" /></a>

<!--  
<c:if test="${not empty leftUseDay and leftUseDay<65}">
&nbsp;&nbsp;&nbsp;ITILBase II Ver1.1，<span style="color:#ff0000">剩余试用天数：${leftUseDay}天</span>，获取正式版请联系我们，电话：0756-2210327 ，客服QQ：1477274212
</c:if>
-->


</div>




<!-- 使用自带的CSS创建ID为LOGIN的窗口 -->

<div id="all_login">

<div id="loginWindow" closed="true" class="easyui-window" collapsible="false" minimizable="false" maximizable="false" closable="false" title="<fmt:message key="i18n.mainTitle"/>" style="width:380px;height:auto;" >

<form id="userLogin" name="userLogin" method="POST" action="${pageContext.request.contextPath}/j_spring_security_check" style="text-align:center;margin:0px">
  <table cellspacing="5" width="90%" align="center" style="text-align:left;">
      <tr>
        <td colspan="2">
          	<img src="../images/comm/logo.png" />
          </td>
      </tr>

      <tr>
        <td>
        	<fmt:message key="i18n.username"/>
        </td>
        <td><input type="text" name="j_username" id="j_username" value="${loginUserName}"  style="width:96%" class="easyui-validatebox" validType="text" required="true"/></td>
      </tr>
      <tr>
        <td ><fmt:message key="i18n.password"/></td>
        <td><input type="password" name="j_password" id="j_password"  style="width:96%" class="easyui-validatebox" required="true"/></td>
      </tr>
      <tr>
      
      <tr>
        <td><fmt:message key="label.verificationCode"/></td>
        <td>
        <script type="text/javascript">
        
        function changeCode(){
        	
        	$("#validateCode_img").attr({"src":"${pageContext.request.contextPath}/security/captcha.jpg?random="+new Date()}); 
        }
        
        changeCode();
        
        </script>
        <input id="validateCode" name="j_validate" style="width:80px"/>&nbsp;<img id="validateCode_img" src="${pageContext.request.contextPath}/security/captcha.jpg"  onclick="changeCode()" style="vertical-align:middle;cursor:pointer;"/>
        
        </td>
      </tr>
     
	  <tr style="font-size: 12px;">

        <td colspan="2">
        
         <table width="100%">
    	  <tr>
    	    <td>
    	      <input type="checkbox" name="_spring_security_remember_me" id="_spring_security_remember_me"/>
              <fmt:message key="i18n.cookieAlert"/>
            </td>
            <td align="center">
              &nbsp;
            </td>
          </tr>
          </table>
        </td>
     </tr>
    </table>
</form>


<div style="border-top:#99bbe8 1px solid; border-bottom:#99bbe8 1px solid; padding:10px; background-color:#e4edfe;text-align:center; margin-left:0px; margin-right:0px;margin-bottom:8px; margin-top:8px">
	      <a onclick="FormCheck()" class="easyui-linkbutton" icon="icon-ok" style="margin-right:10px"><fmt:message key="i18n.doLogin"/></a>
   	      <a onclick="userLogin.reset()" class="easyui-linkbutton" icon="icon-undo" style="margin-right:10px"><fmt:message key="i18n.reset"/></a>
          <a class="easyui-linkbutton" icon="icon-roleSet" href="javascript:window.location.href='/itsm-crm/pages/register/register.jsp'"><fmt:message key="title.register.userRegister" /></a>
</div>

<div style="padding-bottom:5px;text-align:right;font-weight:bold">
	<a href="note.jsp" target="_bank"><fmt:message key="label.newFeatures"/>...&nbsp;</a>
	
	
	
	
</div>

</div>


<div id="autoLoginWindow" closed="true" class="easyui-window" collapsible="false" minimizable="false" maximizable="false" closable="false" title="<fmt:message key="i18n.mainTitle"/>" style="width:368px;height:auto" >

<div style="padding:25px;color:#ff0000">
系统检测到您已经登录，正在为您跳转，请稍后...
</div>

</div>



		<c:if test="${param.error == 'true'}">
      	
      	<script>
      	
      	setTimeout(function(){  
      		msgShow('<fmt:message key="err.userNameOrPassword"/>','show');		
		},500);  
      	
      	
      	setCookie('cookie_userName','',0);
		setCookie('cookie_userPassword','',0);
		
      	</script>
      	
      	</c:if>

</div>



</body>
</html>