<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ include file="../language.jsp" %>



<script >
var eno='${problemDTO.eno}';
var pid='${problemDTO.pid}';

var title_relatedRequest='<fmt:message key="title.historyRequest" />';
var title_problemProcess='<fmt:message key="label.problem.problemProcess" />';
var title_task='<fmt:message key="title.request.task" />';
var title_timeCost='<fmt:message key="title.request.timeDetail" />';
var title_historyRecord='<fmt:message key="title.request.requestHistory" />';
var title_problemAssign='<fmt:message key="label.problem.assign" />'
var title_relatedChange='<fmt:message key="title.change.historyChange" />';
var title_solutions='<fmt:message key="title.request.solutions" />';
var queryString='${problemDTO.etitle}';

</script>
<script src="../scripts/itsm/problem/problemDetails.js?random=<%=new java.util.Date().getTime()%>"></script>

<div id="problemDetails_loading" class="loading"><img src="../images/icons/loading.gif" /></div>

<div id="problemDetails_content" class="easyui-panel content" border="none" fit="true">
	
	
	<div class="easyui-layout" fit="true">
		<div region="north" border="false" class="panelTop">
			
		
			&nbsp;<fmt:message key="label.request.requestAction" />&nbsp;:
			
			<c:if test="${problemDTO.statusCode eq 'problem_analyze'}">
				<sec:authorize url="ACTION_PROBLEM_ASSIGN">
				&nbsp;&nbsp;<a id="problems_details_problemAssign_btn"><img src="../images/icons/navigate_right_10.gif" /><fmt:message key="label.problem.assign" /> </a>
				</sec:authorize>
				<sec:authorize url="ACTION_PROBLEM_RESOLVE">
				&nbsp;&nbsp;<a id="problems_details_resolveProblem_btn"><img src="../images/icons/navigate_right_10.gif" /><fmt:message key="label.problem.resolve" /></a>
				</sec:authorize>
			</c:if>
			
			
			<sec:authorize url="ACTION_PROBLEM_SUBMITAPPROVAL">
			
			<c:if test="${problemDTO.statusCode eq 'problem_resolve'}">
				&nbsp;&nbsp;<a id="problems_details_submitProblem_btn"><img src="../images/icons/navigate_right_10.gif" /><fmt:message key="label.problem.submitApproval" /></a>
			</c:if>
			
			</sec:authorize>
			
			
			<sec:authorize url="ACTION_PROBLEM_REVIEW">
			<c:if test="${problemDTO.statusCode eq 'problem_submitApproval'}">
				&nbsp;&nbsp;<a id="problems_details_reviewProblem_btn"><img src="../images/icons/navigate_right_10.gif" /><fmt:message key="label.problem.approval" /></a>
			</c:if>
			</sec:authorize>
			
			<sec:authorize url="ACTION_PROBLEM_CLOSE">
			<c:if test="${problemDTO.statusCode eq 'problem_approvalPass'}">
				&nbsp;&nbsp;<a id="problems_details_closeProblem_btn"><img src="../images/icons/navigate_right_10.gif" /><fmt:message key="label.problem.close" /></a>
			</c:if>
			</sec:authorize>
				&nbsp;|&nbsp;<a icon="icon-search" class="easyui-linkbutton" plain="true"  style="margin-right:10px;" id="problem_details_flowPic_btn"><fmt:message key="label.request.processTracking" /></a>
			<sec:authorize url="/pages/problem!editProblemBaseInfo.action">
				&nbsp;|&nbsp; <a class="easyui-linkbutton"  plain="true" icon="icon-edit" id="problems_details_editProblem_btn"><fmt:message key="common.edit" /></a> 
			</sec:authorize>
			
			
			&nbsp;|&nbsp;<a id="fullsearch_problem_related_event_btn" class="easyui-linkbutton" plain="true" icon="icon-search"><fmt:message key="label.fullsearch.searchRelatedItems" /></a>
			
			
			
		</div>
		
		
		<div  region="west" id="problemDeatil_west" split="true" title="<fmt:message key="common.basicInfo" />" style="width:400px;">
		
			<div class="lineTableBgDiv">
				<form id="problem_basicInfo_form">
				<table style="width:100%" class="lineTable" cellspacing="1">
			
				<tr>
					<td style="width:40%"><fmt:message key="common.title" /></td>
					<td style="width:60%" >${problemDTO.etitle}</td>
				</tr>

				<tr>
					<td><fmt:message key="common.content" /></td>
					<td>${problemDTO.edesc}</td>
				</tr>
				<tr>	
					<td><fmt:message key="common.category" /></td>
					<td>${problemDTO.categoryName}</td>
				</tr>
				
				<tr>
					<td><fmt:message key="common.state" /></td>
					<td>${problemDTO.statusName}</td>
				</tr>
				
				<tr>
					<td><fmt:message key="label.request.priority" /></td>
					<td>${problemDTO.priorityName}</td>
				</tr>
			
				<tr>
					<td><fmt:message key="label.request.effect" /></td>
					<td>${problemDTO.effectRangeName}</td>
				</tr>
				<tr>	
					<td><fmt:message key="label.request.seriousness" /></td>
					<td>${problemDTO.seriousnessName}</td>
				</tr>
				
				<tr>	
					<td><fmt:message key="label.problem.overdueTime" /></td>
					<td><fmt:formatDate type="date" value="${problemDTO.overdueTime}"  pattern="yyyy-MM-dd HH:ss:mm" /></td>
				</tr>
				
				<tr>
					<td><fmt:message key="title.change.assigneGroup" /></td>
					<td>${problemDTO.assigneeGroupName}</td>
				</tr>
						
				<tr>
					<td><fmt:message key="title.change.assigneeTechnician" /></td>
					<td>${problemDTO.assignName}</td>
				</tr>
				

			</table>
			
			</form>
			</div>
		</div>
		
		<!-- 扩展信息 start -->
		<div region="center" title="<fmt:message key="common.detailInfo" />">
		
		
		
			<div class="easyui-tabs" id="problemDetailsMainTab" fit="true" border="false">
			
				<div title='<fmt:message key="common.attachment" />'>
								<div class="hisdiv">
								<table width="100%" cellspacing="1" class="histable">
									<thead>
									<tr>
										<th><fmt:message key="common.id" /></th>
										<th><fmt:message key="label.problem.attachmentName" /></th>
										<th><fmt:message key="label.problem.attachmentUrl" /></th>
										<th><fmt:message key="label.problem.attachmentDownload" /></th>
									</tr>
									</thead>
									<c:forEach items="${problemDTO.attachments}" var="attr" varStatus="i">
									<tr>
										<td>${i.count}</td>
										<td style="text-align:left;padding-left:10px">
											${attr.attachmentName}
										</td>
										<td>
											${attr.url}
										</td>
										<td>
											<a href="attachment!download.action?downloadAttachmentId=${attr.aid}" target="_bank"><fmt:message key="label.problem.attachmentDownload" /></a>
										</td>
									</tr>
									</c:forEach>
								</table>
								</div>
				</div>
				
				
				
				
				<div title='<fmt:message key="label.request.withAssets" />'>
				
					<div class="hisdiv">
							<table width="100%" cellspacing="1" class="histable">
						
							<thead>
							
							<tr>
								<th><fmt:message key="lable.ci.assetNo" /></th>
								<th><fmt:message key="label.name"/> </th>
								<th><fmt:message key="common.category" /></th>
								<th><fmt:message key="common.state" /></th>
							</tr>
							</thead>
							<tbody>
							
							<c:forEach items="${problemDTO.relatedCIS}" var="ci">
							<tr>
								<td>${ci.cino}</td>
								<td><a href="javascript:itsm.common.utility.tabUtility.reOpenTab('ci!findByciId.action?ciEditId=${ci.ciId}','<fmt:message key="ci.configureItemInfo" />')">${ci.ciname}</a></td>
								<td>${ci.category}</td>
								<td>${ci.status}</td>
							</tr>
							
							</c:forEach>
							</tbody>
						</table>
						
					</div>
				
				
				</div>
				
				<div title='<fmt:message key="change.effectService" />'>
					
							<div class="hisdiv">
								<table width="100%" cellspacing="1" class="histable">
									<thead>
										<tr>
										<th style="width:10%"><fmt:message key="common.select" /></th>
										<th style="width:90%"><fmt:message key="setting.serviceDirectory" /></th>
										</tr>
									</thead>
									<tbody>
									<c:forEach items="${problemDTO.serviceDirectoryNames}" var="sd" varStatus="i">
									<tr>
									<td>${i.count}</td>
									<td>${sd}</td>
									</tr>
									</c:forEach>
									</tbody>
									
									</table>
								</div>

						
							
				
				</div>
				
				
				<div title='<fmt:message key="title.historyRequest" />' style="overflow:hidden;padding:3px">
					<table id="problem_relatedRequestGrid"></table>
					<div id="problem_relatedRequestGridPager"></div>
					<div id="problem_relatedRequestToolbar" style="display:none">
					<a class="easyui-linkbutton" plain="true" id="problem_relatedRequestGrid_add" icon="icon-add" ><fmt:message key="label.sla.append" /></a>
					<a class="easyui-linkbutton" plain="true" id="problem_relatedRequestGrid_remove" icon="icon-cancel" ><fmt:message key="label.sla.remove" /></a>
					<a class="easyui-linkbutton" plain="true" id="problem_relatedRequestGrid_fullsearch" icon="icon-search" ><fmt:message key="label.fullsearch.searchRelatedItems" /></a>
					</div>
				</div>
				
				
				
				<div title='<fmt:message key="title.change.historyChange" />' style="padding:12px;font-size:16px">
				
					
						<div id="showRelatedChange" style="display:none"></div>
						
						<div id="showAddRelatedChange" style="display:none">
							<a id="submitCurrentProblemToChange"><fmt:message key="label.problem.relatedChangeTips" /></a>
						</div>
					
					
				</div>
				
				<div title='<fmt:message key="label.problem.problemProcess" />'>
				
					<div class="easyui-tabs" fit="true" border="false">
					
					<div title='<fmt:message key="label.problem.symptom" />'>
						<form id="problem_detail_symptom_form">
						<div class="lineTableBgDiv">
						<table style="width:100%" class="lineTable" cellspacing="1">
							<tr>
							<td style="width:20%"><fmt:message key="label.problem.symptomDesc" /></td>
							<td style="width:80%"><textarea class="textarea" name="commentDTO.remark">${problemDTO.symptom.remark}</textarea></td>
							</tr>
							<tr>
							<td><fmt:message key="common.attachment" /></td>
							<td>
							
							<input type="hidden" name="commentDTO.attachmentStr" id="problem_detail_symptom_attachments_str">
							<input type="file"  name="filedata" id="problem_detail_symptom_attachments_file">
							
							<a style="margin-top:8px;margin-bottom:8px" class="easyui-linkbutton" icon="icon-ok" href="javascript:$('#problem_detail_symptom_attachments_file').uploadifyUpload()" ><fmt:message key="label.attachment.upload" /></a>
							<div id="problem_detail_symptom_attachments_uploaded" style="padding-top:8px">
							
							
							<c:forEach items="${problemDTO.symptom.attachments}" var="attrs">
								
								<div id="symptom_attr_${attrs.aid}" style="padding:3px"><span id="symptom_attr_icon_${attrs.aid}"></span><a href="attachment!download.action?downloadAttachmentId=${attrs.aid}" target="_bank">${attrs.attachmentName}</a> <a onclick="itsm.problem.problemDetails.removeAttr('#symptom_attr_${attrs.aid}','${attrs.aid}','symptom');"><fmt:message key="common.delete" /></a></div>
								<script>$('#symptom_attr_icon_${attrs.aid}').html(itsm.tools.attachIcon.getIcon("${attrs.attachmentName}"));</script>
							
							</c:forEach>
							
							</div>
							
							
							</td>
							</tr>
							<tr>
							<td colspan="2" style="height:50px">
		
								<input type="hidden" name="commentDTO.eno" value="${problemDTO.eno}">
								<a class="easyui-linkbutton" icon="icon-save" id="problem_detail_save_symptom_btn"><fmt:message key="common.save" /></a>
							</td>
							</tr>
							
						</table>
						</div>
						</form>
						
					</div>
					
					<div title='<fmt:message key="label.request.effect" />'>
					
						<form id="problem_detail_effect_form">
						<div class="lineTableBgDiv">
						<table style="width:100%" class="lineTable" cellspacing="1">
							<tr>
							<td><fmt:message key="label.problem.effectDesc" /></td>
							<td style="width:80%"><textarea class="textarea" name="commentDTO.remark">${problemDTO.effects.remark}</textarea></td>
							</tr>
							<tr>
							<td><fmt:message key="common.attachment" /></td>
							<td>
								
								<input type="hidden" name="commentDTO.attachmentStr" id="problem_detail_effect_attachments_str" />
								<input type="file"  name="filedata" id="problem_detail_effect_attachments_file">
								<div style="height:5px"></div>
								<a class="easyui-linkbutton" icon="icon-ok" href="javascript:$('#problem_detail_effect_attachments_file').uploadifyUpload()" ><fmt:message key="label.attachment.upload" /></a>
								<div id="problem_detail_effect_attachments_uploaded"  style="padding-top:8px">
								
								<c:forEach items="${problemDTO.effects.attachments}" var="attrs">
									<div id="effect_attr_${attrs.aid}" style="padding:3px"><span id="effect_attr_icon_${attrs.aid}"></span><a href="attachment!download.action?downloadAttachmentId=${attrs.aid}" target="_bank">${attrs.attachmentName}</a> <a onclick="itsm.problem.problemDetails.removeAttr('#effect_attr_${attrs.aid}','${attrs.aid}','effect');"><fmt:message key="common.delete" /></a></div>
									<script>$('#effect_attr_icon_${attrs.aid}').html(itsm.tools.attachIcon.getIcon("${attrs.attachmentName}"));</script>
								</c:forEach>
								
								</div>
							
							</td>
							</tr>
							
							<tr>
							<td colspan="2" style="height:50px">
								<input type="hidden" name="commentDTO.eno" value="${problemDTO.eno}">
								<a class="easyui-linkbutton" icon="icon-save" id="problem_detail_save_effect_btn"><fmt:message key="common.save" /></a>
							</td>
							</tr>
							
							
						</table>
						</div>
						</form>
					
					</div>
					<div title="<fmt:message key="label.problem.rootCauses" />">
						<form id="problem_detail_rootCauses_form">
						<div class="lineTableBgDiv">
						<table style="width:100%" class="lineTable" cellspacing="1">
							<tr>
							<td><fmt:message key="label.problem.rootCausesDesc" /></td>
							<td style="width:80%"><textarea class="textarea" name="commentDTO.remark">${problemDTO.rootCauses.remark}</textarea></td>
							</tr>
							<tr>
							<td><fmt:message key="common.attachment" /></td>
							<td>
							
								<input type="hidden" name="commentDTO.attachmentStr" id="problem_detail_rootCauses_attachments_str">
								<input type="file"  name="filedata" id="problem_detail_rootCauses_attachments_file">
								<div style="height:5px"></div>
								<a class="easyui-linkbutton" icon="icon-ok" href="javascript:$('#problem_detail_rootCauses_attachments_file').uploadifyUpload()" ><fmt:message key="label.attachment.upload" /></a>
								<div id="problem_detail_rootCauses_attachments_uploaded"  style="padding-top:8px">
									<c:forEach items="${problemDTO.rootCauses.attachments}" var="attrs">
									<div id="rootCauses_attr_${attrs.aid}" style="padding:3px"><span id="rootCauses_attr_icon_${attrs.aid}"></span><a href="attachment!download.action?downloadAttachmentId=${attrs.aid}" target="_bank">${attrs.attachmentName}</a> <a onclick="itsm.problem.problemDetails.removeAttr('#rootCauses_attr_${attrs.aid}','${attrs.aid}','rootCauses');"><fmt:message key="common.delete" /></a></div>
									<script>$('#rootCauses_attr_icon_${attrs.aid}').html(itsm.tools.attachIcon.getIcon("${attrs.attachmentName}"));</script>
									
									</c:forEach>
								</div>
								
							</td>
							</tr>
							<tr>
							<td colspan="2" style="height:50px">
								<input type="hidden" name="commentDTO.eno" value="${problemDTO.eno}">
								<a class="easyui-linkbutton" icon="icon-save" id="problem_detail_save_rootCauses_btn"><fmt:message key="common.save" /></a>
							</td>
							</tr>
							
						</table>
						</div>
						</form>
					</div>
					<div title='<fmt:message key="label.problem.alternatives" />'>
					
						<form id="problem_detail_alternatives_form">
						<div class="lineTableBgDiv">
						<table style="width:100%" class="lineTable" cellspacing="1">
							<tr>
							<td><fmt:message key="label.problem.alternativesDesc" /></td>
							<td><textarea class="textarea" name="problemDTO.alternatives">${problemDTO.alternatives}</textarea></td>
							</tr>
							<tr>
							<td colspan="2" style="height:50px">
								<input type="hidden" name="problemDTO.eno" value="${problemDTO.eno}">
								<a class="easyui-linkbutton" icon="icon-save" id="problem_detail_save_alternatives_btn"><fmt:message key="common.save" /></a>
							</td>
							</tr>
							
						</table>
						</div>
						</form>
					
					</div>
					
					</div>
				
				</div>
				
				
				
				
			
				
				<div title='<fmt:message key="title.request.solutions" />'>
					
					
					
					<form id="problem_detail_solutions_form">
						<div class="lineTableBgDiv">
						<table style="width:100%" class="lineTable" cellspacing="1">
						
						
							<tr>
								<td><fmt:message key="common.title" /></td>
								<td style="width:80%"><input name="knowledgeDTO.title" class="input" value="${problemDTO.problemSolutionDTO.title}"></td>
							</tr>
						
							<tr>
							<td><fmt:message key="label.problem.solutionDesc" /></td>
							<td><textarea class="textarea" name="knowledgeDTO.content">${problemDTO.problemSolutionDTO.content}</textarea></td>
							</tr>
							<tr>
							<td><fmt:message key="common.attachment" /></td>
							<td>
								
								<input type="hidden" name="knowledgeDTO.attachmentStr" id="problem_detail_solutions_attachments_str" />
								<input type="file"  name="filedata" id="problem_detail_solutions_attachments_file">
								<div style="height:5px"></div>
								<a class="easyui-linkbutton" icon="icon-ok" href="javascript:$('#problem_detail_solutions_attachments_file').uploadifyUpload()" ><fmt:message key="label.attachment.upload" /></a>
								<div id="problem_detail_solutions_attachments_uploaded"  style="padding-top:8px">
								
								<c:forEach items="${problemDTO.problemSolutionDTO.attachments}" var="attrs">
									<div id="solutions_attr_${attrs.aid}" style="padding:3px"><span id="solutions_attr_icon_${attrs.aid}"></span><a href="attachment!download.action?downloadAttachmentId=${attrs.aid}" target="_bank">${attrs.attachmentName}</a> <a onclick="itsm.problem.problemDetails.removeAttr('#solutions_attr_${attrs.aid}','${attrs.aid}','solutions');"><fmt:message key="common.delete" /></a></div>
									<script>$('#solutions_attr_icon_${attrs.aid}').html(itsm.tools.attachIcon.getIcon("${attrs.attachmentName}"));</script>
								</c:forEach>
								 
								</div>
							
							</td>
							</tr>
							
							<tr>
							<td colspan="2" style="height:50px">
								<input type="hidden" name="problemNo" value="${problemDTO.eno}">
								<a class="easyui-linkbutton" icon="icon-save" id="problem_detail_save_solutions_btn"><fmt:message key="common.save" /></a>
							</td>
							</tr>
							
							
						</table>
						</div>
						</form>
					
					</div>
					
				
				
				<div title='<fmt:message key="title.request.task" />' style="padding:3px" >
					<table id="problemTaskGrid" ></table>
					<div id="problemTaskGridPager"></div>
			
					<div id="problemTaskGridToolbar" style="display: none">
							<a class="easyui-linkbutton" plain="true" icon="icon-add" id="problemTaskGrid_add"><fmt:message key="common.add"/></a>
							<a class="easyui-linkbutton" plain="true" icon="icon-edit" id="problemTaskGrid_edit"><fmt:message key="common.edit"/></a>
							<a class="easyui-linkbutton" plain="true" icon="icon-cancel" id="problemTaskGrid_delete"><fmt:message key="common.delete"/></a>
					</div>
					
				</div>
				
				
				<div title='<fmt:message key="title.request.timeDetail" />' style="padding:3px">
				
					<table id="problemTimeCostGrid" ></table>
					<div id="problemTimeCostGridPager"></div>
			
					<div id="problemTimeCostGridToolbar" style="display: none">
							<a class="easyui-linkbutton" plain="true" icon="icon-add" id="problemTimeCostGrid_add"><fmt:message key="common.add"/></a>
							<a class="easyui-linkbutton" plain="true" icon="icon-edit" id="problemTimeCostGrid_edit"><fmt:message key="common.edit"/></a>
							<a class="easyui-linkbutton" plain="true" icon="icon-cancel" id="problemTimeCostGrid_delete"><fmt:message key="common.delete"/></a>
					</div>
				
				
				
				
				</div>
				
				<div title='<fmt:message key="title.request.requestHistory" />'>
				
				
					<div class="hisdiv">
							<table id="problemHistoryRecord" class="histable" style="width:100%" cellspacing="1">
								<thead>
									<tr>
									<th style="width: 10%" ><fmt:message key="label.steps" /></th>
									<th style="width: 20%" ><fmt:message key="label.request.requestAction" /></th>
									<th style="width: 40%" ><fmt:message key="label.details" /></th>
									<th style="width: 10%" ><fmt:message key="label.operator" /></th>
									<th style="width: 20%" ><fmt:message key="label.operateTime" /></th>
									</tr>
								</thead>
								<tbody></tbody>
							</table>
						</div>
				
				
				
				</div>
				
			
			
			</div>
			
			
			
		</div>	
		<!-- 扩展信息 end -->

	</div>
	
	
	
	<!-- 问题指派-->
	<div id="problemDetails_action_problemAssign_window" class="easyui-window" closed="true" modal="true"  title='<fmt:message key="label.problem.assign" />' minimizable="false" maximizable="false" collapsible="false" style="width:380px;height:auto">
		<form>
			<div class="lineTableBgDiv">
				<table style="width:100%" class="lineTable" cellspacing="1">
				
					<tr>
						<td><fmt:message key="title.change.assigneGroup" />&nbsp;<span style="color:red">*</span></td>
						<td>
						<input class="choose" id="problemDetails_action_problemAssign_groupName" readonly>
						<input type="hidden" id="problemDetails_action_problemAssign_groupNo" name="padto.groupNo">
						</td>
					</tr>
				
					<tr>
						<td><fmt:message key="title.change.assigneeTechnician" />&nbsp;<span style="color:red">*</span></td>
						<td>
						<input class="choose" id="problemDetails_action_problemAssign_tcName" readonly>
						<input type="hidden" id="problemDetails_action_problemAssign_tcNo" name="padto.tcNo">
						</td>
					</tr>
					
					<tr>
						<td><fmt:message key="common.remark" /></td>
						<td>
						<textarea class="textarea" name="padto.remark"></textarea>
						</td>
					</tr>
				
					<tr>
						<td colspan="2">
							<input type="hidden" name="padto.eno" value="${problemDTO.eno}"/>
							<input type="hidden" name="padto.pid" value="${problemDTO.pid}"/>
							<a class="easyui-linkbutton" plain="false" id="problemDetails_action_problemAssign_confirmBtn" icon="icon-ok"><fmt:message key="common.submit" /></a>
						</td>
					</tr>
				</table>
			</div>
		</form>
	</div>
	
	
	<!--解决问题、提交审批、关闭问题-->
	<div id="problemDetails_action_resolveProblem_window" class="easyui-window" closed="true" modal="true"  title='<fmt:message key="label.problem.resolve" />' minimizable="false" maximizable="false" collapsible="false" style="width:380px;height:auto">
		<form>
			<div class="lineTableBgDiv">
				<table style="width:100%" class="lineTable" cellspacing="1">
					<tr>
						<td><fmt:message key="common.remark" /></td>
						<td>
						<textarea class="textarea" name="padto.remark"></textarea>
						</td>
					</tr>
				
					<tr>
						<td colspan="2">
							<input type="hidden" name="padto.eno" value="${problemDTO.eno}"/>
							<input type="hidden" name="padto.pid" value="${problemDTO.pid}"/>
							<input type="hidden" name="padto.actionFlag" id="padto_actionFlag" />
							<a class="easyui-linkbutton" plain="false" id="problemDetails_action_resolveProblem_confirmBtn" icon="icon-ok"><fmt:message key="common.submit" /></a>
						</td>
					</tr>
				</table>
			</div>
		</form>
	</div>
	
	
	<!-- 审批问题 -->
	<div id="problemDetails_action_reviewProblem_window" class="easyui-window" closed="true" modal="true"  title='<fmt:message key="label.problem.approval" />' minimizable="false" maximizable="false" collapsible="false" style="width:380px;height:auto">
		<form>
			<div class="lineTableBgDiv">
				<table style="width:100%" class="lineTable" cellspacing="1">
					<tr>
						<td><fmt:message key="title.problem.approvalOpioion" />&nbsp;<span style="color:red">*</span></td>
						<td>
						<input type="radio" name="padto.reviewOpinions" value="pass" checked><fmt:message key="label.problem.approvalPass" /><br/>
						<input type="radio" name="padto.reviewOpinions" value="backAnalyze"><fmt:message key="label.problem.approvalBackAnalyze" /><br/>
						<input type="radio" name="padto.reviewOpinions" value="backResolve"><fmt:message key="label.problem.approvalBackResolve" />
						</td>
					</tr>
					<tr>
						<td><fmt:message key="common.remark" /></td>
						<td>
						<textarea class="textarea" name="padto.remark"></textarea>
						</td>
					</tr>
				
					<tr>
						<td colspan="2">
							<input type="hidden" name="padto.eno" value="${problemDTO.eno}"/>
							<input type="hidden" name="padto.pid" value="${problemDTO.pid}"/>
							<input type="hidden" name="padto.actionFlag" value="reviewProblem"/>
							<a class="easyui-linkbutton" plain="false" id="problemDetails_action_reviewProblem_confirmBtn" icon="icon-ok"><fmt:message key="common.submit" /></a>
						</td>
					</tr>
				</table>
			</div>
		</form>
	</div>
	
	
	
</div>